/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.bitel.common.util.Matcher;

public class TimeoutMapOld<K, V> {
    private static final Logger logger = Logger.getLogger(TimeoutMapOld.class);
    private final ConcurrentMap<K, V> map;
    private final Queue<K> queue;
    private final Matcher<K> matcher;
    private final Runnable worker;

    public TimeoutMapOld(Matcher<K> matcher, ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit unit) {
        if (matcher == null) {
            throw new IllegalArgumentException();
        }
        this.map = new ConcurrentHashMap();
        this.queue = new LinkedBlockingQueue<K>();
        this.matcher = matcher;
        this.worker = new MatcherWorker();
        scheduledExecutorService.scheduleWithFixedDelay(this.worker, initialDelay, period, unit);
    }

    public TimeoutMapOld(DelayQueue<?> queue, ScheduledExecutorService scheduledExecutorService, long initialDelay, long period, TimeUnit unit) {
        this.map = new ConcurrentHashMap();
        this.queue = queue;
        this.matcher = null;
        this.worker = new Worker();
        scheduledExecutorService.scheduleWithFixedDelay(this.worker, initialDelay, period, unit);
    }

    public TimeoutMapOld(BlockingQueue<K> queue, String workerName) {
        this.map = new ConcurrentHashMap();
        this.queue = queue;
        this.matcher = null;
        this.worker = new ThreadWorker();
        new Thread(this.worker, workerName).start();
    }

    public void put(K key, V value) {
        this.map.put(key, value);
        this.queue.add(key);
    }

    public V remove(K key) {
        return this.map.remove(key);
    }

    public boolean remove(K key, V value) {
        return this.map.remove(key, value);
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                Object k;
                Queue queue = TimeoutMapOld.this.queue;
                while ((k = queue.poll()) != null) {
                    TimeoutMapOld.this.map.remove(k);
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
    }

    private class MatcherWorker
    implements Runnable {
        private MatcherWorker() {
        }

        @Override
        public void run() {
            try {
                Object k;
                Queue queue = TimeoutMapOld.this.queue;
                while ((k = queue.peek()) != null && TimeoutMapOld.this.matcher.matched(k)) {
                    k = queue.poll();
                    TimeoutMapOld.this.map.remove(k);
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
    }

    private class ThreadWorker
    implements Runnable {
        private ThreadWorker() {
        }

        @Override
        public void run() {
            BlockingQueue queue = (BlockingQueue)TimeoutMapOld.this.queue;
            while (true) {
                try {
                    while (true) {
                        Object k = queue.take();
                        TimeoutMapOld.this.map.remove(k);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
    }
}

