/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.xml;

import java.beans.Introspector;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.ref.ConcurrentReferenceHashMap;
import ru.bitel.common.xml.strategy.ActionMarshallerStrategy;

public class JAXBUtils {
    private static final ConcurrentReferenceHashMap<JAXBKey, JAXBContext> JAXBCACHE_MAP = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public static <T> JAXBContext getContext(Class<?> ... type) throws JAXBException {
        JAXBKey key = new JAXBKey(type);
        JAXBContext result = JAXBCACHE_MAP.get(key);
        if (result != null) {
            return result;
        }
        result = JAXBContext.newInstance((Class[])type);
        JAXBCACHE_MAP.put(key, result);
        return result;
    }

    private static Marshaller newMarshaller(Object jaxbObject, Class<?> clazz) {
        try {
            JAXBContext context = jaxbObject instanceof JAXBElement ? (clazz != null ? JAXBUtils.getContext(((JAXBElement)jaxbObject).getDeclaredType(), clazz, Id.class, IdTitle.class, ru.bitel.common.model.Result.class) : JAXBUtils.getContext(((JAXBElement)jaxbObject).getDeclaredType(), Id.class, IdTitle.class, ru.bitel.common.model.Result.class)) : (clazz != null ? JAXBUtils.getContext(jaxbObject.getClass(), clazz, Id.class, IdTitle.class, ru.bitel.common.model.Result.class) : JAXBUtils.getContext(jaxbObject.getClass(), Id.class, IdTitle.class, ru.bitel.common.model.Result.class));
            return new ActionMarshallerStrategy().newMarshaller(context);
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private static Object jaxbWrap(Object jaxbObject) {
        Class<?> clazz;
        XmlRootElement r;
        if (!(jaxbObject instanceof JAXBElement) && (r = (clazz = jaxbObject.getClass()).getAnnotation(XmlRootElement.class)) == null) {
            return new JAXBElement(new QName(Introspector.decapitalize(clazz.getSimpleName())), clazz, jaxbObject);
        }
        return jaxbObject;
    }

    public static void marshal(Object jaxbObject, Result result) {
        try {
            JAXBUtils.newMarshaller(jaxbObject, null).marshal(JAXBUtils.jaxbWrap(jaxbObject), result);
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    public static void marshal(Object jaxbObject, Node node) {
        try {
            JAXBUtils.newMarshaller(jaxbObject, null).marshal(JAXBUtils.jaxbWrap(jaxbObject), node);
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    public static <T> void marshal(ru.bitel.common.model.Result<T> jaxbObject, Class<T> clazz, Node node) {
        try {
            JAXBUtils.newMarshaller(jaxbObject, clazz).marshal(JAXBUtils.jaxbWrap(jaxbObject), node);
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    public static <T> T unmarshal(Node node, String expression, Class<T> clazz) {
        return (T)JAXB.unmarshal((Source)new DOMSource(XMLUtils.selectElement(node, expression)), clazz);
    }

    public static <T> ru.bitel.common.model.Result<T> unmarshalResult(Document doc, Class<T> clazz) {
        try {
            JAXBElement item = JAXBUtils.getContext(ru.bitel.common.model.Result.class, Id.class, IdTitle.class, clazz).createUnmarshaller().unmarshal((Source)new DOMSource(XMLUtils.selectElement(doc, "/data/*[namespace-uri()='http://common.bitel.ru' and local-name()='result']")), ru.bitel.common.model.Result.class);
            return (ru.bitel.common.model.Result)item.getValue();
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    public static class PeriodWithTimeAdapter
    extends XmlAdapter<String, PeriodWithTime> {
        private static final String delim = "|";

        public String marshal(PeriodWithTime periodWithTime) throws Exception {
            if (periodWithTime != null) {
                StringBuilder builder = new StringBuilder();
                Calendar c = TimeUtils.convertLocalDateTimeToCalendar(periodWithTime.getLocalDateTimeFrom());
                if (c != null) {
                    builder.append(DatatypeConverter.printDateTime((Calendar)c));
                }
                builder.append(delim);
                c = TimeUtils.convertLocalDateTimeToCalendar(periodWithTime.getLocalDateTimeTo());
                if (c != null) {
                    builder.append(DatatypeConverter.printDateTime((Calendar)c));
                }
                return builder.toString();
            }
            return null;
        }

        public PeriodWithTime unmarshal(String v) throws Exception {
            PeriodWithTime period = new PeriodWithTime();
            if (v != null && v.indexOf(delim) > 0) {
                period.setLocalDateTimeFrom(TimeUtils.convertDateToLocalDateTime(DatatypeConverter.parseDateTime((String)v.substring(0, v.indexOf(delim))).getTime()));
            }
            if (v != null && v.indexOf(delim) + 1 != v.length()) {
                period.setLocalDateTimeTo(TimeUtils.convertDateToLocalDateTime(DatatypeConverter.parseDateTime((String)v.substring(v.indexOf(delim) + 1)).getTime()));
            }
            return period;
        }
    }

    public static class PeriodAdapter
    extends XmlAdapter<String, Period> {
        private static final String delim = "|";

        public String marshal(Period v) throws Exception {
            if (v != null) {
                StringBuilder builder = new StringBuilder();
                Calendar c = v.getDateFromCalendar();
                if (c != null) {
                    builder.append(DatatypeConverter.printDate((Calendar)c));
                }
                builder.append(delim);
                c = v.getDateToCalendar();
                if (c != null) {
                    builder.append(DatatypeConverter.printDate((Calendar)c));
                }
                return builder.toString();
            }
            return null;
        }

        public Period unmarshal(String v) throws Exception {
            Period period = new Period();
            if (v != null && v.indexOf(delim) > 0) {
                period.setDateFrom(DatatypeConverter.parseDate((String)v.substring(0, v.indexOf(delim))).getTime());
            }
            if (v != null && v.indexOf(delim) + 1 != v.length()) {
                period.setDateTo(DatatypeConverter.parseDate((String)v.substring(v.indexOf(delim) + 1)).getTime());
            }
            return period;
        }
    }

    public static class LocalDateAdapter
    extends XmlAdapter<String, LocalDate> {
        public String marshal(LocalDate v) throws Exception {
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        public LocalDate unmarshal(String v) throws Exception {
            return LocalDate.parse(v);
        }
    }

    public static class DateAdapter
    extends XmlAdapter<String, Date> {
        public String marshal(Date v) throws Exception {
            if (v != null) {
                GregorianCalendar c = new GregorianCalendar(0, 0, 0);
                c.setTime(v);
                return DatatypeConverter.printDate((Calendar)c);
            }
            return null;
        }

        public Date unmarshal(String v) throws Exception {
            return DatatypeConverter.parseDate((String)v).getTime();
        }
    }

    public static class SummaAdapter
    extends XmlAdapter<String, BigDecimal> {
        public String marshal(BigDecimal v) throws Exception {
            if (v != null) {
                return Utils.formatBigDecimal(v, 2);
            }
            return null;
        }

        public BigDecimal unmarshal(String v) throws Exception {
            return new BigDecimal(v);
        }
    }

    public static class DateTimeAdapter
    extends XmlAdapter<String, Date> {
        public String marshal(Date v) throws Exception {
            if (v != null) {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(v);
                return DatatypeConverter.printDateTime((Calendar)c);
            }
            return null;
        }

        public Date unmarshal(String v) throws Exception {
            return DatatypeConverter.parseDateTime((String)v).getTime();
        }
    }

    private static final class JAXBKey {
        final Class<?>[] type;

        public JAXBKey(Class<?> ... type) throws JAXBException {
            this.type = type;
        }

        public int hashCode() {
            return Arrays.hashCode(this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            JAXBKey other = (JAXBKey)obj;
            return Arrays.equals(this.type, other.type);
        }
    }
}

