/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.Event;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.event.AreaModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.CityModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.HouseModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.QuarterModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.StreetModifiedEvent;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrHouse;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrInt;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrText;
import ru.bitel.oss.kernel.entity.server.bean.ContractDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.ContractObjectDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrAddressDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrBooleanDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrContractDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDateDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrEmailDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrHouseDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrIntDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrListDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrMultiListDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrPhoneDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrTextDao;

public abstract class AbstractEntityAttrDao<E extends Id>
extends AbstractIdDao<E> {
    private static final Logger logger = Logger.getLogger(AbstractEntityAttrDao.class);
    protected static final EntityAttrDaoSupport ENTITY_SUPPORT = new EntityAttrDaoSupport();
    protected static final EntityAttrDaoSupport CONTRACT_SUPPORT = new ContractDaoSupport();
    protected static final EntityAttrDaoSupport CONTRACT_OBJECT_SUPPORT = new ContractObjectDaoSupport();
    final EntityAttrDaoSupport support;
    private final EntityAttrTextDao textDao;
    private final EntityAttrIntDao intDao;
    private final EntityAttrListDao listDao;
    private final EntityAttrDateDao dateDao;
    private final EntityAttrHouseDao houseDao;
    private final EntityAttrAddressDao addressDao;
    private final EntityAttrMultiListDao multiListDao;
    private final EntityAttrEmailDao emailDao;
    private final EntityAttrContractDao contractDao;
    private final EntityAttrBooleanDao booleanDao;
    private final EntityAttrPhoneDao phoneDao;
    protected final int userId;
    protected Directory<? extends Id> entitySpecDirectory;
    protected Directory<? extends EntitySpecAttr> entitySpecAttrDirectory;
    private PreparedStatement selectOldValuePS;
    private PreparedStatement deleteAttributesPS = null;
    protected static final Comparator<FilterEntityAttr> filterWeightComparator = new Comparator<FilterEntityAttr>(){

        private int getWeight(FilterEntityAttr o) {
            if (o instanceof FilterEntityAttrInt) {
                return 0;
            }
            if (o instanceof FilterEntityAttrHouse) {
                return 1;
            }
            if (o instanceof FilterEntityAttrContract) {
                return 2;
            }
            if (o instanceof FilterEntityAttrList) {
                return 3;
            }
            if (o instanceof FilterEntityAttrDate) {
                return 4;
            }
            if (o instanceof FilterEntityAttrText) {
                return 5;
            }
            if (o instanceof FilterEntityAttrAddress) {
                return 6;
            }
            if (o instanceof FilterEntityAttrEmail) {
                return 7;
            }
            if (o instanceof FilterEntityAttrBoolean) {
                return 8;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int compare(FilterEntityAttr o1, FilterEntityAttr o2) {
            return this.getWeight(o1) - this.getWeight(o2);
        }
    };
    private static final Executor executor = WorkerTask.newFixedThreadPool("AddressUpdater", null, null, 1, 30, new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    });

    public AbstractEntityAttrDao(Connection con, int mid, int userId, String tableName, EntityAttrDaoSupport support) {
        super(con, mid, tableName);
        this.userId = userId;
        this.support = support;
        this.textDao = support.newTextDao(con, this);
        this.intDao = support.newIntDao(con, this);
        this.listDao = support.newListDao(con, this);
        this.dateDao = support.newDateDao(con, this);
        this.houseDao = support.newHouseDao(con, this);
        this.addressDao = support.newAddressDao(con, this);
        this.multiListDao = support.newMultiListDao(con, this);
        this.emailDao = support.newEmailDao(con, this);
        this.contractDao = support.newContractDao(con, this);
        this.booleanDao = support.newBooleanDao(con, this);
        this.phoneDao = support.newPhoneDao(con, this);
    }

    public Directory<? extends Id> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(EntitySpec.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    protected Directory<? extends EntitySpecAttr> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(EntitySpecAttr.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    protected EntityAttr getAttribute(int entityId, EntitySpecAttr spec) throws BGException {
        EntityAttr result = null;
        try {
            switch (EntitySpecAttrType.getEntitySpecAttrType(spec.getType())) {
                case TEXT: {
                    result = this.textDao.get(entityId, spec.getId());
                    break;
                }
                case INT: {
                    result = this.intDao.get(entityId, spec.getId());
                    break;
                }
                case BOOLEAN: {
                    result = this.booleanDao.get(entityId, spec.getId());
                    break;
                }
                case LIST: {
                    result = this.listDao.get(entityId, spec.getId());
                    break;
                }
                case DATE: {
                    result = this.dateDao.get(entityId, spec.getId());
                    break;
                }
                case HOUSE: {
                    result = this.houseDao.get(entityId, spec.getId());
                    break;
                }
                case ADDRESS: {
                    result = this.addressDao.get(entityId, spec.getId());
                    break;
                }
                case EMAIL: {
                    result = this.emailDao.get(entityId, spec.getId());
                    break;
                }
                case CONTRACT: {
                    result = this.contractDao.get(entityId, spec.getId());
                    break;
                }
                case PHONE: {
                    result = this.phoneDao.get(entityId, spec.getId());
                    break;
                }
                case MULTILIST: {
                    result = this.multiListDao.get(entityId, spec.getId());
                    break;
                }
                default: {
                    result = null;
                    logger.error((Object)("Unknown specAttrType=" + spec.getType()));
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    protected Map<Integer, EntityAttr> getEntityAttributes(int entirySpecId, int entityId, boolean fullMap) throws BGException {
        if (entirySpecId <= 0) {
            return null;
        }
        Directory<Id> dir = this.getEntitySpecDirectory();
        EntitySpec spec = (EntitySpec)dir.get(entirySpecId);
        if (spec == null) {
            return null;
        }
        LinkedHashMap<Integer, EntityAttr> result = new LinkedHashMap<Integer, EntityAttr>(spec.getAttributeList().size());
        for (EntitySpecAttr sa : spec.getAttributeList()) {
            EntityAttr a2 = this.getAttribute(entityId, sa);
            if (a2 != null) {
                result.put(a2.getEntitySpecAttrId(), a2);
                continue;
            }
            if (!fullMap) continue;
            result.put(sa.getId(), EntityAttr.newInstance(sa.getType(), entityId, sa.getId()));
        }
        return result;
    }

    protected Map<Integer, EntityAttr> getAllEntityAttributes(int entityId, boolean fullMap) throws BGException {
        List<EntitySpecAttr> list = this.getEntitySpecAttrDirectory().list();
        LinkedHashMap<Integer, EntityAttr> result = new LinkedHashMap<Integer, EntityAttr>(list.size());
        for (EntitySpecAttr entitySpecAttr : list) {
            EntityAttr entityAttr = this.getAttribute(entityId, entitySpecAttr);
            if (entityAttr != null) {
                result.put(entityAttr.getEntitySpecAttrId(), entityAttr);
                continue;
            }
            if (!fullMap) continue;
            result.put(entitySpecAttr.getId(), EntityAttr.newInstance(entitySpecAttr.getType(), entityId, entitySpecAttr.getId()));
        }
        return result;
    }

    protected Map<Integer, String> getEntityValueForIds(int entityId, Set<Integer> ids) throws BGException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        List<EntitySpecAttr> list = this.getEntitySpecAttrDirectory().list();
        for (Integer id : ids) {
            String value = "";
            for (EntitySpecAttr entitySpecAttr : list) {
                EntityAttr entityAttr;
                if (entitySpecAttr.getId() != id.intValue() || (entityAttr = this.getAttribute(entityId, entitySpecAttr)) == null) continue;
                value = entityAttr.toString();
                break;
            }
            result.put(id, value);
        }
        return result;
    }

    protected EntityAttr getEntityAttribute(int entityId, int entityAttrId) throws BGException {
        if (entityAttrId <= 0) {
            return null;
        }
        Directory<EntitySpecAttr> dir = this.getEntitySpecAttrDirectory();
        EntitySpecAttr specAttr = dir.get(entityAttrId);
        if (specAttr == null) {
            return null;
        }
        return this.getAttribute(entityId, specAttr);
    }

    PreparedStatement getSelectOldValuePS() throws SQLException {
        if (this.selectOldValuePS == null) {
            this.selectOldValuePS = this.con.prepareStatement("SELECT @oldValue");
        }
        return this.selectOldValuePS;
    }

    protected boolean updateEntityAttribute(int entityId, EntityAttr entityAttr) throws SQLException, BGException {
        if (entityAttr == null) {
            return false;
        }
        Directory<EntitySpecAttr> dir = this.getEntitySpecAttrDirectory();
        EntitySpecAttr entitySpecAttr = dir.get(entityAttr.getEntitySpecAttrId());
        if (entitySpecAttr != null) {
            switch (EntitySpecAttrType.getEntitySpecAttrType(entitySpecAttr.getType())) {
                case TEXT: {
                    return this.textDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case INT: {
                    return this.intDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case BOOLEAN: {
                    return this.booleanDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case LIST: {
                    return this.listDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case DATE: {
                    return this.dateDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case HOUSE: {
                    return this.houseDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case ADDRESS: {
                    return this.addressDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case EMAIL: {
                    return this.emailDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case CONTRACT: {
                    return this.contractDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case PHONE: {
                    return this.phoneDao.update(entityId, entitySpecAttr, entityAttr);
                }
                case MULTILIST: {
                    return this.multiListDao.update(entityId, entitySpecAttr, entityAttr);
                }
            }
            throw new IllegalArgumentException();
        }
        return false;
    }

    public boolean checkEntitySpecAttrDelete(int entitySpecAttrId) throws BGException {
        Directory<EntitySpecAttr> dir = this.getEntitySpecAttrDirectory();
        EntitySpecAttr entitySpecAttr = dir.get(entitySpecAttrId);
        try {
            switch (EntitySpecAttrType.getEntitySpecAttrType(entitySpecAttr.getType())) {
                case TEXT: {
                    return this.textDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case INT: {
                    return this.intDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case BOOLEAN: {
                    return this.booleanDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case LIST: {
                    return this.listDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case DATE: {
                    return this.dateDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case HOUSE: {
                    return this.houseDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case ADDRESS: {
                    return this.addressDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case EMAIL: {
                    return this.emailDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case CONTRACT: {
                    return this.contractDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case PHONE: {
                    return this.phoneDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
                case MULTILIST: {
                    return this.multiListDao.checkEntitySpecAttrDelete(entitySpecAttrId);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    protected void updateEntityAttributes(int entityId, Map<Integer, EntityAttr> entityAttributes) throws BGException, SQLException {
        Directory<EntitySpecAttr> dir = this.getEntitySpecAttrDirectory();
        PreparedStatement ps = this.deleteAttributesPS;
        if (ps == null) {
            StringBuilder query = new StringBuilder(100);
            query.append("DELETE FROM ").append(this.textDao.table).append(", ");
            if (this.intDao != null) {
                query.append(this.intDao.table).append(", ");
            }
            if (this.booleanDao != null) {
                query.append(this.booleanDao.table).append(", ");
            }
            if (this.listDao != null) {
                query.append(this.listDao.table).append(", ");
            }
            if (this.houseDao != null) {
                query.append(this.houseDao.table).append(", ");
            }
            if (this.addressDao != null) {
                query.append(this.addressDao.table).append(", ");
            }
            if (this.contractDao != null) {
                query.append(this.contractDao.table).append(", ");
            }
            query.append(this.dateDao.table);
            query.append(" USING ").append(this.tableName);
            String tableNameDotBeanId = this.tableName + '.' + this.support.beanIdName();
            String dotIdDotTableNameDotBeanId = '.' + this.support.idName() + '=' + this.tableName + '.' + this.support.beanIdName();
            query.append(" LEFT JOIN ").append(this.textDao.table).append(" ON ").append(this.textDao.table).append(dotIdDotTableNameDotBeanId);
            if (this.intDao != null) {
                query.append(" LEFT JOIN ").append(this.intDao.table).append(" ON ").append(this.intDao.table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.listDao != null) {
                query.append(" LEFT JOIN ").append(this.listDao.table).append(" ON ").append(this.listDao.table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.contractDao != null) {
                query.append(" LEFT JOIN ").append(this.contractDao.table).append(" ON ").append(this.contractDao.table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.houseDao != null) {
                query.append(" LEFT JOIN ").append(this.houseDao.table).append(" ON ").append(this.houseDao.table).append(dotIdDotTableNameDotBeanId);
            }
            if (this.addressDao != null) {
                query.append(" LEFT JOIN ").append(this.addressDao.table).append(" ON ").append(this.addressDao.table).append(dotIdDotTableNameDotBeanId);
            }
            query.append(" LEFT JOIN ").append(this.dateDao.table).append(" ON ").append(this.dateDao.table).append(dotIdDotTableNameDotBeanId);
            query.append(" WHERE ").append(tableNameDotBeanId).append("=?");
            ps = this.deleteAttributesPS = this.con.prepareStatement(query.toString());
        }
        ps.setInt(1, entityId);
        ps.executeUpdate();
        if (entityAttributes == null || entityAttributes.size() == 0) {
            return;
        }
        block12: for (EntityAttr entityAttr : entityAttributes.values()) {
            EntitySpecAttr entitySpecAttr = dir.get(entityAttr.getEntitySpecAttrId());
            switch (EntitySpecAttrType.getEntitySpecAttrType(entitySpecAttr.getType())) {
                case TEXT: {
                    this.textDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case INT: {
                    this.intDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case LIST: {
                    this.listDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case DATE: {
                    this.dateDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case HOUSE: {
                    this.houseDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case ADDRESS: {
                    this.addressDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case EMAIL: {
                    this.emailDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case CONTRACT: {
                    this.contractDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case PHONE: {
                    this.phoneDao.insert(entityId, entityAttr);
                    continue block12;
                }
                case MULTILIST: {
                    this.multiListDao.insert(entityId, entityAttr);
                    continue block12;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    protected List<E> list(boolean loadAttributes, Page page, String what, String join, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        try {
            what = "DISTINCT SQL_CALC_FOUND_ROWS " + (what == null ? this.tableName + ".*" : what);
            List<E> result = this.listImpl(loadAttributes, page, what, join, null, entityFilter, filter, groupBy, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    public List<FilterEntityAttr> filterInit(List<FilterEntityAttr> entityFilter) {
        if (entityFilter == null) {
            entityFilter = Collections.emptyList();
        } else if (entityFilter.size() > 1) {
            if (!(entityFilter instanceof ArrayList)) {
                entityFilter = new ArrayList<FilterEntityAttr>(entityFilter);
            }
            Collections.sort(entityFilter, filterWeightComparator);
        }
        return entityFilter;
    }

    protected String getEntityTableName() {
        return this.tableName;
    }

    protected List<E> listImpl(boolean loadAttributes, Page page, String what, String join1, String join2, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        StringBuilder query = new StringBuilder(128);
        try {
            entityFilter = this.filterInit(entityFilter);
            Collections.sort(entityFilter, filterWeightComparator);
            query.append("SELECT ").append(what).append(" FROM ").append(this.tableName);
            if (join1 != null) {
                query.append('\n').append(join1);
            }
            if (join2 != null) {
                query.append('\n').append(join2);
            }
            StringBuilder where = new StringBuilder(64);
            this.filterJoin(query, "", where, entityFilter);
            if (filter != null && filter.length() > 0 || where.length() > 0) {
                query.append("\n WHERE ");
                if (filter != null && filter.length() > 0) {
                    query.append(filter);
                    if (where.length() > 0) {
                        query.append("\n AND");
                    }
                }
                query.append((CharSequence)where);
            }
            if (groupBy != null && groupBy.length() > 0) {
                query.append("\n GROUP BY ").append(groupBy);
            }
            if (orderBy != null && orderBy.length() > 0) {
                if (!orderByPattern.matcher(orderBy).matches()) {
                    throw new BGException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441");
                }
                query.append("\n ORDER BY ").append(orderBy);
            }
            if (page != null && page.getPageSize() > 0) {
                query.append(" LIMIT ?, ?");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 0;
            for (int i = 0; i < params.length; ++i) {
                AbstractEntityAttrDao.setStatementParam(ps, ++idx, params[i]);
            }
            idx = this.filterToPS(ps, idx, entityFilter);
            if (page != null && page.getPageSize() > 0) {
                if (page.getPageIndex() <= 0) {
                    page.setPageIndex(1);
                }
                ps.setInt(++idx, (page.getPageIndex() - 1) * page.getPageSize());
                ps.setInt(++idx, page.getPageSize());
            }
            ResultSet rs = ps.executeQuery();
            ArrayList<E> result = new ArrayList<E>();
            while (rs.next()) {
                result.add(this.getFromRS(rs, loadAttributes, true));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            logger.error((Object)query.toString());
            throw new BGException(e);
        }
    }

    @Override
    protected final E getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, true, false);
    }

    protected abstract E getFromRS(ResultSet var1, boolean var2, boolean var3) throws SQLException, BGException;

    public void filterJoin(StringBuilder query, String wherePrefix, StringBuilder where, List<FilterEntityAttr> entityFilter) {
        int tableId = 0;
        int whereLength = where.length();
        int size = entityFilter.size();
        for (int i = 0; i < size; ++i) {
            String tableName;
            FilterEntityAttr a2 = entityFilter.get(i);
            ++tableId;
            query.append("\n INNER JOIN ");
            if (i == 0) {
                where.append(wherePrefix);
            }
            where.append(" (");
            String addressHouseTableName = null;
            String addressStreetTableName = null;
            if (a2 instanceof FilterEntityAttrText) {
                tableName = this.textDao.table + "_" + tableId;
                query.append(this.textDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName());
                switch (((FilterEntityAttrText)a2).getMode()) {
                    case 1: {
                        where.append(" LIKE ?");
                        break;
                    }
                    case 2: {
                        where.append(" REGEXP ?");
                        break;
                    }
                    default: {
                        where.append("=?");
                        break;
                    }
                }
            } else if (a2 instanceof FilterEntityAttrInt) {
                tableName = this.intDao.table + "_" + tableId;
                query.append(this.intDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
            } else if (a2 instanceof FilterEntityAttrBoolean) {
                tableName = this.booleanDao.table + "_" + tableId;
                query.append(this.booleanDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
            } else if (a2 instanceof FilterEntityAttrMultiList) {
                tableName = this.multiListDao.table + "_" + tableId;
                query.append(this.multiListDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.typeName()).append("=?");
            } else if (a2 instanceof FilterEntityAttrList) {
                tableName = this.listDao.table + "_" + tableId;
                query.append(this.listDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.typeName()).append("=?");
            } else if (a2 instanceof FilterEntityAttrDate) {
                tableName = this.dateDao.table + "_" + tableId;
                query.append(this.dateDao.table).append(" AS ").append(tableName);
                FilterEntityAttrDate period = (FilterEntityAttrDate)a2;
                if (period.getPeriodFrom() != null && period.getPeriodTo() != null && period.getPeriodFrom().equals(period.getPeriodTo())) {
                    where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
                } else {
                    where.append(tableName).append('.').append(this.support.defaultValueName()).append(">=? OR ? IS NULL) AND (").append(tableName).append('.').append(this.support.defaultValueName()).append("<=? OR ? IS NULL");
                }
            } else if (a2 instanceof FilterEntityAttrHouse) {
                tableName = this.houseDao.table + "_" + tableId;
                query.append(this.houseDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.defaultValueName()).append("=?");
            } else if (a2 instanceof FilterEntityAttrAddress) {
                tableName = this.addressDao.table + "_" + tableId;
                addressHouseTableName = "address_house_" + tableId;
                addressStreetTableName = "address_street_" + tableId;
                query.append(this.addressDao.table).append(" AS ").append(tableName);
                where.append(" (? OR ").append(addressStreetTableName).append('.').append("cityid=?)");
                where.append(" AND (? OR ").append(addressHouseTableName).append('.').append("streetid=?)");
                where.append(" AND (? OR ").append(addressHouseTableName).append('.').append("house=?)");
                where.append(" AND (? OR ").append(addressHouseTableName).append('.').append("frac=?)");
                where.append(" AND (? OR ").append(tableName).append('.').append("pod=?)");
                where.append(" AND (? OR ").append(tableName).append('.').append("flat=?)");
                where.append(" AND (? OR ").append(tableName).append('.').append("room=?)");
            } else if (a2 instanceof FilterEntityAttrEmail) {
                tableName = this.emailDao.table + "_" + tableId;
                query.append(this.emailDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append("email");
                switch (((FilterEntityAttrEmail)a2).getMode()) {
                    case 1: {
                        where.append(" LIKE ?");
                        break;
                    }
                    case 2: {
                        where.append(" REGEXP ?");
                        break;
                    }
                    default: {
                        where.append(" REGEXP ?");
                        break;
                    }
                }
            } else if (a2 instanceof FilterEntityAttrContract) {
                tableName = this.contractDao.table + "_" + tableId;
                query.append(this.contractDao.table).append(" AS ").append(tableName);
                where.append(tableName).append('.').append(this.support.typeName()).append("=?");
            } else if (a2 instanceof FilterEntityAttrPhone) {
                tableName = this.phoneDao.itemTable + "_" + tableId;
                query.append(this.phoneDao.itemTable).append(" AS ").append(tableName);
                where.append(tableName).append('.').append("phone");
                switch (((FilterEntityAttrPhone)a2).getMode()) {
                    case 1: {
                        where.append(" LIKE ?");
                        break;
                    }
                    case 2: {
                        where.append(" REGEXP ?");
                        break;
                    }
                    default: {
                        where.append("=?");
                        break;
                    }
                }
            } else {
                throw new IllegalArgumentException();
            }
            query.append(" ON ").append(tableName).append('.').append(this.support.idName()).append('=').append(this.getEntityTableName()).append('.').append(this.support.beanIdName());
            query.append(" AND ").append(tableName).append('.');
            if (a2 instanceof FilterEntityAttrList) {
                query.append(this.support.defaultValueName());
            } else {
                query.append(this.support.typeName());
            }
            if (a2.getEntitySpecAttrIds() != null && a2.getEntitySpecAttrIds().size() > 0) {
                query.append(" IN (").append(Utils.toString(a2.getEntitySpecAttrIds())).append(")");
            }
            if (a2 instanceof FilterEntityAttrAddress) {
                query.append("\n LEFT JOIN address_house AS ").append(addressHouseTableName);
                query.append(" ON ").append(addressHouseTableName).append(".id=").append(tableName).append('.').append(this.addressDao.addressHouseIdName);
                query.append("\n LEFT JOIN address_street AS ").append(addressStreetTableName);
                query.append(" ON ").append(addressStreetTableName).append(".id=").append(addressHouseTableName).append('.').append("streetid");
            }
            where.append(")\n AND");
        }
        if (where.length() > whereLength) {
            where.setLength(where.length() - 5);
        }
    }

    public int filterToPS(PreparedStatement ps, int idx, List<FilterEntityAttr> entityFilter) throws SQLException {
        int size = entityFilter.size();
        block10: for (int i = 0; i < size; ++i) {
            FilterEntityAttr aa;
            FilterEntityAttr a2 = entityFilter.get(i);
            if (a2 instanceof FilterEntityAttrText) {
                aa = (FilterEntityAttrText)a2;
                switch (((FilterEntityAttrText)aa).getMode()) {
                    case 1: {
                        ps.setString(++idx, "%" + ((FilterEntityAttrText)aa).getValue() + "%");
                        break;
                    }
                    default: {
                        ps.setString(++idx, ((FilterEntityAttrText)aa).getValue());
                        break;
                    }
                }
                continue;
            }
            if (a2 instanceof FilterEntityAttrInt) {
                ps.setInt(++idx, ((FilterEntityAttrInt)a2).getValue());
                continue;
            }
            if (a2 instanceof FilterEntityAttrList) {
                ps.setInt(++idx, ((FilterEntityAttrList)a2).getValue());
                continue;
            }
            if (a2 instanceof FilterEntityAttrHouse) {
                ps.setInt(++idx, ((FilterEntityAttrHouse)a2).getValue());
                continue;
            }
            if (a2 instanceof FilterEntityAttrDate) {
                FilterEntityAttrDate period = (FilterEntityAttrDate)a2;
                if (period.getPeriodFrom() != null && period.getPeriodTo() != null && period.getPeriodFrom().equals(period.getPeriodTo())) {
                    ps.setDate(++idx, TimeUtils.convertDateToSqlDate(period.getPeriodFrom()));
                    continue;
                }
                Date periodFrom = TimeUtils.convertDateToSqlDate(period.getPeriodFrom());
                Date periodTo = TimeUtils.convertDateToSqlDate(period.getPeriodTo());
                ps.setDate(++idx, periodFrom);
                ps.setDate(++idx, periodFrom);
                ps.setDate(++idx, periodTo);
                ps.setDate(++idx, periodTo);
                continue;
            }
            if (a2 instanceof FilterEntityAttrAddress) {
                FilterEntityAttrAddress address = (FilterEntityAttrAddress)a2;
                ps.setBoolean(++idx, address.getCityId() <= 0);
                ps.setInt(++idx, address.getCityId());
                ps.setBoolean(++idx, address.getStreetId() <= 0);
                ps.setInt(++idx, address.getStreetId());
                ps.setBoolean(++idx, Utils.isBlankString(address.getHouse()));
                ps.setString(++idx, address.getHouse());
                ps.setBoolean(++idx, Utils.isBlankString(address.getFrac()));
                ps.setString(++idx, address.getFrac());
                ps.setBoolean(++idx, address.getPod() <= 0);
                ps.setInt(++idx, address.getPod());
                ps.setBoolean(++idx, Utils.isBlankString(address.getFlat()));
                ps.setString(++idx, address.getFlat());
                ps.setBoolean(++idx, Utils.isBlankString(address.getRoom()));
                ps.setString(++idx, address.getRoom());
                continue;
            }
            if (a2 instanceof FilterEntityAttrEmail) {
                aa = (FilterEntityAttrEmail)a2;
                switch (((FilterEntityAttrEmail)aa).getMode()) {
                    case 1: {
                        ps.setString(++idx, "%" + ((FilterEntityAttrEmail)aa).getValue() + "%");
                        break;
                    }
                    case 2: {
                        ps.setString(++idx, ((FilterEntityAttrEmail)aa).getValue());
                        break;
                    }
                    default: {
                        ps.setString(++idx, "[[:<:]]" + ((FilterEntityAttrEmail)aa).getValue() + "[[:>:]]");
                        break;
                    }
                }
                continue;
            }
            if (a2 instanceof FilterEntityAttrContract) {
                ps.setInt(++idx, ((FilterEntityAttrContract)a2).getValue());
                continue;
            }
            if (!(a2 instanceof FilterEntityAttrPhone)) continue;
            aa = (FilterEntityAttrPhone)a2;
            switch (((FilterEntityAttrPhone)aa).getMode()) {
                case 1: {
                    ps.setString(++idx, "%" + ((FilterEntityAttrPhone)aa).getValue() + "%");
                    continue block10;
                }
                default: {
                    ps.setString(++idx, ((FilterEntityAttrPhone)aa).getValue());
                }
            }
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAddressItemUpdate(ServerContext context, Class<?> clazz, int id) throws SQLException, BGException {
        Class<AbstractEntityAttrDao> clazz2 = AbstractEntityAttrDao.class;
        synchronized (AbstractEntityAttrDao.class) {
            this.addressDao.onUpdate(context, clazz, id);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void checkEntityAttribute(EntityAttr entityAttr) throws BGException {
        Directory<EntitySpecAttr> dir = this.getEntitySpecAttrDirectory();
        EntitySpecAttr entitySpecAttr = dir.get(entityAttr.getEntitySpecAttrId());
        if (entitySpecAttr != null) {
            switch (EntitySpecAttrType.getEntitySpecAttrType(entitySpecAttr.getType())) {
                case EMAIL: {
                    EntityAttrEmail.check((EntityAttrEmail)entityAttr);
                    break;
                }
                case PHONE: {
                    EntityAttrPhoneDao.check((EntityAttrPhone)entityAttr, false);
                    break;
                }
            }
        }
    }

    protected static abstract class AddressItemModifiedEventListener
    implements EventListener<Event> {
        public AddressItemModifiedEventListener() throws BGException {
            new Thread("AddressItemModifiedEventListener-init"){

                @Override
                public void run() {
                    try {
                        EventProcessor ep = EventProcessor.getInstance();
                        ep.addListener(this, CityModifiedEvent.class);
                        ep.addListener(this, AreaModifiedEvent.class);
                        ep.addListener(this, StreetModifiedEvent.class);
                        ep.addListener(this, QuarterModifiedEvent.class);
                        ep.addListener(this, HouseModifiedEvent.class);
                    }
                    catch (BGException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }.start();
        }

        protected abstract AbstractEntityAttrDao<?> newDao(ServerContext var1);

        @Override
        public void notify(Event e, EventListenerContext ctx) throws BGException {
            Id id;
            Class clazz;
            if (e instanceof CityModifiedEvent) {
                clazz = City.class;
                id = (Id)((CityModifiedEvent)e).getNewItem();
            } else if (e instanceof AreaModifiedEvent) {
                clazz = Area.class;
                id = (Id)((AreaModifiedEvent)e).getNewItem();
            } else if (e instanceof StreetModifiedEvent) {
                clazz = Street.class;
                id = (Id)((StreetModifiedEvent)e).getNewItem();
            } else if (e instanceof QuarterModifiedEvent) {
                clazz = Quarter.class;
                id = (Id)((QuarterModifiedEvent)e).getNewItem();
            } else if (e instanceof HouseModifiedEvent) {
                clazz = House.class;
                id = (Id)((HouseModifiedEvent)e).getNewItem();
            } else {
                return;
            }
            if (id == null) {
                return;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ServerContext context = new ServerContext(Setup.getSetup(), 0, 0);
                    context.init();
                    try {
                        AbstractEntityAttrDao<?> dao = this.newDao(context);
                        dao.onAddressItemUpdate(context, clazz, id.getId());
                        context.commit();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        context.destroy();
                    }
                }
            });
        }
    }
}

