/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrListDao;

class EntityAttrListCustomDao
extends EntityAttrListDao {
    private String listValueTable;

    public EntityAttrListCustomDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String listTable, String listValueTable) {
        super(con, entityAttrDao, listTable, listValueTable);
        this.listValueTable = listValueTable;
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.selectPS == null) {
            this.selectPS = this.con.prepareStatement("SELECT v." + this.valueName() + ", t.title, v.custom_value FROM " + this.table + " as v LEFT JOIN " + this.listValueTable + " as t ON t.id=v." + this.valueName() + " WHERE v." + this.idName() + "=? AND v." + this.typeName() + "=?");
        }
        this.selectPS.setInt(1, entityId);
        this.selectPS.setInt(2, entitySpecAttrId);
        return this.selectPS;
    }

    @Override
    public EntityAttrList get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrList result;
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new EntityAttrList(entityId, attrSpecId, rs.getInt(1), rs.getString(2));
            result.setCustomValue(rs.getString(3));
        } else {
            result = null;
        }
        rs.close();
        return result;
    }

    @Override
    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.insertPS == null) {
            this.insertPS = this.con.prepareStatement("INSERT INTO " + this.table + " (" + this.idName() + ", " + this.typeName() + ", " + this.valueName() + ", custom_value) VALUES (?, ?, ?, ?)");
        }
        this.insertPS.setInt(1, entityId);
        this.insertPS.setInt(2, entitySpecAttrId);
        return this.insertPS;
    }

    @Override
    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.updatePS == null) {
            this.updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET " + this.valueName() + "=?, custom_value=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND (@oldValue:=" + this.valueName() + ") IS NOT NULL");
        }
        this.updatePS.setInt(3, entityId);
        this.updatePS.setInt(4, entitySpecAttrId);
        return this.updatePS;
    }

    @Override
    public void insert(int entityId, EntityAttr a2) throws SQLException {
        EntityAttrList attr = (EntityAttrList)a2;
        if (attr.getValue() <= 0 && Utils.isBlankString(attr.getCustomValue())) {
            return;
        }
        PreparedStatement ps = this.getInsertPS(entityId, a2.getEntitySpecAttrId());
        ps.setInt(3, attr.getValue());
        ps.setString(4, attr.getCustomValue());
        ps.executeUpdate();
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrList attr) throws SQLException {
        if (attr.getValue() <= 0 && Utils.isBlankString(attr.getCustomValue())) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setInt(1, attr.getValue());
        ps.setString(2, Utils.maskNull(attr.getCustomValue()));
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setInt(3, attr.getValue());
            ps.setString(4, Utils.maskNull(attr.getCustomValue()));
            ps.executeUpdate();
            return true;
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        ResultSet rs = ps.executeQuery();
        int oldValue = rs.next() ? rs.getInt(1) : 0;
        rs.close();
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int cid, EntityAttrList attr) throws SQLException {
        if (this.insertHistoryPS == null) {
            this.insertHistoryPS = this.con.prepareStatement("INSERT INTO " + this.table + "_log SET  " + this.idName() + "=?, " + this.typeName() + "=?, val=?, title=?, dt_change=?, user_id=?");
        }
        String title = attr != null ? (attr.getValue() <= 0 ? attr.getCustomValue() : attr.getTitle()) : null;
        this.insertHistoryPS.setInt(1, cid);
        this.insertHistoryPS.setInt(2, attr.getEntitySpecAttrId());
        this.insertHistoryPS.setInt(3, attr != null ? Integer.valueOf(attr.getValue()) : null);
        this.insertHistoryPS.setString(4, title);
        this.insertHistoryPS.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
        this.insertHistoryPS.setInt(6, this.entityAttrDao.userId);
        this.insertHistoryPS.executeUpdate();
    }
}

