/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;

public class ProductDao
extends AbstractIdDao<Product> {
    private final int userId;
    private PreparedStatement updateDeviceStatePS;
    private PreparedStatement updateDeviceStatePS2;
    protected PreparedStatement getByContractAndIdPS = null;

    public ProductDao(Connection con, int userId) {
        super(con, 0, "inv_product");
        this.userId = userId;
    }

    private Product getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        Product result = new Product();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("contractId"));
        result.setAccountId(rs.getInt("accountId"));
        result.setProductSpecId(rs.getInt("productSpecId"));
        result.setTimeFrom(TimeUtils.convertTimestampToDate(rs.getTimestamp("timeFrom")));
        result.setTimeTo(TimeUtils.convertTimestampToDate(rs.getTimestamp("timeTo")));
        result.setActivationModeId(rs.getInt("activationModeId"));
        result.setActivationTime(TimeUtils.convertTimestampToDate(rs.getTimestamp("activationTime")));
        result.setActivationPrice(rs.getBigDecimal("activationPrice"));
        result.setDeactivationTime(TimeUtils.convertTimestampToDate(rs.getTimestamp("deactivationTime")));
        result.setUserId(rs.getInt("userId"));
        result.setDeviceProductId(rs.getString("deviceProductId"));
        result.setDeviceState(rs.getShort("deviceState"));
        result.setComment(rs.getString("comment"));
        result.setDescription(rs.getString("description"));
        if (titleLoad) {
            result.setProductSpecTitle(rs.getString("spec.title"));
        }
        return result;
    }

    @Override
    protected Product getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    @Override
    protected void updateImpl(Product product) throws BGException, SQLException {
        if (product.getId() <= 0) {
            if (product.getActivationTime() == null) {
                product.setActivationTime(new Date());
            }
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (contractId, accountId, productSpecId, activationModeId, timeFrom, timeTo, activationTime, activationPrice,  deactivationTime, userId, deviceProductId, deviceState, comment, description) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setInt(1, product.getContractId());
            ps.setInt(2, product.getAccountId());
            ps.setInt(3, product.getProductSpecId());
            ps.setInt(4, product.getActivationModeId());
            ps.setTimestamp(5, TimeUtils.convertDateToTimestampSeconds(product.getTimeFrom()));
            ps.setTimestamp(6, TimeUtils.convertDateToTimestampSeconds(product.getTimeTo()));
            ps.setTimestamp(7, TimeUtils.convertDateToTimestampSeconds(product.getActivationTime()));
            ps.setBigDecimal(8, product.getActivationPrice());
            ps.setTimestamp(9, TimeUtils.convertDateToTimestampSeconds(product.getDeactivationTime()));
            ps.setInt(10, product.getUserId());
            ps.setString(11, product.getDeviceProductId());
            ps.setShort(12, product.getDeviceState());
            ps.setString(13, Utils.maskNull(product.getComment()));
            ps.setString(14, Utils.maskNull(product.getDescription()));
            ps.executeUpdate();
            product.setId(ServerUtils.lastInsertId(ps));
            ps.close();
        } else {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET activationModeId=?, timeFrom=?, timeTo=?, deactivationTime=?, userId=?, comment=?, description=?, activationPrice=? WHERE id=?");
            ps.setInt(1, product.getActivationModeId());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds(product.getTimeFrom()));
            ps.setTimestamp(3, TimeUtils.convertDateToTimestampSeconds(product.getTimeTo()));
            ps.setTimestamp(4, TimeUtils.convertDateToTimestampSeconds(product.getDeactivationTime()));
            ps.setInt(5, product.getUserId());
            ps.setString(6, Utils.maskNull(product.getComment()));
            ps.setString(7, Utils.maskNull(product.getDescription()));
            ps.setBigDecimal(8, product.getActivationPrice());
            ps.setInt(9, product.getId());
            ps.executeUpdate();
            ps.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Product product, boolean customer) throws BGException {
        block11: {
            try {
                if (product.getTimeTo() != null) {
                    PreparedStatement ps = customer ? this.con.prepareStatement("UPDATE " + this.tableName + " SET timeTo=?, deactivationTime=? WHERE id=? AND timeTo IS NULL") : this.con.prepareStatement("UPDATE " + this.tableName + " SET timeTo=?, deactivationTime=? WHERE id=?");
                    ps.setTimestamp(1, TimeUtils.convertDateToTimestampSeconds(product.getTimeTo()));
                    ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds(product.getTimeTo()));
                    ps.setInt(3, product.getId());
                    try {
                        if (ps.executeUpdate() == 0) {
                            throw new BGMessageException("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.");
                        }
                        break block11;
                    }
                    finally {
                        ps.close();
                    }
                }
                PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET timeTo=?, deactivationTime=? WHERE id=? AND (timeTo IS NOT NULL AND deactivationTime IS NOT NULL)");
                ps.setTimestamp(1, TimeUtils.convertDateToTimestampSeconds(product.getTimeTo()));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestampSeconds(product.getDeactivationTime()));
                ps.setInt(3, product.getId());
                try {
                    if (ps.executeUpdate() == 0) {
                        throw new BGMessageException("\u042d\u0442\u0443 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0435\u043b\u044c\u0437\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c!");
                    }
                }
                finally {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
    }

    public List<Product> list(int moduleId, int contractId, int accountId, boolean kernel, Date time) throws BGException {
        return this.list(moduleId, contractId, accountId, kernel, null, null, time, time, true, true);
    }

    public List<Product> list(int moduleId, int contractId, int accountId, boolean kernel, Date timeFrom, Date timeTo, Date timeFromIntersect, Date timeToIntersect, boolean needNonActive, boolean titleLoad) throws BGException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        try {
            ArrayList<Product> result = new ArrayList<Product>();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT product.*, spec.title FROM ").append(this.tableName).append(" AS product");
            sb.append(" LEFT JOIN inv_product_spec as spec ON product.productSpecId=spec.id ");
            sb.append(" WHERE product.contractId=? AND (? OR product.accountId=?) AND ((? OR spec.moduleId=?) OR (? AND spec.moduleId=0))");
            sb.append(" AND (? OR product.timeFrom>=?)");
            sb.append(" AND (? OR product.timeTo<=?)");
            sb.append(" AND (? OR product.timeFrom IS NULL OR product.timeFrom<=?)");
            sb.append(" AND (? OR product.timeTo IS NULL OR product.timeTo>=?)");
            if (!needNonActive) {
                sb.append("\n AND (product.timeTo IS NULL OR product.timeFrom<product.timeTo)");
            }
            sb.append("\n ORDER BY product.timeFrom");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, contractId);
            ps.setBoolean(2, accountId <= 0);
            ps.setInt(3, accountId);
            ps.setBoolean(4, moduleId < 0);
            ps.setInt(5, moduleId);
            ps.setBoolean(6, kernel);
            ps.setBoolean(7, timeFrom == null);
            ps.setTimestamp(8, TimeUtils.convertDateToTimestamp(timeFrom));
            ps.setBoolean(9, timeTo == null);
            ps.setTimestamp(10, TimeUtils.convertDateToTimestamp(timeTo));
            ps.setBoolean(11, timeToIntersect == null);
            ps.setTimestamp(12, TimeUtils.convertDateToTimestamp(timeToIntersect));
            ps.setBoolean(13, timeFromIntersect == null);
            ps.setTimestamp(14, TimeUtils.convertDateToTimestamp(timeFromIntersect));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, titleLoad));
            }
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public int delete(int contractId, int id) throws BGException {
        return this.delete("contractId=? AND id=?", contractId, id);
    }

    public void updateDeviceState(int contractId, int tvAccountId, int productId, String deviceProductId, short deviceState) throws BGException {
        try {
            if (deviceProductId == null || deviceProductId.length() == 0) {
                PreparedStatement ps = this.updateDeviceStatePS;
                if (ps == null) {
                    ps = this.updateDeviceStatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceState=? WHERE contractId=? AND id=? AND deviceState!=?");
                }
                ps.setShort(1, deviceState);
                ps.setInt(2, contractId);
                ps.setInt(3, productId);
                ps.setShort(4, deviceState);
                ps.executeUpdate();
            } else {
                PreparedStatement ps = this.updateDeviceStatePS2;
                if (ps == null) {
                    ps = this.updateDeviceStatePS2 = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceProductId=?, deviceState=? WHERE contractId=? AND id=? AND (deviceState!=? OR deviceProductId!=?)");
                }
                ps.setString(1, deviceProductId);
                ps.setShort(2, deviceState);
                ps.setInt(3, contractId);
                ps.setInt(4, productId);
                ps.setShort(5, deviceState);
                ps.setString(6, deviceProductId);
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public Product get(int contractId, int id) throws BGException {
        try {
            PreparedStatement ps = this.getByContractAndIdPS;
            if (ps == null) {
                ps = this.getByContractAndIdPS = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE contractId=? AND id=?");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            Product result = rs.next() ? this.getFromRS(rs) : null;
            rs.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public Product getAndDelete(int contractId, int id) throws BGException {
        Product old = this.get(contractId, id);
        this.delete(contractId, id);
        return old;
    }

    @Override
    public void recycle() throws BGException {
        try {
            if (this.updateDeviceStatePS != null) {
                this.updateDeviceStatePS.close();
                this.updateDeviceStatePS = null;
            }
            if (this.updateDeviceStatePS2 != null) {
                this.updateDeviceStatePS2.close();
                this.updateDeviceStatePS2 = null;
            }
            if (this.getByContractAndIdPS != null) {
                this.getByContractAndIdPS.close();
                this.getByContractAndIdPS = null;
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void checkProductSpecDelete(int productSpecId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE productSpecId=? LIMIT 1");
            ps.setInt(1, productSpecId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                rs.close();
                throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442, \u0442.\u043a. \u043e\u043d \u0431\u044b\u043b \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.", "productSpec.cantDelete.activeProducts");
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void checkProductSpecActivationModeDelete(int activationModeId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE activationModeId=? AND (timeTo IS NULL OR timeTo>=NOW()) LIMIT 1");
            ps.setInt(1, activationModeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                rs.close();
                throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 [" + activationModeId + "], \u0442.\u043a. \u043e\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.", "productSpec.cantDelete.activeProducts");
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }
}

