/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.systems.inventory.resource.common.DeviceService;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceGroupDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceManagerMethodMap;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;

public abstract class DeviceServiceImpl<D extends Device<D, T>, T extends DeviceType>
extends AbstractService
implements DeviceService<D, T> {
    protected DeviceGroupDao deviceGroupDao = null;
    protected Directory<T> deviceTypeDirectory = null;
    protected DeviceDao<D, T> deviceDao = null;

    @PostConstruct
    protected void init() throws BGException {
        this.deviceGroupDao = new DeviceGroupDao(this.getConnection(), this.moduleId);
        this.deviceTypeDirectory = this.getDeviceTypeDirectory();
        this.deviceDao = this.getDeviceDao();
    }

    @Override
    public DeviceGroup deviceGroupGet(int id) throws BGException {
        return (DeviceGroup)this.deviceGroupDao.get(id);
    }

    @Override
    public DeviceGroup deviceGroupRoot() throws BGException {
        return this.deviceGroupDao.root();
    }

    @Override
    public void deviceGroupDelete(int id) throws BGException {
        this.deviceGroupDao.delete(id);
    }

    @Override
    public int deviceGroupUpdate(DeviceGroup b2) throws BGException {
        this.deviceGroupDao.update(b2);
        return b2.getId();
    }

    @Override
    public List<T> deviceTypeList() throws BGException {
        return this.deviceTypeDirectory.list();
    }

    @Override
    public void deviceTypeDelete(int id) throws BGException {
        if (this.deviceDao.listByType(id, false).size() > 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        }
        this.deviceTypeDirectory.delete(id);
    }

    @Override
    public int deviceTypeUpdate(T d) throws BGException {
        this.deviceTypeDirectory.update(d);
        return ((Id)d).getId();
    }

    @Override
    public D deviceRoot(String identifier, String host, Set<Integer> deviceTypeIds, Set<Integer> deviceGroupIds, Date dateFrom, Date dateTo, Date intersectDateFrom, Date intersectDateTo, List<FilterEntityAttr> entityFilter, boolean loadDeviceGroupLink) throws BGException {
        return this.deviceDao.root(identifier, host, deviceTypeIds, deviceGroupIds, dateFrom, dateTo, intersectDateFrom, intersectDateTo, entityFilter, loadDeviceGroupLink);
    }

    @Override
    public void deviceMove(int id, Set<Integer> children) throws BGException {
        this.deviceDao.move(id, children);
    }

    @Override
    public void deviceDelete(int id) throws BGException {
        this.deviceDao.delete(id);
    }

    @Override
    public List<D> deviceList(int deviceTypeId) throws BGException {
        return this.deviceDao.list(deviceTypeId, false);
    }

    protected abstract Directory<T> getDeviceTypeDirectory() throws BGException;

    protected abstract DeviceDao<D, T> getDeviceDao() throws BGException;

    protected abstract DeviceTypeDao<T> getDeviceTypeDao() throws BGException;

    @Override
    public List<DeviceManagerMethod> deviceManagerMethodList(int deviceTypeId) throws BGException {
        Object t = this.deviceTypeGet(deviceTypeId);
        if (t == null) {
            return new ArrayList<DeviceManagerMethod>(0);
        }
        String className = ((DeviceType)t).getDeviceManagerClass();
        if (Utils.isBlankString(className)) {
            return new ArrayList<DeviceManagerMethod>(0);
        }
        return DeviceManagerMethodMap.getInstance().getMethodList(className);
    }
}

