/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;

public class IpCategoryDao
extends AbstractIdDao<IpCategory> {
    public IpCategoryDao(Connection con, int mid) {
        super(con, 0, "inv_ip_category_" + mid);
    }

    @Override
    protected IpCategory getFromRS(ResultSet rs) throws SQLException, BGException {
        IpCategory result = new IpCategory();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    @Override
    protected void updateImpl(IpCategory b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2 == null || Utils.isBlankString(b2.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (parentId, title) VALUES (?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=?, title=? WHERE id=?");
            ps.setInt(3, b2.getId());
        }
        ps.setInt(1, b2.getParentId());
        ps.setString(2, b2.getTitle());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public IpCategory root() throws BGException {
        IpCategory root = new IpCategory();
        root.setId(0);
        root.setTitle("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 IP \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        return TreeUtils.tree(this.list(null, null, new Object[0]), root);
    }

    public List<IpCategory> list() throws BGException {
        return this.list(null, null, new Object[0]);
    }
}

