/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResource;

public class PhoneResourceDao
extends AbstractIdDao<PhoneResource> {
    public PhoneResourceDao(Connection con, int mid) {
        super(con, mid, "inv_phone_resource");
    }

    @Override
    protected PhoneResource getFromRS(ResultSet rs) throws SQLException, BGException {
        PhoneResource result = new PhoneResource();
        result.setId(rs.getInt("id"));
        result.setPhoneFrom(rs.getLong("phoneFrom"));
        result.setPhoneTo(rs.getLong("phoneTo"));
        result.setDateFrom(rs.getDate("dateFrom"));
        result.setDateTo(rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        result.setCategoryId(rs.getInt("categoryId"));
        return result;
    }

    @Override
    protected void updateImpl(PhoneResource b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2.getPhoneTo() < 0L || b2.getPhoneFrom() < 0L || b2.getPhoneTo() < b2.getPhoneFrom()) {
            throw new BGIllegalArgumentException();
        }
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " ( phoneFrom, phoneTo, dateFrom, dateTo, comment, categoryId ) VALUES (?,?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET phoneFrom=?, phoneTo=?, dateFrom=?, dateTo=?, comment=?, categoryId = ? WHERE id=?");
            ps.setInt(7, b2.getId());
        }
        ps.setLong(1, b2.getPhoneFrom());
        ps.setLong(2, b2.getPhoneTo());
        ps.setDate(3, TimeUtils.convertDateToSqlDate(b2.getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate(b2.getDateTo()));
        ps.setString(5, b2.getComment());
        ps.setInt(6, b2.getCategoryId());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<PhoneResource> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public List<PhoneResource> list(int categoryId) throws BGException {
        return this.list("categoryId=?", "phoneFrom", categoryId);
    }

    public List<PhoneResource> list(int categoryId, Date date) throws BGException {
        return this.list("categoryId=? and (dateFrom IS NULL OR dateFrom <= ?) and ( dateTo IS NULL OR dateTo >= ? ) ", "id", categoryId, date, date);
    }

    public List<PhoneResource> list(Date dateFrom, Date dateTo) throws BGException {
        return this.list("(dateFrom IS NULL OR dateFrom <= ?) and ( dateTo IS NULL OR dateTo >= ? ) ", "id", dateFrom, dateTo);
    }

    public List<PhoneResource> list(Set<Integer> categoryIds) throws BGException {
        if (categoryIds.size() == 0) {
            return new ArrayList<PhoneResource>();
        }
        return this.list("categoryId IN (" + Utils.toString(categoryIds) + ")", "id", new Object[0]);
    }

    public void importData(int categoryId, String importData) throws BGException {
        if (importData == null) {
            throw new BGMessageException("importData is null!!!");
        }
        if (categoryId < 1) {
            throw new BGMessageException("categoryId not set!!!");
        }
        for (String line : importData.split("\n")) {
            String[] resourceData = line.split("\t");
            PhoneResource phoneResource = new PhoneResource();
            phoneResource.setCategoryId(categoryId);
            phoneResource.setComment("");
            if (resourceData.length > 1) {
                phoneResource.setPhoneFrom(Utils.parseLong(resourceData[0]));
                phoneResource.setPhoneTo(Utils.parseLong(resourceData[1]));
            }
            if (resourceData.length > 3) {
                phoneResource.setDateFrom(TimeUtils.parseDate(resourceData[2], "dd.MM.yyyy"));
                phoneResource.setDateTo(TimeUtils.parseDate(resourceData[3], "dd.MM.yyyy"));
            }
            if (resourceData.length > 4) {
                phoneResource.setComment(resourceData[4]);
            }
            this.update(phoneResource);
        }
    }
}

