/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import uk.co.westhawk.snmp.stack.AbstractSnmpContext;
import uk.co.westhawk.snmp.stack.AsnDecoderv1;
import uk.co.westhawk.snmp.stack.AsnEncoderv1;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnPduSequence;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.AsnTrapPduv1Sequence;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.GetPdu;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContextFace;
import uk.co.westhawk.snmp.stack.TrapPduv1;

public class SnmpContext
extends AbstractSnmpContext
implements SnmpContextFace,
Cloneable {
    private static final String version_id = "@(#)$Id: SnmpContext.java,v 3.24 2006/11/29 16:23:33 birgit Exp $ Copyright Westhawk Ltd";
    String community = "public";

    public SnmpContext(String host, int port) throws IOException {
        super(host, port);
    }

    public SnmpContext(String host, int port, String typeSocketA) throws IOException {
        super(host, port, typeSocketA);
    }

    public SnmpContext(String host, int port, String bindAddress, String typeSocketA) throws IOException {
        super(host, port, bindAddress, typeSocketA);
    }

    public int getVersion() {
        return 0;
    }

    public String getCommunity() {
        return this.community;
    }

    public void setCommunity(String newCommunity) {
        this.community = newCommunity;
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, Object obj) throws IOException, EncodingException {
        byte[] packet = null;
        if (this.isDestroyed) {
            throw new EncodingException("Context can no longer be used, since it is already destroyed");
        }
        AsnEncoderv1 enc = new AsnEncoderv1();
        ByteArrayOutputStream bay = enc.EncodeSNMP(this, msg_type, rId, errstat, errind, ve);
        int sz = bay.size();
        if (sz > this.maxRecvSize) {
            throw new EncodingException("Packet size (" + sz + ") is > maximum size (" + this.maxRecvSize + ")");
        }
        packet = bay.toByteArray();
        return packet;
    }

    public byte[] encodePacket(byte msg_type, String enterprise, byte[] IpAddress, int generic_trap, int specific_trap, long timeTicks, Enumeration ve) throws IOException, EncodingException {
        byte[] packet = null;
        AsnEncoderv1 enc = new AsnEncoderv1();
        ByteArrayOutputStream bay = enc.EncodeSNMP(this, msg_type, enterprise, IpAddress, generic_trap, specific_trap, timeTicks, ve);
        int sz = bay.size();
        if (sz > this.maxRecvSize) {
            throw new EncodingException("Packet size (" + sz + ") is > maximum size (" + this.maxRecvSize + ")");
        }
        packet = bay.toByteArray();
        return packet;
    }

    protected void processIncomingResponse(ByteArrayInputStream in) throws DecodingException, IOException {
        AsnDecoderv1 rpdu = new AsnDecoderv1();
        AsnSequence seqPdu = rpdu.DecodeSNMP(in, this.getCommunity());
        if (seqPdu instanceof AsnPduSequence) {
            AsnPduSequence pduSeq = (AsnPduSequence)seqPdu;
            if (pduSeq != null) {
                Integer rid = new Integer(pduSeq.getReqId());
                Pdu answ = this.getPdu(rid);
                if (answ != null) {
                    answ.fillin(pduSeq);
                } else if (AsnObject.debug > 3) {
                    System.out.println(this.getClass().getName() + ".processIncomingResponse(): No Pdu with reqid " + rid);
                }
            } else if (AsnObject.debug > 3) {
                System.out.println(this.getClass().getName() + ".processIncomingResponse(): Error - missing seq input");
            }
        }
    }

    public Pdu processIncomingPdu(byte[] message) throws DecodingException, IOException {
        AsnDecoderv1 rpdu = new AsnDecoderv1();
        ByteArrayInputStream in = new ByteArrayInputStream(message);
        Pdu pdu = null;
        AsnSequence seqPdu = rpdu.DecodeSNMP(in, this.getCommunity());
        if (seqPdu instanceof AsnTrapPduv1Sequence) {
            AsnTrapPduv1Sequence pduSeq = (AsnTrapPduv1Sequence)seqPdu;
            if (pduSeq != null) {
                TrapPduv1 trapPdu = new TrapPduv1(this);
                trapPdu.fillin(pduSeq);
                pdu = trapPdu;
            }
        } else {
            AsnPduSequence pduSeq = (AsnPduSequence)seqPdu;
            if (pduSeq != null) {
                byte type = pduSeq.getRespType();
                switch (type) {
                    case -96: {
                        pdu = new GetPdu(this);
                        break;
                    }
                    case -95: {
                        pdu = new GetNextPdu(this);
                        break;
                    }
                    case -93: {
                        pdu = new SetPdu(this);
                        break;
                    }
                    default: {
                        if (AsnObject.debug <= 3) break;
                        System.out.println(this.getClass().getName() + ".ProcessIncomingPdu(): PDU received with type " + pduSeq.getRespTypeString() + ". Ignoring it.");
                    }
                }
                if (pdu != null) {
                    pdu.fillin(pduSeq);
                }
            }
        }
        return pdu;
    }

    public Object clone() throws CloneNotSupportedException {
        SnmpContext clContext = null;
        try {
            clContext = new SnmpContext(this.hostname, this.hostPort, this.bindAddr, this.typeSocket);
            clContext.setCommunity(new String(this.community));
        }
        catch (IOException exc) {
            throw new CloneNotSupportedException("IOException " + exc.getMessage());
        }
        return clContext;
    }

    public String getHashKey() {
        String str = this.hostname + "_" + this.hostPort + "_" + this.typeSocket + "_" + this.community + "_v" + this.getVersion();
        return str;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("SnmpContext[");
        buffer.append("host=").append(this.hostname);
        buffer.append(", port=").append(this.hostPort);
        buffer.append(", bindAddress=").append(this.bindAddr);
        buffer.append(", socketType=").append(this.typeSocket);
        buffer.append(", community=").append(this.community);
        buffer.append(", #trapListeners=").append(this.trapSupport.getListenerCount());
        buffer.append(", #pduListeners=").append(this.pduSupport.getListenerCount());
        buffer.append("]");
        return buffer.toString();
    }
}

