<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<c:choose>
	<c:when test="${not empty dataMap['notificationList']}">
		<table class="table tableWidth tableFont notificationList">
			<thead>
				<tr>
					<td width="50">ID</td>
					<td width="200">Дата / время</td>
					<td>Тема сообщения</td>
					<td width="100">Статус</td>
					<td width="100">&nbsp;</td>
				</tr>
			</thead>
			<tbody>
				<c:forEach var="item" items="${dataMap['notificationList']}">
				<tr>
					<td align="right">${item.id}</td>
					<td><fmt:formatDate pattern="dd.MM.yyyy HH:mm:ss" value="${item.dateTime}"/></td>
					<td style="text-align: left;"><a href="?action=Notification&mid=contract&id=${item.id}">${item.subject}</a></td>
					<td>
						<c:choose>
							<c:when test="${item.read}">прочитано</c:when>
							<c:otherwise><b>новое</b></c:otherwise>
						</c:choose>
					</td>
					<td><c:if test="${item.read}"><button onclick="document.location='?action=NotificationTable&mid=contract&module=contract&command=delete&id=${item.id}'">удалить</button></c:if></td>
				</tr>
				</c:forEach>
			</tbody>
		</table>
	</c:when>
	<c:when test="${not empty contractNotification}">
		<div>Дата: <b><fmt:formatDate pattern="dd.MM.yyyy HH:mm:ss" value="${contractNotification.dateTime}"/></b></div>
		<br/>
		<div>Тема:<b>${contractNotification.subject}</b></div>
		<pre>${contractNotification.message}</pre>
		<button onclick="document.location='?action=NotificationTable&mid=contract'">К списку ...</button>
	</c:when>
	<c:otherwise>
		<p>Записи не найдены.</p>
	</c:otherwise>
</c:choose>
