<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
<xsl:import href="layout.xsl"/>

<xsl:output encoding="UTF-8" method='html' indent='yes'/>

<xsl:variable name="mid" select="/data/@mid"/>
<xsl:variable name="activateType" select="/data/@activateType"/>

<xsl:template match="/">
	<xsl:call-template name="main">
  		<xsl:with-param name="mode" select="'pub'"/>
  	</xsl:call-template>
</xsl:template>

<xsl:template name="title">Ошибка при авторизации</xsl:template>

<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="error/@id='parameterLoginAndPasswordNotFound'">
		<h2>ОШИБКА: Отсутствует параметры</h2>
		<p>Полученный запрос не содержит параметров с данными необходимыми для авторизации</p>
		<p>Попробуйте <a href="{$WEBEXECUTER}">войти еще раз</a></p>
	</xsl:when>
	<xsl:when test="error/@id='loginNotFound'">
		<h2>ОШИБКА: Договор не найден</h2>
		<p>Введенный Вами номер договора (<xsl:value-of select="error/@userName"/>) не найден в базе данных.</p>
		<p>Возможные причины:</p>
		<ul>
			<li>Договор не существует (или удален)</li>
			<li>Неправильно введен номер договора. Номер договора состоит из нескольких букв в начале, затем несколько цифр, затем тире "-" и две цифры (последние две цифры от года, когда был заключен договор). Номер вводиться слитно без пробелов. Например: NK00001-05, КФ123456-06 и т.д.</li>
			<li>Другие причины, для выяснения свяжитесь с расчетной службой по тел. +X (XXX) XXX-XX-XX</li>
		</ul>
		<p>Попробуйте <a href="{$WEBEXECUTER}">войти еще раз</a></p>
	</xsl:when>
	<xsl:when test="error/@id='passwordInvalid'">
		<h2>ОШИБКА: Неправильный пароль</h2>
		<p>Вы ввели неправильный пароль для договора - <xsl:value-of select="error/@userName"/></p>
		<p>Возможные причины:</p>
		<ul>
			<li>Ошибка при вводе пароля</li>
			<li>Ошибка в номере договора</li>
			<li>Проверьте состояние клавиши Caps Lock и языковую раскладку клавиатуры</li>
			<li>Внимание пароль для доступа к серверу статистики ОТЛИЧАЕТСЯ от пароля для доступа по VPN. Пароль для доступа к серверу статистики указывается в карте регистрации выдаваемой при заключении договора.</li>
			<li>Попробуйте воспользоваться <a href="{$PUBEXECUTER}?module=admin&amp;action=PasswordForgot">системой восстановления пароля</a></li>
			<li>Другие причины, для выяснения свяжитесь с расчетной службой по тел. +X (XXX) XXX-XX-XX</li>
		</ul>
		<p>Попробуйте <a href="{$WEBEXECUTER}">войти еще раз</a></p>
	</xsl:when>
	<xsl:when test="error/@id='denyStatus'">
        <h2>ОШИБКА: Доступ закрыт</h2>
        <p>Доступ к личному кабинету для договора <xsl:value-of select="error/@userName"/> закрыт по статусу.</p>
        <p>Войти по <a href="{$WEBEXECUTER}">другому договору.</a></p>
    </xsl:when>
    <xsl:when test="error/@id='denyClosedPeriod'">
        <h2>ОШИБКА: Доступ закрыт</h2>
        <p>Доступ к личному кабинету для договора <xsl:value-of select="error/@userName"/> закрыт. Период действия договора завершился.</p>
        <p>Войти по <a href="{$WEBEXECUTER}">другому договору.</a></p>
    </xsl:when>
	<xsl:when test="error/@id='accountLock'">
		<h2>ОШИБКА: Доступ заблокирован</h2>
		<p>Доступ к статистике по договору <xsl:value-of select="error/@userName"/> заблокирован, до разблокировки осталось - <span id="miniclock"/></p>
		<p>Возможные причины:</p>
		<ul>
			<li>Для защиты от подбора пароля к серверу статистики методом перебора, после каждой попытки войти на сервер статистики с неправильным паролем, доступ к серверу блокируется на некоторое время. После истечения этого времени дается возможность провести еще одну попытку войти на сервер, если будет вновь введен неправильный пароль доступ снова будет заблокирован на более длительный промежуток времени и т.д. После нескольких последовательных попыток входа на сервер с неправильным паролем, доступ на сервер блокируется на несколько часов.</li>
			<li>Доступ заблокирован администратором, свяжитесь с службой поддержки по тел. +X (XXX) XXX-XX-XX</li>
			<li>Другие причины, для выяснения свяжитесь с расчетной службой по тел. +X (XXX) XXX-XX-XX</li>
		</ul>
		<p>После окончания времени блокировки Вы можете попробовать войти еще раз. Предварительно убедитесь, в правильности вводимых данных.</p>
		<p>Обратите внимание на:</p>
		<ul>
			<li>Состояние клавиши Caps Lock и языковую раскладку клавиатуры</li>
			<li>Пароль для доступа к серверу статистики ОТЛИЧАЕТСЯ от пароля для доступа по VPN. Пароль для доступа к серверу статистики указывается в карте регистрации выдаваемой при заключении договора.</li>
			<li>Если не уверены в корректности вводимого пароля, попробуйте воспользоваться <a href="{$PUBEXECUTER}?module=admin&amp;action=PasswordForgot">системой восстановления пароля</a></li>
		</ul>
		<!-- <p><a href="{$WEBEXECUTER}">Войти</a></p> -->
		<script language="JavaScript" type="text/javascript">
		var lockTime = <xsl:value-of select="error/@lockSeconds"/>;
		var logonUrl = "<xsl:value-of select="$WEBEXECUTER"/>"; 
		<![CDATA[
		function runMiniClock()
		{
			lockTime=lockTime-1;
			if ( lockTime == 0 )
			{
				document.location=logonUrl;
				return;
			} 
		    var hours = Math.floor(lockTime / 3600);
		    var minutes = Math.floor((lockTime - 3600 * hours) / 60);
		    var seconds = lockTime % 60;
		    seconds=((seconds < 10) ? "0" : "") + seconds;
		    minutes=((minutes < 10) ? "0" : "") + minutes;
		    hours=(hours > 24) ? hours-24 : hours;
		    hours=(hours == 0) ? 0 : hours;
		    var clock = hours + ":" + minutes + ":" + seconds;
		    document.getElementById('miniclock').innerHTML = clock;
		    timer = setTimeout("runMiniClock()",1000);
		}
		runMiniClock();
		]]>
		</script>
	</xsl:when>
	<xsl:otherwise>
		<h2>ОШИБКА: Неизвестная</h2>
		<p>это что то новенькое!!! [error = '<xsl:value-of select="error/@id"/>'] Свяжитесь с разработчиками!</p>
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

</xsl:stylesheet>