/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ActionShellTaskBase
extends ActionBase {
    protected static Map<Integer, Queue<QueueTask>> userTaskQueue = new ConcurrentHashMap<Integer, Queue<QueueTask>>();

    static {
        new Thread(){

            @Override
            public void run() {
                try {
                    for (Queue<QueueTask> queue : userTaskQueue.values()) {
                        for (QueueTask task : queue) {
                            if (!task.isTaskExpired()) continue;
                            queue.remove(task);
                        }
                    }
                    1.sleep(15000L);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }.start();
    }

    protected static class QueueTask {
        private static long MAX_CACHE_TIME = 10000L;
        private long addTime = System.currentTimeMillis();
        private String task;

        public QueueTask(String task) {
            this.task = task;
        }

        public String getTask() {
            return this.task;
        }

        public boolean isTaskExpired() {
            return System.currentTimeMillis() - this.addTime > MAX_CACHE_TIME;
        }
    }
}

