/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.XMLUtils;

public class ActionGetAllModuleActions
extends ActionBase {
    @Override
    public void doAction() throws BGException {
        ModuleCache moduleCache = ModuleCache.getInstance();
        List<BGInstalledModule> installedModuleList = moduleCache.getInstalledModulesList();
        try {
            this.fillXml(new File("actions/kernel.xml"), "0", "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
            for (BGInstalledModule bgInstalledModule : installedModuleList) {
                File file = new File("actions/" + bgInstalledModule.getName() + ".xml");
                if (!file.exists() || !file.canRead()) continue;
                this.fillXml(file, String.valueOf(bgInstalledModule.getId()), bgInstalledModule.getTitle());
            }
        }
        catch (IOException e) {
            throw new BGException(e.getMessage(), e);
        }
    }

    private void fillXml(File file, String mid, String title) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader(fileInputStream);){
            Document kernelDocument = XMLUtils.parseDocument(new InputSource(reader));
            Element kernelElement = XMLUtils.selectElement(kernelDocument, "//actions");
            kernelElement.setAttribute("id", mid);
            kernelElement.setAttribute("title", title);
            Node node = this.rootNode.getOwnerDocument().importNode(kernelElement, true);
            this.rootNode.appendChild(node);
        }
    }
}

