/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class NumberResourceAuditor {
    private Set<Long> resourceSet = new HashSet<Long>();

    public NumberResourceAuditor(Connection con, int mid, Date dt, String categories) {
        String tableName = "number_resource_" + mid;
        if (!Utils.notBlankString(categories) || ServerUtils.tableExists(con, tableName)) {
            // empty if block
        }
        try {
            String query = "SELECT number FROM " + tableName + " WHERE date1<=? AND (date2 IS NULL OR ?<=date2) AND category_id IN (" + categories + ")";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate(dt));
            ps.setDate(2, TimeUtils.convertDateToSqlDate(dt));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.resourceSet.add(Utils.parseLong(rs.getString(1)));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean containsNumber(String number) {
        boolean result = false;
        long value = Utils.parseLong(number, -1L);
        result = value > 0L && this.resourceSet.contains(value);
        return result;
    }
}

