/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.NumberResourceCategory;
import bitel.billing.server.admin.resource.bean.ResourceCategoryManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class NumberResourceCategoryManager
extends ResourceCategoryManager<NumberResourceCategory> {
    private Logger logger = Logger.getLogger(NumberResourceCategoryManager.class);

    public NumberResourceCategoryManager(Connection con, int mid) {
        super(con, mid);
    }

    @Override
    protected NumberResourceCategory getCategoryFromRs(ResultSet rs) {
        NumberResourceCategory result = new NumberResourceCategory();
        try {
            this.loadStandartCategoryFields(rs, result);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return result;
    }

    public void updateCategory(NumberResourceCategory category) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (category.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " ( title, comment, parent_id ) VALUES ( ?, ?, ? )";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(3, category.getParentId());
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, category.getId());
            }
            ps.setString(1, category.getTitle());
            ps.setString(2, category.getComment());
            ps.executeUpdate();
            if (category.getId() <= 0) {
                category.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public void deleteCategory(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public NumberResourceCategory getCategory(int id) {
        return (NumberResourceCategory)super.getCategory(id);
    }

    public List<NumberResourceCategory> getNumberResourceCategoryList() {
        ArrayList<NumberResourceCategory> result = new ArrayList<NumberResourceCategory>();
        String query = "SELECT * FROM " + this.tableName;
        try (Statement statement = this.con.createStatement();){
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                NumberResourceCategory category = new NumberResourceCategory();
                this.loadStandartCategoryFields(rs, category);
                result.add(category);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return result;
    }

    @Override
    public List<NumberResourceCategory> getCategoryTree() {
        return super.getCategoryTree();
    }

    @Override
    protected String getTableName() {
        return "number_resource_category";
    }
}

