/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.ResourceUse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.common.TimeUtils;

public abstract class ResourceUseManager<T extends ResourceUse> {
    protected Connection con;
    protected String tableName;
    protected int mid;

    public ResourceUseManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = this.getTableName() + "_" + mid;
    }

    public List<T> getResourceUse(int resourceId) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            String query = "SELECT ruse.*, contract.id, contract.title, contract.comment FROM " + this.tableName + " AS ruse LEFT JOIN contract ON ruse.cid=contract.id WHERE resource_id=? ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, resourceId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                T res = this.getResourceUseFromRs(rs);
                result.add(res);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateResourceUse(int resourceId, List<T> useList) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE resource_id=?";
            PreparedStatement psDel = this.con.prepareStatement(query);
            psDel.setInt(1, resourceId);
            psDel.executeUpdate();
            psDel.close();
            this.insertResourceUseList(resourceId, useList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void insertResourceUseList(int var1, List<T> var2) throws Exception;

    public boolean wasResourceUsed(String resourceId) {
        boolean result = false;
        try {
            String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE resource_id IN (" + resourceId + " )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            result = rs.next() && rs.getInt(1) > 0;
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void loadStandartResourceUseFromRs(ResourceUse ruse, ResultSet rs) throws Exception {
        ruse.setResourceId(rs.getInt("ruse.resource_id"));
        ruse.setDateFrom(rs.getDate("ruse.date1"));
        ruse.setDateTo(rs.getDate("ruse.date2"));
        ruse.setContractId(rs.getInt("contract.id"));
        ruse.setContractTitle(rs.getString("contract.title"));
        ruse.setContractComment(rs.getString("contract.comment"));
    }

    protected abstract T getResourceUseFromRs(ResultSet var1);

    protected abstract String getTableName();

    public void freeResources(int cid) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE cid=?");
            ps.setInt(1, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void closeResourceUse(int cid, Date date) {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET date2=? WHERE cid=?");
            ps.setDate(1, TimeUtils.convertDateToSqlDate(date));
            ps.setInt(2, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

