/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.LoginManager;
import bitel.billing.server.contract.object.bean.ModuleEntity;
import bitel.billing.server.util.MonthForRecalc;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public abstract class Module
extends ModuleBase {
    @Override
    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        List<String> lids = ServerUtils.addItemsFromRS(con, tables, "user_login_" + mid, "cid", cidStr, "id", onlyCurrent, "date1", "date2");
        for (String lid : lids) {
            this.addLoginOptions(con, tables, lid, mid);
        }
    }

    protected void addLoginOptions(Connection con, XMLStreamWriter tables, String lid, int mid) throws SQLException, XMLStreamException {
        ServerUtils.addItemsFromRS(con, tables, "radius_pair_" + mid, "id", lid, null, false, null, null);
        ServerUtils.addItemsFromRS(con, tables, "radius_pair_set_" + mid, "id", lid, null, false, null, null);
        ServerUtils.addItemsFromRS(con, tables, "user_alias_" + mid, "login_id", lid, null, false, null, null);
        ServerUtils.addItemsFromRS(con, tables, "radius_pair_ip_" + mid, "id", lid, null, false, null, null);
    }

    @Override
    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        super.moduleAction(ctx, mid, event);
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            Connection con = ctx.getConnection();
            if (cdEvent.isCheck()) {
                LoginManager loginManager = this.getLoginManager(con, mid);
                for (Login login : loginManager.getContractLogins(cdEvent.getContractId())) {
                    if (!loginManager.hasActiveSessions(login.getId())) continue;
                    cdEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440, \u043b\u043e\u0433\u0438\u043d " + login.getLogin() + " \u0438\u043c\u0435\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u0443\u044e \u0441\u0435\u0441\u0441\u0438\u044e.");
                    return;
                }
            } else {
                List<String> lids = ServerUtils.deleteRowsFromTable(con, "user_login_" + mid, "cid", String.valueOf(event.getContractId()), "id");
                for (String lid : lids) {
                    this.deleteLoginData(con, lid, mid);
                }
            }
        } else if (event instanceof ContractCloseEvent) {
            ContractCloseEvent cEvent = (ContractCloseEvent)event;
            Connection con = ctx.getConnection();
            if (cEvent.isCheck()) {
                String query = "SELECT login FROM user_login_" + mid + " WHERE date2 IS NOT NULL AND date2>? AND cid=? LIMIT 1";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertDateToSqlDate(cEvent.getDate()));
                ps.setInt(2, cEvent.getContractId());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    cEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u043b\u043e\u0433\u0438\u043d " + rs.getString(1) + " \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f.");
                }
                rs.close();
                ps.close();
            } else {
                String query = "UPDATE user_login_" + mid + " SET date2=? WHERE cid=? AND date2 IS NULL";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertDateToSqlDate(cEvent.getDate()));
                ps.setInt(2, cEvent.getContractId());
                ps.executeUpdate();
                ps.close();
            }
        } else if (event instanceof ContractWrapEvent) {
            ContractWrapEvent cwEvent = (ContractWrapEvent)event;
            Connection con = ctx.getConnection();
            if (cwEvent.isCheck()) {
                LoginManager loginManager = this.getLoginManager(con, mid);
                for (Login login : loginManager.getContractLogins(cwEvent.getContractId())) {
                    if (login.getDate1() == null) {
                        cwEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440, \u043b\u043e\u0433\u0438\u043d " + login.getLogin() + " \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f.");
                        return;
                    }
                    if (!loginManager.hasActiveSessions(login.getId())) continue;
                    cwEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440, \u043b\u043e\u0433\u0438\u043d " + login.getLogin() + " \u0438\u043c\u0435\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u0443\u044e \u0441\u0435\u0441\u0441\u0438\u044e.");
                    return;
                }
                loginManager.freeResources();
            } else {
                MonthForRecalc recalcMonths = new MonthForRecalc();
                LoginManager loginManager = this.getLoginManager(con, mid);
                for (Login login : loginManager.getContractLogins(cwEvent.getContractId())) {
                    Date dateFrom = cwEvent.getDateClose();
                    Date dateTo = new Date();
                    if (TimeUtils.dateBefore(login.getDate2(), dateTo)) {
                        dateTo = login.getDate2();
                    }
                    recalcMonths.addPeriod(dateFrom, dateTo);
                    Integer objectId = cwEvent.getObjectMap().get(login.getObjectId());
                    if (objectId == null) {
                        objectId = 0;
                    }
                    loginManager.wrapLogin(login, cwEvent.getToContractId(), objectId, cwEvent.getDateClose(), cwEvent.getDateOpen(), 0);
                }
                loginManager.recalcAfterMove(recalcMonths, cwEvent.getContractId(), cwEvent.getToContractId());
                loginManager.freeResources();
            }
        } else if (event instanceof ObjectMoveEvent) {
            Connection con = ctx.getConnection();
            String tableName = "user_login_" + mid;
            String query = "UPDATE " + tableName + " SET object_id=0 WHERE object_id=?";
            PreparedStatement psUpdate = con.prepareStatement(query);
            psUpdate.setInt(1, ((ObjectMoveEvent)event).getObjectId());
            psUpdate.executeUpdate();
            psUpdate.close();
        }
    }

    protected void deleteLoginData(Connection con, String lid, int mid) throws SQLException {
        ServerUtils.deleteRowsFromTable(con, "radius_pair_" + mid, "id", lid, null);
        ServerUtils.deleteRowsFromTable(con, "radius_pair_set_" + mid, "id", lid, null);
        ServerUtils.deleteRowsFromTable(con, "radius_pair_ip_" + mid, "id", lid, null);
        ServerUtils.deleteRowsFromTable(con, "user_alias_" + mid, "login_id", lid, null);
    }

    @Override
    public List<ModuleEntity> getObjectEntities(Connection con, int mid, int objectId) throws BGException {
        ArrayList<ModuleEntity> result = new ArrayList<ModuleEntity>(10);
        try {
            String query = "SELECT login_alias FROM user_alias_" + mid + " WHERE login_id=?";
            PreparedStatement psSelectAliases = con.prepareStatement(query);
            query = "SELECT id, login, comment, date1, date2 FROM user_login_" + mid + " WHERE object_id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, objectId);
            StringBuffer aliases = new StringBuffer(200);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                aliases.setLength(0);
                psSelectAliases.setInt(1, id);
                ResultSet rsAliases = psSelectAliases.executeQuery();
                while (rsAliases.next()) {
                    if (aliases.length() != 0) {
                        aliases.append(", ");
                    }
                    aliases.append(rsAliases.getString(1));
                }
                rsAliases.close();
                String login = rs.getString(2);
                String comment = rs.getString(3);
                String period = TimeUtils.formatPeriod(rs.getDate(4), rs.getDate(5));
                ModuleEntity entity = new ModuleEntity();
                entity.setName("\u041b\u043e\u0433\u0438\u043d");
                entity.setData(login + " [" + aliases + "]");
                entity.setComment(comment);
                entity.setPeriod(period);
                result.add(entity);
            }
            rs.close();
            ps.close();
            psSelectAliases.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected abstract LoginManager getLoginManager(Connection var1, int var2);
}

