/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractScriptManager;
import bitel.billing.server.script.bean.ScriptManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.common.TimeUtils;

public class ActionContractScriptTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        Map<Integer, Script> scriptMap = new ScriptManager(this.con).getScriptMap();
        ContractScriptManager contractScriptManager = new ContractScriptManager(this.con);
        List<ContractScript> contractScriptList = contractScriptManager.getContractScriptList(this.cid);
        for (ContractScript contractScript : contractScriptList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(contractScript.getId()));
            row.setAttribute("comment", contractScript.getComment());
            row.setAttribute("period", TimeUtils.formatPeriod(contractScript.getDate1(), contractScript.getDate2()));
            Script script = scriptMap.get(new Integer(contractScript.getScriptId()));
            if (script == null) continue;
            row.setAttribute("script", script.getTitle());
        }
    }
}

