/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractPattern;
import bitel.billing.server.contract.bean.ContractPatternManager;
import java.io.StringReader;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionUpdateContractPattern
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int pid = this.getIntParameter("pid", -1);
        float limit = this.getFloatParameter("limit", 0.0f);
        String mode = this.getParameter("mode");
        int face = this.getIntParameter("face", 0);
        String title = this.getParameter("title");
        String tariff = this.getParameter("tariff");
        int parameter = this.getIntParameter("parameter", -1);
        int dtl = this.getIntParameter("dtl", 0);
        int status = this.getIntParameter("status", 0);
        String tariffGroup = this.getParameter("tgid");
        String script = this.getParameter("script");
        String namePattern = this.getParameter("name_pattern", "");
        int titlePatternId = this.getIntParameter("title_pattern_id", 0);
        String objects = this.getParameter("objects");
        int domainId = this.getIntParameter("domainId", 0);
        String modules = this.getParameter("modules", null);
        Document data = XMLUtils.parseDocument(new InputSource(new StringReader(modules)));
        String dataPlugins = this.getParameter("plugins", null);
        Document pluginsDoc = XMLUtils.parseDocument(new InputSource(new StringReader(dataPlugins)));
        if (pluginsDoc != null) {
            Element plugins = XMLUtils.getElement(pluginsDoc, "plugins");
            data.getDocumentElement().appendChild(data.importNode(plugins, true));
        }
        if (data == null) {
            data = XMLUtils.parseDocument(new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><data/>")));
        }
        if (title == null || mode == null || tariff == null || parameter < 0) {
            throw new BGIllegalArgumentException();
        }
        Element dataElement = data.getDocumentElement();
        dataElement.setAttribute("webMenuId", this.getParameter("web_menu_id"));
        Element contractLabels = XMLUtils.createElement(dataElement, "contractLabels");
        for (Integer contractLabelId : Utils.toIntegerList(this.getParameter("contractLabels"))) {
            Element item = XMLUtils.createElement(contractLabels, "item");
            item.setAttribute("id", contractLabelId.toString());
        }
        ContractPattern pattern = new ContractPattern();
        pattern.setClosesumma(limit);
        pattern.setMode(mode.equals("debet") ? 1 : 0);
        pattern.setFc(face);
        pattern.setTitle(title);
        pattern.setTariffPlanList(Utils.toList(tariff));
        pattern.setParamsGroupId(parameter);
        pattern.setDaysToLive(dtl);
        pattern.setTariffGroupList(Utils.toIntegerList(tariffGroup));
        pattern.setScriptList(Utils.toIntegerList(script));
        pattern.setNamePattern(namePattern);
        pattern.setData(data);
        pattern.setPatternId(titlePatternId);
        pattern.setStatus(status);
        pattern.setObjectString(objects);
        pattern.setDomainId(domainId);
        new ContractPatternManager(this.con).updateContaractPattern(pid, pattern);
    }
}

