/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext.dhcp;

import bitel.billing.server.ext.dhcp.DHCPPacket;
import bitel.billing.server.ext.dhcp.DHCPProcessor;
import bitel.billing.server.ext.dhcp.DHCPRelayProcessor;
import bitel.billing.server.ext.dhcp.DHCPSetup;
import java.nio.channels.DatagramChannel;
import java.util.HashMap;
import ru.bitel.common.Utils;

public class DHCPVlanRelayProcessor
extends DHCPRelayProcessor {
    @Override
    protected DHCPProcessor.DHCPIpAddress getIpAddress(DHCPRelayProcessor.DHCPGate gate, DHCPPacket request, DHCPProcessor.DHCPClientIdentifier client) {
        log.debug((Object)"getting ip info...");
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to read postion =" + this.position_82));
        }
        byte byte1 = request.optionAgentInformation.getSubOption((byte)this.option_82).value[this.position_82];
        byte byte2 = request.optionAgentInformation.getSubOption((byte)this.option_82).value[this.position_82 + 1];
        log.debug((Object)"success!!");
        int vlan = Utils.unsignedByteToInt(byte1) << 8 | Utils.unsignedByteToInt(byte2);
        log.debug((Object)("vlan=" + vlan));
        byte[] address = gate.clientIpMap.get(vlan);
        if (address != null) {
            log.debug((Object)("adress by vlan =" + address));
        } else {
            log.debug((Object)"adress by vlan not found!!");
            byte[] macb = new byte[6];
            System.arraycopy(request.chaddr, 0, macb, 0, 6);
            String macR = Utils.bytesToHexString(macb);
            log.debug((Object)("mac from request = " + macR));
            String mac = "";
            for (int i = 0; i < 6; ++i) {
                mac = mac + macR.substring(i * 2, i * 2 + 2);
                if (i == 5) continue;
                mac = mac + " ";
            }
            log.debug((Object)("mac after convert = " + mac));
            HashMap map = (HashMap)gate.clientPortMacIpMap.get(vlan);
            if (map != null && map.get(mac) != null) {
                address = (byte[])map.get(mac);
                log.debug((Object)("adress by mac =" + address));
            } else {
                log.debug((Object)"adress by mac was not found");
            }
        }
        return address != null ? new DHCPProcessor.DHCPIpAddress(address) : null;
    }

    public DHCPVlanRelayProcessor(DHCPSetup setup, DatagramChannel channel) {
        super(setup, channel);
    }
}

