/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.installer.FtpClient;
import bitel.billing.server.installer.InstallerModule;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.common.Utils;

public class Install
extends FtpClient {
    public Install(String module, String set) {
        super(set);
        this.install(module);
    }

    private void install(String module) {
        try {
            System.out.println("Checking component for " + module + "...");
            String localBuildNumber = VersionInfo.getVersionInfo(module).getBuildNumber();
            String downloadFromServer = null;
            FtpClient.FileInfo fi = (FtpClient.FileInfo)this.ftpFiles.get(module);
            if (fi == null) {
                List avs = this.ftpFiles.keySet().stream().filter(u -> !u.startsWith("BG")).sorted().collect(Collectors.toList());
                System.out.println("No component name " + module + ", available: " + Utils.toString(avs, ", "));
                return;
            }
            if (downloadFromServer == null) {
                downloadFromServer = fi.fullName;
            }
            System.out.println("Found component for " + module + " local build " + localBuildNumber + " packet " + downloadFromServer + " ftp build " + fi.build);
            System.out.println("Install component (y/N): ");
            int entered = System.in.read();
            if (entered == 121 || entered == 89) {
                this.downloadFile(downloadFromServer);
                System.out.println("Start installing...");
                Thread.sleep(2000L);
                ArrayList<String> replacedFiles = new ArrayList<String>();
                String fileName = downloadFromServer;
                File file = new File(this.tmpDirPath + File.separator + fileName);
                new InstallerModule(file, replacedFiles);
                file.deleteOnExit();
                InstallerModule.replacedReport(replacedFiles);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

