/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.XMLUtils;

public class ModuleInf {
    private static final String supportedModuleVersion = "3.5";
    private String name;
    private String packServer;
    private String packClient;
    private String version;
    private String title;
    private String type;
    private int pluginId;
    private String libType;
    private String libsRemove;
    private boolean errors = false;
    private List<String[]> calls = new ArrayList<String[]>();

    public ModuleInf(Document moduleInf) {
        Element informationElement = XMLUtils.selectElement(moduleInf, "/module/information");
        if (informationElement != null) {
            this.type = XMLUtils.getAttribute(informationElement, "type");
            this.name = XMLUtils.getAttribute(informationElement, "name");
            this.title = ModuleInf.getAttributeByLang(moduleInf, "/module/information/title");
            this.libType = XMLUtils.getAttribute(informationElement, "lib_type");
            this.libsRemove = XMLUtils.getAttribute(informationElement, "lib_remove");
            this.packServer = XMLUtils.getAttribute(informationElement, "pack_server");
            this.packClient = XMLUtils.getAttribute(informationElement, "pack_client");
            this.version = XMLUtils.getAttribute(informationElement, "version");
            if (this.version != null && !this.version.equals(supportedModuleVersion)) {
                System.err.println("Error: modules(plagin) version " + this.version + " is not supported.");
                this.version = null;
            }
        }
        for (Element callElement : XMLUtils.selectElements(moduleInf, "/module/resources/call")) {
            String callClass = XMLUtils.getAttribute(callElement, "class");
            String callParam = XMLUtils.getAttribute(callElement, "param");
            if (callClass == null || callParam == null) continue;
            this.calls.add(new String[]{callClass, callParam});
        }
        boolean bl = this.errors = this.name == null || this.version == null || this.packServer == null || this.packClient == null || this.type == null;
        if (!this.errors) {
            this.compareModules();
        } else {
            System.err.println("Error: not all params was found in module.xml");
        }
    }

    private static String getAttributeByLang(Document document, String name) {
        String attributeValue = null;
        String lang = Locale.getDefault().getLanguage();
        attributeValue = XMLUtils.selectText(document, name + "[@lang='" + lang + "']");
        if (attributeValue == null) {
            attributeValue = XMLUtils.selectText(document, name + "[not(@lang)]");
        }
        return attributeValue;
    }

    private void compareModules() {
        if (this.packServer != null) {
            try {
                boolean allreadyInstalled = false;
                Setup sd = Setup.getSetup();
                Connection con = sd.getDBConnectionFromPool();
                if (con != null) {
                    String query = "SELECT version FROM installed_modules WHERE name=? AND pack_server=?";
                    PreparedStatement ps = con.prepareStatement(query);
                    ps.setString(1, this.name);
                    ps.setString(2, this.packServer);
                    ResultSet rs = ps.executeQuery();
                    allreadyInstalled = rs.next();
                    rs.close();
                    ps.close();
                }
                if (allreadyInstalled) {
                    System.out.println("Module(plugin): " + this.name + " already installed. Reinstalling....");
                } else {
                    System.out.println("Installing module(plugin): " + this.name + "...");
                }
                ServerUtils.closeConnection(con);
            }
            catch (Exception ex) {
                System.err.println(ex.getLocalizedMessage());
            }
        }
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public String getPackageServer() {
        return this.packServer;
    }

    public String getPackageClient() {
        return this.packClient;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public List<String[]> getCalls() {
        return this.calls;
    }

    public int getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(int pluginId) {
        this.pluginId = pluginId;
    }

    public String getLibType() {
        return this.libType;
    }

    public String getLibsRemove() {
        return this.libsRemove;
    }

    public void setLibsRemove(String libsRemove) {
        this.libsRemove = libsRemove;
    }
}

