/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.installer.FtpClient;
import bitel.billing.server.installer.InstallerModule;
import bitel.billing.server.installer.ScanUtils;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class Update
extends FtpClient {
    public Update() {
        this(null);
    }

    public Update(String set) {
        super(set);
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void update() {
        ArrayList<String> needToUpdate = new ArrayList<String>();
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            List<String> modules = new ModuleManager(con).getInstalledModules();
            modules.add("client");
            modules.add("server");
            modules.add("update_lib");
            ScanUtils.ModuleInfo clientVersionInfo = new ScanUtils.ModuleInfo();
            clientVersionInfo.build = "0";
            List<ScanUtils.ModuleInfo> modulesInfo = new ScanUtils(con).getModulesInfo("update");
            for (ScanUtils.ModuleInfo moduleInfo : modulesInfo) {
                if (!moduleInfo.name.equals("client")) continue;
                clientVersionInfo = moduleInfo;
                break;
            }
            for (String string : modules) {
                FtpClient.FileInfo fileInfo;
                System.out.println("Checking updates for " + string + "...");
                String localBuildNumber = VersionInfo.getVersionInfo(string).getBuildNumber();
                String nameOnServer = null;
                String downloadFromServer = null;
                if (string.equals("server")) {
                    nameOnServer = "BGBillingServer";
                    downloadFromServer = "update_" + this.serverVersionInfo.getVersion() + ".zip";
                } else if (string.equals("client")) {
                    nameOnServer = "BGBillingClient";
                    downloadFromServer = "update_" + this.serverVersionInfo.getVersion() + ".zip";
                    localBuildNumber = clientVersionInfo.build;
                } else {
                    void var7_13;
                    int pos = string.lastIndexOf(46);
                    if (pos > 0) {
                        String string2 = string.substring(pos + 1);
                    }
                    nameOnServer = var7_13;
                    downloadFromServer = null;
                }
                if ((fileInfo = (FtpClient.FileInfo)this.ftpFiles.get(nameOnServer)) == null || fileInfo.build.equals(localBuildNumber)) continue;
                if (downloadFromServer == null) {
                    downloadFromServer = fileInfo.fullName;
                }
                System.out.println("Found update for " + nameOnServer + " build " + localBuildNumber + " packet " + downloadFromServer + " updating to build " + fileInfo.build);
                if (needToUpdate.contains(downloadFromServer)) continue;
                needToUpdate.add(downloadFromServer);
            }
            if (needToUpdate.size() == 0) {
                System.out.println("Not updates found, press any key for exit...");
                System.in.read();
                System.exit(0);
            } else {
                System.out.println("Install " + needToUpdate.size() + " updates (y/N): ");
                int entered = System.in.read();
                if (entered == 121 || entered == 89) {
                    for (String fileName : needToUpdate) {
                        this.downloadFile(fileName);
                    }
                    System.out.println("Start installing...");
                    Thread.sleep(2000L);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String fileName : needToUpdate) {
                        File file = new File(this.tmpDirPath + File.separator + fileName);
                        new InstallerModule(file, arrayList);
                        file.deleteOnExit();
                    }
                    InstallerModule.replacedReport(arrayList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }
}

