/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer.library;

import bitel.billing.server.installer.event.GetLibrariesInfoEvent;
import bitel.billing.server.installer.event.GetLibraryEvent;
import bitel.billing.server.installer.library.LibraryUpdate;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;

public class LibraryEventListener {
    private static final Logger log = Logger.getLogger(LibraryEventListener.class);

    public LibraryEventListener() throws Exception {
        EventProcessor eventProcessor = EventProcessor.getInstance();
        eventProcessor.addListener(new EventListener<GetLibrariesInfoEvent>(){

            @Override
            public void notify(GetLibrariesInfoEvent e, EventListenerContext ctx) throws BGException {
                try {
                    e.setLibList(LibraryUpdate.getLibrariesInfo());
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }, GetLibrariesInfoEvent.class);
        eventProcessor.addListener(new EventListener<GetLibraryEvent>(){

            @Override
            public void notify(GetLibraryEvent e, EventListenerContext ctx) throws BGException {
                try {
                    e.setData(LibraryUpdate.getLibraryData(e.getLibName()));
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }, GetLibraryEvent.class);
    }
}

