/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.script.global.bean;

import bitel.billing.server.script.global.bean.GlobalScript;
import bitel.billing.server.script.global.bean.GlobalScriptMachine;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class GlobalScriptManager {
    protected String tableName = "";
    ConnectionSet connectionSet;

    public GlobalScriptManager(ConnectionSet connectionSet) {
        this.connectionSet = connectionSet;
        this.tableName = "global_script";
    }

    public Object executeGlobalScript(int scriptId) {
        GlobalScript gs = this.getScriptById(scriptId);
        GlobalScriptMachine gsm = new GlobalScriptMachine(new ScriptInstance(gs), this.connectionSet);
        return gsm.runScript(Setup.getSetup(), true);
    }

    public List<GlobalScript> getScripts() {
        ArrayList<GlobalScript> result = new ArrayList<GlobalScript>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.connectionSet.getConnection().prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GlobalScript f = new GlobalScript();
                this.loadScriptFromRS(rs, f);
                result.add(f);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public GlobalScript getScriptById(int id) {
        GlobalScript result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.connectionSet.getConnection().prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new GlobalScript();
                this.loadScriptFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public GlobalScript getScriptByID(int id) {
        return this.getScriptById(id);
    }

    public void updateScript(String id, GlobalScript gs) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (id.equals("new")) {
                query = "INSERT INTO " + this.tableName + " (title, script, user_id)  VALUES (?, ?, ?)";
                ps = this.connectionSet.getConnection().prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, script=?, user_id=? WHERE id=?";
                ps = this.connectionSet.getConnection().prepareStatement(query);
                ps.setInt(4, Utils.parseInt(id, 0));
            }
            ps.setString(1, gs.getTitle());
            ps.setString(2, gs.getScript());
            ps.setInt(3, gs.getUserId());
            ps.executeUpdate();
            if (id.equals("new")) {
                gs.setId(ServerUtils.lastInsertId(ps));
            } else {
                gs.setId(Utils.parseInt(id, 0));
            }
            gs.setTimeRevision(this.getScriptById(gs.getId()).getTimeRevision());
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteScript(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.connectionSet.getConnection().prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadScriptFromRS(ResultSet rs, GlobalScript f) throws SQLException {
        f.setId(rs.getInt("id"));
        f.setScript(rs.getString("script"));
        f.setTitle(rs.getString("title"));
        f.setUserId(rs.getInt("user_id"));
        f.setTimeRevision(rs.getTimestamp("change_time"));
    }

    public Revision getRevisionProperties(int id) {
        try {
            String query = "SELECT id, user_id, change_time FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.connectionSet.getConnection().prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Revision result = new Revision();
                result.setId(rs.getInt("id"));
                result.setUserId(rs.getInt("user_id"));
                result.setUserName(UserMap.getUser(result.getUserId()).getName());
                result.setTimeRevision(rs.getTimestamp("change_time"));
                rs.close();
                ps.close();
                return result;
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

