/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.service.action;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.Server;
import bitel.billing.server.installer.ScanUtils;
import bitel.billing.server.service.action.base.ActionBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionAbout
extends ActionBase {
    private Date maximumBuildTime = null;

    @Override
    public void doAction() throws SQLException, BGException {
        VersionInfo vi;
        Element modules = this.createElement(this.rootNode, "modules");
        String query = "SELECT name FROM installed_modules WHERE type IN ('module', 'plugin') ORDER BY name";
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            String name = rs.getString(1);
            Element element = this.createElement(modules, "module");
            element.setAttribute("name", name);
            vi = VersionInfo.getVersionInfo(name);
            element.setAttribute("version", vi.getVersion());
            element.setAttribute("build.time", vi.getBuildTime());
            element.setAttribute("build.number", vi.getBuildNumber());
            element.setAttribute("versionstring", vi.getVersionString());
            this.checkLastBuildTime(vi.getBuildTime());
        }
        rs.close();
        st.close();
        Element server = this.createElement(this.rootNode, "server");
        server.setAttribute("server", Utils.getOsJavaVersion(false));
        server.setAttribute("serverfull", Utils.getOsJavaVersion(true));
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm z Z");
        server.setAttribute("servertime", df.format(new Date()) + " (" + TimeZone.getDefault().getID() + ")");
        server.setAttribute("memory", Utils.memoryStatusShort());
        server.setAttribute("serverlocale", Locale.getDefault().toString());
        server.setAttribute("serverdbtime", this.getDbInfos());
        server.setAttribute("serverdbcharset", this.getDbCharsets());
        server.setAttribute("uptimestatus", ServerUtils.uptimeStatus(Server.START_TIME).replace('\t', ' '));
        try {
            Utils.checkJava();
        }
        catch (BGException e) {
            for (String line : Utils.toList(e.getMessage(), "\n")) {
                server.setAttribute("server", server.getAttribute("server") + "\n    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: " + line);
            }
        }
        vi = VersionInfo.getVersionInfo("server");
        server.setAttribute("version", vi.getVersion());
        server.setAttribute("build.time", vi.getBuildTime());
        server.setAttribute("build.number", vi.getBuildNumber());
        server.setAttribute("versionstring", vi.getVersionString());
        this.checkLastBuildTime(vi.getBuildTime());
        ScanUtils.ModuleInfo clientVersionInfo = null;
        List<ScanUtils.ModuleInfo> modulesInfo = new ScanUtils(this.con).getModulesInfo("update");
        for (ScanUtils.ModuleInfo mi : modulesInfo) {
            if (!mi.name.equals("client")) continue;
            clientVersionInfo = mi;
            break;
        }
        if (clientVersionInfo != null) {
            String ver = clientVersionInfo.version;
            String build = clientVersionInfo.build;
            String time = clientVersionInfo.buildtime;
            Element client = this.createElement(this.rootNode, "client");
            client.setAttribute("version", ver);
            client.setAttribute("build.time", time);
            client.setAttribute("build.number", build);
            client.setAttribute("versionstring", VersionInfo.formatVersionString(ver, build, time));
            this.checkLastBuildTime(time);
        }
        if (this.maximumBuildTime != null && this.maximumBuildTime.after(Server.START_TIME)) {
            server.setAttribute("uptimestatus_warning", "\u041a\u0430\u0436\u0435\u0442\u0441\u044f, \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f");
        }
    }

    private String getDbInfos() throws SQLException {
        Throwable throwable;
        Connection baseCon;
        StringBuilder sb = new StringBuilder();
        HashSet<String> allvalues = new HashSet<String>();
        String dbNow = ActionAbout.getDbNow(this.con);
        sb.append("master: ").append(dbNow);
        allvalues.add(dbNow);
        for (String id : this.setup.getSlaveBaseId()) {
            baseCon = this.setup.getSlaveConnectionFromPool(id);
            throwable = null;
            try {
                dbNow = ActionAbout.getDbNow(baseCon);
                sb.append(", ").append("slave@" + id + ": ").append(dbNow);
                allvalues.add(dbNow);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (baseCon == null) continue;
                if (throwable != null) {
                    try {
                        baseCon.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                baseCon.close();
            }
        }
        for (String id : this.setup.getTrashBaseId()) {
            baseCon = this.setup.getTrashConnectionFromPool(id);
            throwable = null;
            try {
                dbNow = ActionAbout.getDbNow(baseCon);
                sb.append(", ").append("trash@" + id + ": ").append(dbNow);
                allvalues.add(dbNow);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (baseCon == null) continue;
                if (throwable != null) {
                    try {
                        baseCon.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                baseCon.close();
            }
        }
        if (allvalues.size() != 1) {
            sb.append("\n    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: \u0432 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0411\u0414 \u043f\u043e\u043f\u043b\u044b\u043b\u043e \u0432\u0440\u0435\u043c\u044f");
        }
        return sb.toString();
    }

    private static String getDbNow(Connection con) {
        String serverdbtime = "?";
        try {
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT DATE_FORMAT(NOW(),'%d.%m.%Y %H:%i'), IF(@@session.time_zone = 'SYSTEM', @@system_time_zone, @@session.time_zone)");
            if (rs.next()) {
                serverdbtime = rs.getString(1) + " " + rs.getString(2);
            }
            rs.close();
            st.close();
        }
        catch (Exception e) {
            serverdbtime = e.toString();
        }
        return serverdbtime;
    }

    private String getDbCharsets() throws SQLException {
        String serverdbcharsets = "?";
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery("SELECT @@character_set_connection, @@collation_connection, @@character_set_database, @@collation_database");
        if (rs.next()) {
            String character_set_connection = rs.getString(1);
            String collation_connection = rs.getString(2);
            String character_set_database = rs.getString(3);
            String collation_database = rs.getString(4);
            serverdbcharsets = "connection: " + character_set_connection + "(" + collation_connection + "), database: " + character_set_database + "(" + collation_database + ")";
            if (!character_set_connection.equals(character_set_database) || !collation_connection.equals(collation_database)) {
                serverdbcharsets = serverdbcharsets + "\n    \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415: \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0438 \u0432 \u043a\u043e\u043d\u043d\u0435\u043a\u0448\u0435\u043d\u0435 \u043a \u0411\u0414 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430\u043c \u0411\u0414";
            }
        }
        rs.close();
        st.close();
        return serverdbcharsets;
    }

    private void checkLastBuildTime(String buildTime) {
        Date date = TimeUtils.parseDate(buildTime, "dd.MM.yyyy HH:mm:ss", TimeZone.getTimeZone("Asia/Yekaterinburg"));
        if (date != null && (this.maximumBuildTime == null || date.after(this.maximumBuildTime))) {
            this.maximumBuildTime = date;
        }
    }
}

