/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.math.BigDecimal;
import java.util.Map;
import ru.bitel.common.Utils;

public abstract class CallTypeCostTariffTreeNode
extends DefaultTariffTreeNode {
    public static final int COST_TYPE_MIN = 1;
    public static final int COST_TYPE_CALL = 2;
    public static final int COST_SOURCE_NODE = 1;
    public static final int COST_SOURCE_CDR = 2;
    public static final int COST_SOURCE_COSTMAP = 3;
    private Float cost = null;
    private boolean isDefault = false;
    private int costType = 1;
    private int costSource = 1;
    public static FieldNames DEFAULT_FIELD_NAMES = new FieldNames("");

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> params = this.getDataInHash();
        try {
            String source;
            this.cost = Float.valueOf(Utils.parseFloat(Utils.maskNull(params.get("cost")), 0.0f));
            this.isDefault = params.containsKey("default");
            if (Utils.maskNull(params.get("cost_type")).equals("call")) {
                this.costType = 2;
            }
            if ((source = params.get("cost_source")) != null) {
                if ("cdr".equals(source)) {
                    this.costSource = 2;
                } else if ("costMap".equals(source)) {
                    this.costSource = 3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (params.size() == 0) {
            try {
                this.cost = Float.valueOf(Utils.parseFloat(Utils.maskNull(this._data), 0.0f));
                this.isDefault = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        FieldNames names = this.getFieldNames();
        Integer callType = (Integer)request.getRequestParam("call_type");
        if (callType != null && callType.intValue() == this.getCallType()) {
            Float cost;
            int costSource;
            boolean acceptDefault;
            Integer acceptDeep = (Integer)request.getResponseParam(names.acceptDeepField);
            boolean acceptInParent = acceptDeep != null && acceptDeep > this._deep;
            boolean bl = acceptDefault = request.getResponseParam(names.acceptDefaultField) != null;
            if (this.costSource == 3) {
                costSource = 1;
                BigDecimal bdCost = (BigDecimal)request.getResponseParam("costMapCost");
                if (bdCost != null) {
                    cost = Float.valueOf(bdCost.floatValue());
                    Integer costMapItemId = (Integer)request.getResponseParam("costMapItemId_");
                    if (costMapItemId != null && costMapItemId < 0) {
                        request.setResponseParam(names.costMapItemId, costMapItemId);
                    }
                } else {
                    cost = this.cost;
                }
            } else {
                costSource = this.costSource;
                cost = this.cost;
            }
            if (!this.isDefault) {
                request.setAccepted();
                request.setResponseParam(names.costField, cost);
                request.setResponseParam(names.costTypeField, this.costType);
                request.setResponseParam(names.costSourceField, costSource);
                request.dropResponseParam(names.acceptDeepField);
                request.dropResponseParam(names.acceptDefaultField);
            } else if (request.getResponseParam(names.costField) == null || acceptDefault && acceptInParent) {
                request.setAccepted();
                request.setResponseParam(names.costField, cost);
                request.setResponseParam(names.costTypeField, this.costType);
                request.setResponseParam(names.costSourceField, costSource);
                request.setResponseParam(names.acceptDeepField, this._deep);
                request.setResponseParam(names.acceptDefaultField, "1");
            }
        }
    }

    protected FieldNames getFieldNames() {
        return DEFAULT_FIELD_NAMES;
    }

    protected abstract int getCallType();

    public static class FieldNames {
        public String prefix;
        public String costField;
        public String costTypeField;
        public String costSourceField;
        public String acceptDefaultField;
        public String acceptDeepField;
        public String costMapItemId;

        public FieldNames(String prefix) {
            this.prefix = prefix;
            this.costField = prefix + "min_cost";
            this.costTypeField = prefix + "cost_type";
            this.costSourceField = prefix + "cost_source";
            this.acceptDeepField = prefix + "accept_deep";
            this.acceptDefaultField = prefix + "accept_default";
            this.costMapItemId = prefix + "costMapItemId";
        }
    }
}

