/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.common.RangeParser;
import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.util.Map;
import ru.bitel.common.Utils;

public class NPrefixTariffTreeNode
extends DefaultTariffTreeNode {
    private RangeParser rangeParser;
    private int dest;
    private int zone;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        try {
            this.rangeParser = new RangeParser(Utils.maskNull(dataHash.get("prefix")));
            this.dest = Utils.parseInt(dataHash.get("dest"));
            this.zone = Utils.parseInt(dataHash.get("zone"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        String phone = (String)request.getRequestParam("phone");
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            this.processForChilds(request);
        } else if (phone != null && this.rangeParser != null && !request.wasAccepted()) {
            String phoneRest = (String)request.getRequestParam("phone_rest");
            if (phoneRest == null) {
                phoneRest = phone;
            }
            RangeParser.CheckResult result = this.rangeParser.checkPrefixWithResult(phoneRest);
            if (result.result) {
                phoneRest = phoneRest.substring(result.length);
                request.setRequestParam("phone_rest", phoneRest);
                if (this.dest > 0) {
                    request.setResponseParam("dest", this.dest);
                }
                if (this.zone > 0) {
                    request.setResponseParam("zone", this.zone);
                }
                this.processForChilds(request);
                request.setAccepted();
            }
        }
    }
}

