/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.util.Map;
import java.util.StringTokenizer;

public class PrefixCostTariffTreeNode
extends DefaultTariffTreeNode {
    @Override
    public void processRequest(TariffRequest request) {
        Map<String, String> map = this.getDataInHash();
        String prefix = map.get("prefix");
        String cost = map.get("cost");
        String phone = (String)request.getRequestParam("phone");
        if (phone != null && prefix != null) {
            phone = phone.trim();
            StringTokenizer st = new StringTokenizer(prefix, ",");
            String pref = null;
            while (st.hasMoreTokens()) {
                pref = st.nextToken().trim();
                if (phone.startsWith(pref)) {
                    int relevance = pref.length();
                    if (relevance <= request.getRelevance()) continue;
                    request.setAccepted();
                    request.setRelevance(relevance);
                    request.setResponseParam("min_cost", new Float(cost));
                    continue;
                }
                if (!pref.equals("*") || request.wasAccepted()) continue;
                request.setAccepted();
                request.setRelevance(0);
                request.setResponseParam("min_cost", new Float(cost));
            }
        }
    }
}

