/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.bitel.common.Utils;

public class ZoneCostRangeTariffTreeNode
extends DefaultTariffTreeNode {
    public static final int OUTGOING_CALL = 1;
    public static final int INCOMING_CALL = 2;
    private List<Integer> zones;
    private int mode;
    private BigDecimal to;
    private int type;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        this.zones = Utils.toIntegerList(dataHash.get("zones"));
        this.mode = Utils.parseInt(dataHash.get("mode"));
        this.to = Utils.parseBigDecimal(dataHash.get("to"), BigDecimal.ZERO);
        this.type = Utils.parseInt(dataHash.get("type"), 0);
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        if (action == null || !action.equals("init")) {
            if (action != null && action.equals("reset")) {
                HashSet<Integer> zoneSet = (HashSet<Integer>)request.getResponseParam("zone_cost_set");
                if (zoneSet == null) {
                    zoneSet = new HashSet<Integer>();
                    request.setResponseParam("zone_cost_set", zoneSet);
                }
                zoneSet.addAll(this.zones);
                request.addHistoryMsg("ZoneCostRangeTariffTreeNode=> set zones=" + Utils.toString(this.zones) + "\n");
            } else {
                BigDecimal trafficValue = null;
                trafficValue = this.type == 2 ? this.getTraffic(request, "zone_cost_in_") : (this.type == 1 ? this.getTraffic(request, "zone_cost_out_") : this.getTraffic(request, "zone_cost_"));
                trafficValue = trafficValue == null ? BigDecimal.ZERO : trafficValue;
                request.addHistoryMsg("ZoneCostRangeTariffTreeNode=> zones=" + Utils.toString(this.zones) + " | trafficValue=" + trafficValue);
                BigDecimal to = this.to;
                if (this.mode == 0) {
                    Float part = (Float)request.getRequestParam("part");
                    if (part == null) {
                        part = Float.valueOf(1.0f);
                    }
                    BigDecimal bdPart = new BigDecimal(part.floatValue());
                    to = to.multiply(bdPart);
                }
                request.addHistoryMsg(" | to=" + to);
                BigDecimal remain = to.subtract(trafficValue);
                request.addHistoryMsg(" | remain=" + remain);
                if (remain.compareTo(BigDecimal.ZERO) > 0) {
                    request.setResponseParam("cost_period_remain", remain);
                    request.addHistoryMsg(" processForChilds...");
                    this.processForChilds(request);
                }
                request.addHistoryMsg("\n");
            }
        }
    }

    private BigDecimal getTraffic(TariffRequest request, String typeKey) {
        BigDecimal trafficValue = BigDecimal.ZERO;
        for (Integer zone : this.zones) {
            trafficValue = trafficValue.add((BigDecimal)request.getRequestParam("zone_cost_in_" + zone));
        }
        return trafficValue;
    }
}

