/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.action;

import bitel.billing.server.tariff.TariffTreeBuilder;
import bitel.billing.server.tariff.action.base.ActionBase;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;

public class ActionExportTariffPlan
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int tpid = this.getIntParameter("tpid", -1);
        if (tpid < 0) {
            return;
        }
        TariffPlanDao tpm = new TariffPlanDao(this.con);
        TariffPlan tp = (TariffPlan)tpm.get(tpid);
        Element tariffs = this.createElement(this.rootNode, "tariffs");
        Element tariff = this.createElement(tariffs, "tariff");
        tariff.setAttribute("title", tp.getTitle());
        tariff.setAttribute("face", String.valueOf(tp.getFilterFace()));
        tariff.setAttribute("mask", tp.getFilterMask());
        tariff.setAttribute("groups", String.valueOf(tp.getFilterGroups()));
        tariff.setAttribute("actual", String.valueOf(tp.isUsed()));
        this.stringToLines(this.createElement(tariff, "config"), tp.getConfig());
        int treeId = tpm.getTariffPlanTreeId(tpid);
        Map<Integer, Integer> moduleTreesMap = tpm.getModuleTrees(treeId);
        for (int moduleTreeId : moduleTreesMap.keySet()) {
            int moduleId = moduleTreesMap.get(moduleTreeId);
            Element module = this.createElement(tariff, "module");
            module.setAttribute("mid", String.valueOf(moduleId));
            module.setAttribute("treeId", String.valueOf(moduleTreeId));
            Element tree = this.createElement(module, "tree");
            TariffTreeBuilder ttb = new TariffTreeBuilder(this.con);
            ttb.addMTreeItems(treeId, moduleId, tree, true, 0);
        }
    }
}

