/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.bean;

import bitel.billing.server.tariff.voice.bean.DestManager;
import bitel.billing.server.tariff.voice.bean.GeographicCode;
import bitel.billing.server.tariff.voice.bean.TableManager;
import bitel.billing.server.tariff.voice.bean.ZoneManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class GeographicCodeManager {
    private Connection con;
    private int mid;
    private String tableName;
    private String destTableName;

    public GeographicCodeManager(Connection con, int mid) {
        String prefix = TableManager.getPrefix(con, mid);
        this.tableName = prefix + "geographic_code_" + mid;
        this.destTableName = prefix + "dest_" + mid;
        this.con = con;
        this.mid = mid;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void updateCode(GeographicCode code) {
        try {
            String query = "UPDATE " + this.tableName + " SET dest_id=?, start_level=?, end_level=? WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, code.getDestId());
            ps.setInt(2, code.getStartLevel());
            ps.setInt(3, code.getEndLevel());
            ps.setString(4, code.getCode());
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO " + this.tableName + " (code, dest_id, start_level, end_level) VALUES (?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
                ps.setString(1, code.getCode());
                ps.setInt(2, code.getDestId());
                ps.setInt(3, code.getStartLevel());
                ps.setInt(4, code.getEndLevel());
                ps.executeUpdate();
                ps.close();
            } else {
                ps.close();
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCode(String code, String destTitle) {
        int destId = new DestManager(this.con, this.mid).getCode(destTitle);
        try {
            String query = "UPDATE " + this.tableName + " SET dest_id=? WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, destId);
            ps.setString(2, code);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO " + this.tableName + " (code, dest_id) VALUES (?, ?)";
                ps = this.con.prepareStatement(query);
                ps.setString(1, code);
                ps.setInt(2, destId);
                ps.executeUpdate();
                ps.close();
            } else {
                ps.close();
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteCode(String code) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, code);
            ps.executeUpdate();
            ps.close();
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAllCodes() {
        try {
            String query = "DELETE FROM " + this.tableName;
            this.con.prepareStatement(query).executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GeographicCode getRootCode(int mapId) {
        try {
            Map<Integer, String> zoneTitles = new ZoneManager(this.con, this.mid).getZoneTitles();
            String query = null;
            GeographicCode root = new GeographicCode();
            root.setCode("");
            GeographicCode[] path = new GeographicCode[20];
            query = "SELECT gc.code, gc.dest_id, dest.title, zone_id FROM " + this.tableName + " as gc LEFT JOIN " + this.destTableName + " as dest ON dest.id=gc.dest_id LEFT JOIN " + TableManager.getTable(this.con, this.mid, "zone_map_item_") + " as zone ON (zone.map_id=? AND zone.code=gc.code) ORDER BY code";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mapId);
            String lastCode = root.getCode();
            int level = 0;
            path[level] = root;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String currCode = rs.getString(1);
                GeographicCode code = new GeographicCode();
                code.setCode(currCode);
                code.setDestId(rs.getInt(2));
                code.setDest(rs.getString(3));
                int zoneId = rs.getInt(4);
                if (zoneId > 0) {
                    code.setZoneId(zoneId);
                    code.setZone(zoneTitles.get(zoneId));
                }
                if (!currCode.startsWith(lastCode)) {
                    while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                    }
                }
                GeographicCode parent = path[level];
                parent.addSubCode(code);
                path[++level] = code;
                lastCode = currCode;
            }
            rs.close();
            ps.close();
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GeographicCode getRootCode(boolean destinationTitle) {
        if (!destinationTitle) {
            return this.getRootCode();
        }
        try {
            String query = null;
            GeographicCode root = new GeographicCode();
            root.setCode("");
            GeographicCode[] path = new GeographicCode[20];
            query = "SELECT gc.code, gc.dest_id, gc.start_level, gc.end_level, dest.title FROM " + this.tableName + " as gc LEFT JOIN " + this.destTableName + " as dest ON dest.id=gc.dest_id ORDER BY code";
            PreparedStatement ps = this.con.prepareStatement(query);
            String lastCode = root.getCode();
            int level = 0;
            path[level] = root;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String currCode = rs.getString(1);
                GeographicCode code = new GeographicCode();
                code.setCode(currCode);
                code.setDestId(rs.getInt(2));
                code.setStartLevel(rs.getInt(3));
                code.setEndLevel(rs.getInt(4));
                code.setDest(rs.getString(5));
                if (!currCode.startsWith(lastCode)) {
                    while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                    }
                }
                GeographicCode parent = path[level];
                parent.addSubCode(code);
                path[++level] = code;
                lastCode = currCode;
            }
            rs.close();
            ps.close();
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GeographicCode getRootCode() {
        try {
            String query = null;
            GeographicCode root = new GeographicCode();
            root.setCode("");
            GeographicCode[] path = new GeographicCode[20];
            query = "SELECT code, dest_id, start_level, end_level FROM " + this.tableName + " ORDER BY code";
            PreparedStatement ps = this.con.prepareStatement(query);
            String lastCode = root.getCode();
            int level = 0;
            path[level] = root;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String currCode = rs.getString(1);
                GeographicCode code = new GeographicCode();
                code.setCode(currCode);
                code.setDestId(rs.getInt(2));
                code.setStartLevel(rs.getInt(3));
                code.setEndLevel(rs.getInt(4));
                if (!currCode.startsWith(lastCode)) {
                    while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                    }
                }
                GeographicCode parent = path[level];
                parent.addSubCode(code);
                path[++level] = code;
                lastCode = currCode;
            }
            rs.close();
            ps.close();
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadFromFile(String data, boolean addNew, boolean updateExist) {
        try {
            DestManager du = new DestManager(this.con, this.mid);
            du.load();
            String query = null;
            query = "INSERT INTO " + this.tableName + " (code, dest_id, start_level, end_level) VALUES (?, ?, ?, ?)";
            PreparedStatement psInsert = this.con.prepareStatement(query);
            query = "UPDATE " + this.tableName + " SET dest_id=?, start_level=?, end_level=? WHERE code=?";
            PreparedStatement psUpdate = this.con.prepareStatement(query);
            StringTokenizer st = new StringTokenizer(data, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                String[] code_dest = line.split("\\s*\t\\s*");
                String code = code_dest[0];
                if (Utils.parseLong(code) <= 0L) continue;
                int destCode = 0;
                String destTitle = null;
                int startLevel = 0;
                int endLevel = 0;
                if (code_dest.length > 1) {
                    destTitle = code_dest[1].trim();
                }
                if (code_dest.length > 2) {
                    startLevel = Utils.parseInt(code_dest[2].trim());
                }
                if (code_dest.length > 3) {
                    endLevel = Utils.parseInt(code_dest[3].trim());
                }
                if (Utils.notBlankString(destTitle)) {
                    destCode = du.getCode(destTitle);
                }
                boolean needInsert = true;
                if (updateExist) {
                    psUpdate.setInt(1, destCode);
                    psUpdate.setInt(2, startLevel);
                    psUpdate.setInt(3, endLevel);
                    psUpdate.setString(4, code);
                    boolean bl = needInsert = psUpdate.executeUpdate() == 0;
                }
                if (!addNew || !needInsert) continue;
                psInsert.setString(1, code);
                psInsert.setInt(2, destCode);
                psInsert.setInt(3, startLevel);
                psInsert.setInt(4, endLevel);
                try {
                    psInsert.executeUpdate();
                }
                catch (Exception exception) {}
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String exportToFile(String prefix) {
        StringBuilder result = new StringBuilder(20000000);
        try {
            DestManager du = new DestManager(this.con, this.mid);
            String query = "SELECT g_code.code, dest.title, g_code.start_level, g_code.end_level FROM " + this.tableName + " AS g_code  LEFT JOIN " + du.getTableName() + " dest ON g_code.dest_id=dest.id";
            if (Utils.notBlankString(prefix)) {
                query = query + " WHERE g_code.code LIKE '" + prefix + "%' AND g_code.code!='" + prefix + "' ";
            }
            query = query + " ORDER BY g_code.code";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.append(rs.getString(1));
                result.append("\t");
                result.append(rs.getString(2));
                result.append("\t");
                result.append(rs.getString(3));
                result.append("\t");
                result.append(rs.getString(4));
                result.append("\n");
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public List<GeographicCode> getGeographicCodeList() {
        ArrayList<GeographicCode> result = new ArrayList<GeographicCode>(10000);
        try {
            PreparedStatement ps = null;
            String query = null;
            ResultSet rs = null;
            query = "SELECT gc.code, gc.dest_id, gc.start_level, gc.end_level, dest.title FROM " + this.tableName + " AS gc LEFT JOIN " + this.destTableName + " as dest ON dest.id=gc.dest_id ORDER BY gc.code";
            ps = this.con.prepareStatement(query);
            rs = ps.executeQuery();
            while (rs.next()) {
                GeographicCode code = new GeographicCode();
                code.setCode(rs.getString(1));
                code.setDestId(rs.getInt(2));
                code.setDest(rs.getString(5));
                code.setStartLevel(rs.getInt(3));
                code.setEndLevel(rs.getInt(4));
                result.add(code);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

