/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.ssh;

import bitel.billing.server.util.terminal.AbstractTerminalSession;
import bitel.billing.server.util.terminal.AnsiTerminalInputStream;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import ru.bitel.bgbilling.common.BGException;

public class SSHSession
extends AbstractTerminalSession {
    private String login;
    private String pswd;
    private Session session;
    private ChannelShell channel;
    private String privateKeyFile = null;

    public SSHSession(String host, int port, String login, String pswd) {
        super(host, port);
        this.endString = "#";
        this.login = login;
        this.pswd = pswd;
    }

    @Override
    protected void initConnection() throws Exception {
        Properties pr = new Properties();
        pr.put("StrictHostKeyChecking", "no");
        JSch jSch = new JSch();
        if (this.privateKeyFile != null) {
            byte[] emptyPassPhrase = new byte[]{};
            jSch.addIdentity(this.privateKeyFile, null, emptyPassPhrase);
        }
        this.session = jSch.getSession(this.login, this.host, this.port);
        this.session.setPassword(this.pswd);
        this.session.setConfig(pr);
        this.session.connect(this.timeout);
        this.channel = (ChannelShell)this.session.openChannel("shell");
        PipedInputStream pinput = new PipedInputStream();
        this.inputStream = pinput;
        this.inputStream = new AnsiTerminalInputStream(this.inputStream);
        PipedOutputStream outStream = new PipedOutputStream(pinput);
        this.channel.setOutputStream((OutputStream)outStream);
        PipedInputStream commandStream = new PipedInputStream();
        PipedOutputStream pipeOutInputStream = new PipedOutputStream(commandStream);
        this.outPutStream = pipeOutInputStream;
        this.channel.setInputStream((InputStream)commandStream);
        this.channel.connect();
    }

    @Override
    public void disconnect() throws BGException {
        try {
            this.outPutStream.close();
            this.inputStream.close();
        }
        catch (IOException e) {
            throw new BGException(e);
        }
        this.session.disconnect();
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }
}

