/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.service;

import bitel.billing.server.admin.licview.Temp;
import bitel.billing.server.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseItemData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.bgbilling.kernel.admin.license.common.service.LicenseService;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.LicenseLocalDao;
import ru.bitel.bgbilling.kernel.admin.license.server.bean.LicenseRemoteDao;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.license.common.service.LicenseService")
public class LicenseServiceImpl
extends AbstractService
implements LicenseService {
    private static final String FILE_LICENSE = "data" + File.separatorChar + "lic.properties";
    private static List<LicenseData> remoteList = new ArrayList<LicenseData>();
    private static LicenseData fileLicenseData = null;

    @Override
    public void init() throws BGException {
        try (LicenseRemoteDao licenseRemoteDao = new LicenseRemoteDao(this.getConnection());){
            File file = new File(FILE_LICENSE);
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int b2 = 0;
            while ((b2 = fileInputStream.read(buf)) > -1) {
                byteArrayOutputStream.write(buf, 0, b2);
            }
            fileInputStream.close();
            String hash = Utils.bytesToHexString(Utils.getDigestBytes(byteArrayOutputStream.toByteArray(), "SHA-256"));
            fileLicenseData = new LicenseData();
            fileLicenseData.setActive(true);
            fileLicenseData.setCreateDate(new Date(file.lastModified()));
            fileLicenseData.setCount(new String(byteArrayOutputStream.toByteArray()).split("\n").length - 2);
            fileLicenseData.setStorage(Storage.FILE);
            fileLicenseData.setHash(hash);
            boolean setActive = false;
            try (LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());){
                for (LicenseData licenseData : licenseLocalDao.getLicenseDataList()) {
                    if (!licenseData.getHash().equals(hash)) continue;
                    if (!licenseData.isActive()) {
                        this.activateLicenseData(licenseData.getId());
                    }
                    setActive = true;
                    break;
                }
            }
            remoteList = licenseRemoteDao.list();
            if (!setActive) {
                List<LicenseData> rList = remoteList;
                rList.stream().filter(a2 -> a2.getHash().equals(hash)).forEach(a2 -> a2.setActive(true));
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    public List<LicenseData> getLicenseList() throws BGException {
        List<LicenseData> list = null;
        boolean fl = false;
        try (LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());){
            list = licenseLocalDao.getLicenseDataList();
            List<LicenseData> rList = remoteList;
            ArrayList<LicenseData> added = new ArrayList<LicenseData>();
            for (LicenseData licenseData : rList) {
                if (list.stream().anyMatch(a2 -> a2.getId() == licenseData.getId())) continue;
                added.add(licenseData);
            }
            list.addAll(added);
            for (LicenseData licenseData : list) {
                if (!fileLicenseData.getHash().equals(licenseData.getHash())) continue;
                if (!licenseData.isActive()) {
                    this.activateLicenseData(licenseData.getId());
                }
                fl = true;
                break;
            }
        }
        Collections.sort(list, Collections.reverseOrder());
        if (!fl) {
            list.add(0, fileLicenseData);
        }
        return list;
    }

    @Override
    public LicenseData getLicenseData(int licenseId) throws BGException {
        LicenseData licenseData = null;
        try (LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());){
            licenseData = licenseLocalDao.getLicenseData(licenseId);
        }
        if (licenseData == null) {
            licenseData = this.loadLicenseData(licenseId);
        }
        return licenseData;
    }

    @Override
    public LicenseData loadLicenseData(int licenseId) throws BGException, BGMessageException {
        LicenseData licenseData;
        block27: {
            licenseData = null;
            try (LicenseRemoteDao licenseRemoteDao = new LicenseRemoteDao(this.getConnection());){
                String licenseText = licenseRemoteDao.getLicenseText(licenseId);
                if (licenseText != null && licenseText.startsWith("{")) {
                    JSONObject licenseJson = new JSONObject(licenseText);
                    if (!licenseJson.has("license")) break block27;
                    JSONArray licenseItems = licenseJson.getJSONArray("license");
                    licenseData = new LicenseData();
                    licenseData.setId(licenseId);
                    licenseData.setActive(false);
                    licenseData.setCreateDate(new Date(licenseJson.optLong("date")));
                    licenseData.setCount(licenseItems.length());
                    licenseData.setPlainData(licenseItems.toString());
                    try {
                        licenseData.setEncryptData(new String(Base64.getDecoder().decode(licenseJson.getString("encrypt").getBytes("UTF-8")), "UTF-8"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    licenseData.setStorage(Storage.DATABASE);
                    licenseData.setHash(Utils.getDigest(licenseData.getEncryptData(), "UTF-8", "SHA-256"));
                    try (LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());){
                        licenseLocalDao.update(licenseData);
                        break block27;
                    }
                }
                throw new BGMessageException("\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438, \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e:\n\n" + licenseText);
            }
        }
        return licenseData;
    }

    @Override
    public void deleteLicenseData(int licenseId) throws BGException {
        try (LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());){
            licenseLocalDao.deleteLicenseData(licenseId);
        }
    }

    @Override
    public void activateLicenseData(int licenseId) throws BGException {
        LicenseData licenseData = this.getLicenseData(licenseId);
        if (licenseData != null) {
            try (LicenseLocalDao licenseLocalDao = new LicenseLocalDao(this.getConnection());){
                licenseLocalDao.activateLicenseData(licenseId);
                List<LicenseData> rList = remoteList;
                rList.stream().forEach(a2 -> a2.setActive(false));
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(FILE_LICENSE);
                fileOutputStream.write(licenseData.getEncryptData().getBytes("Cp1251"));
                fileOutputStream.flush();
                fileOutputStream.close();
                FileUtils.getFileUtils().reload();
                Temp.getTemp().init();
                licenseData.setActive(true);
                licenseData.setStorage(Storage.FILE);
                fileLicenseData = licenseData;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<LicenseItemData> getCurrentLicense() throws BGException {
        ArrayList<LicenseItemData> list = new ArrayList<LicenseItemData>();
        Temp temp = Temp.getTemp();
        for (String name : temp.getMName()) {
            LicenseItemData licenseItemData = new LicenseItemData();
            licenseItemData.setTitle(name);
            licenseItemData.setCount(temp.getMCurrContract(name) + ":" + temp.getMMaxContract(name));
            licenseItemData.setDate(temp.getMDateAvail(name).format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
            list.add(licenseItemData);
        }
        return list;
    }
}

