/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.news.server.bean;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.news.common.bean.News;
import ru.bitel.bgbilling.kernel.admin.news.common.event.NewsModifiedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;

public final class NewsManager
extends AbstractIdDao<News> {
    private static final Logger logger = Logger.getLogger(NewsManager.class);
    private static Boolean needReload = true;
    private static final Map<Integer, List<News>> newsDocumentMap = new HashMap<Integer, List<News>>();

    public NewsManager(Connection con) {
        super(con, 0, "news");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(int id) throws BGException {
        int result = super.delete(id);
        Boolean bl = needReload;
        synchronized (bl) {
            needReload = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateImpl(News b2) throws BGException, SQLException {
        Document doc;
        if (b2.getBody().trim().startsWith("<data") && (doc = XMLUtils.parseDocument(new InputSource(new StringReader(b2.getBody())))) == null) {
            throw new BGException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 xml \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442!");
        }
        try {
            PreparedStatement ps;
            if (b2.getId() <= 0) {
                ps = this.con.prepareStatement("INSERT INTO news SET dt=?, title=?, txt=?, gr=?", 1);
            } else {
                ps = this.con.prepareStatement("UPDATE news SET dt=?, title=?, txt=?, gr=? WHERE id=?");
                ps.setInt(5, b2.getId());
            }
            ps.setDate(1, TimeUtils.convertDateToSqlDate(b2.getDate()));
            ps.setString(2, b2.getTitle());
            ps.setString(3, b2.getBody());
            ps.setLong(4, b2.getGroups());
            ps.executeUpdate();
            Boolean bl = needReload;
            synchronized (bl) {
                needReload = true;
            }
            if (b2.getId() <= 0) {
                b2.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<News> getNewsList(Setup setup, long groups) {
        if (needReload.booleanValue()) {
            Boolean bl = needReload;
            synchronized (bl) {
                if (needReload.booleanValue()) {
                    NewsManager.newsReload(setup);
                    needReload = false;
                }
            }
        }
        ArrayList<News> newsList = new ArrayList<News>();
        for (int index = 0; index < 64; ++index) {
            List<News> list;
            long group = 1L << index;
            if ((groups & group) <= 0L || (list = newsDocumentMap.get(index)) == null) continue;
            for (News news : list) {
                if (newsList.contains(news)) continue;
                newsList.add(news);
            }
        }
        Collections.sort(newsList);
        Collections.reverse(newsList);
        return newsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void newsReload(Setup setup) {
        Connection con = setup.getDBConnectionFromPool();
        try {
            String query = "SELECT * FROM news WHERE dt <= now()";
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(query);
            Map<Integer, List<News>> map = newsDocumentMap;
            synchronized (map) {
                newsDocumentMap.clear();
                while (rs.next()) {
                    News news = new News();
                    news.setId(rs.getInt("id"));
                    news.setGroups(rs.getLong("gr"));
                    news.setDate(rs.getTimestamp("dt"));
                    news.setTitle(rs.getString("title"));
                    news.setBody(rs.getString("txt"));
                    long groups = news.getGroups();
                    for (int index = 0; index < 64; ++index) {
                        long group = 1L << index;
                        if ((groups & group) <= 0L) continue;
                        List<News> newsList = newsDocumentMap.get(index);
                        if (newsList == null) {
                            newsList = new ArrayList<News>();
                            newsDocumentMap.put(index, newsList);
                        }
                        newsList.add(news);
                    }
                }
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    public List<News> list(Page page) throws BGException {
        return super.list(page, null, "dt DESC", new Object[0]).getList();
    }

    @Override
    protected News getFromRS(ResultSet rs) throws SQLException, BGException {
        News result = new News();
        result.setId(rs.getInt("id"));
        result.setDate(TimeUtils.convertSqlDateToDate(rs.getDate("dt")));
        result.setGroups(rs.getLong("gr"));
        result.setTitle(rs.getString("title"));
        result.setBody(rs.getString("txt"));
        return result;
    }

    static {
        try {
            EventProcessor.getInstance().addListener(new EventListener<NewsModifiedEvent>(){

                @Override
                public void notify(NewsModifiedEvent e, EventListenerContext ctx) throws BGException {
                    needReload = true;
                }
            }, NewsModifiedEvent.class);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
    }
}

