/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMapItem;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.GeographicCode;
import ru.bitel.bgbilling.kernel.base.phone.server.CostMapCache;
import ru.bitel.common.Utils;

public class CostMapTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Logger logger = Logger.getLogger(CostMapTariffTreeNode.class);
    private int costMapId = -1;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> params = this.getDataInHash();
        this.costMapId = Utils.parseInt(params.get("costMapId"), -1);
    }

    @Override
    public void processRequest(TariffRequest request) {
        if ("reset".equals(request.getRequestParam("action"))) {
            this.processForChilds(request);
            return;
        }
        String phone = (String)request.getRequestParam("phone");
        String paramName = "c_m_a_" + this._parent.getId();
        String costMapAccepted = (String)request.getResponseParam(paramName);
        if (Utils.notBlankString(phone) && costMapAccepted == null) {
            try {
                CostMapCache cmc = (CostMapCache)request.getRequestParam("costMapCache");
                CostMapItem root = cmc.getTree(this.costMapId);
                if (root != null) {
                    CostMapItem item = (CostMapItem)root.findCode(phone);
                    if (item != null && item.getCost() != null) {
                        BigDecimal parentCost = (BigDecimal)request.getResponseParam("costMapCost");
                        request.setResponseParam("costMapCost", item.getCost());
                        request.setResponseParam("costMapItemId_", item.getId());
                        GeographicCode code = cmc.getGeographicCode().findCode(phone);
                        if (code != null && code.getDestinationId() > 0) {
                            request.setResponseParam("dest", code.getDestinationId());
                        }
                        this.processForChilds(request);
                        if (parentCost == null) {
                            request.dropResponseParam("costMapCost");
                        } else {
                            request.setResponseParam("costMapCost", parentCost);
                        }
                        request.setResponseParam(paramName, "true");
                    }
                } else {
                    request.addError("CostMap with id=" + this.costMapId + " not found!");
                }
            }
            catch (BGException e) {
                request.addError(e.getMessage());
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

