/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.server;

import bitel.billing.server.tariff.voice.calc.ZoneDestFinder;
import java.math.MathContext;
import java.sql.Connection;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.server.CostMapCache;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.ItemZoneTrafficCache;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeCache;

public class AbstractPhoneTariffContext
extends TariffContext {
    final ItemZoneTrafficCache itemZoneTrafficCache;
    final ZoneDestFinder zoneDestFinder;
    final CostMapCache costMapCache;
    final int moduleId;
    private final Calendar hour;
    private final ConcurrentMap<Long, TariffModuleTreeSet> pointTreeMap = new ConcurrentHashMap<Long, TariffModuleTreeSet>();
    private final ConcurrentMap<Integer, TariffModuleTree> operTariffMap = new ConcurrentHashMap<Integer, TariffModuleTree>();

    public AbstractPhoneTariffContext(Connection con, int moduleId, Calendar hour, ItemZoneTrafficCache itemZoneTrafficCache) throws BGException {
        super(MathContext.DECIMAL64, hour.getTime());
        this.moduleId = moduleId;
        this.hour = hour;
        this.itemZoneTrafficCache = itemZoneTrafficCache;
        this.zoneDestFinder = ZoneDestFinder.getZoneFinder(con, moduleId);
        this.costMapCache = CostMapCache.getInstance(con, moduleId);
    }

    public CostMapCache getCostMapCache() {
        return this.costMapCache;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public TariffModuleTree getOperTariffTree(Connection con, Integer treeId) {
        AtomicReference<TariffModuleTree> newTreeRef;
        TariffModuleTree tree = (TariffModuleTree)this.operTariffMap.get(treeId);
        if (tree == null && (newTreeRef = TariffTreeCache.getInstance().getModuleTree(con, treeId, this.moduleId, "phone")) != null && (tree = this.operTariffMap.putIfAbsent(treeId, newTreeRef.get())) == null) {
            tree = newTreeRef.get();
        }
        return tree;
    }

    public List<TariffModuleTree> getTariffList(Connection con, int cid, int itemId) throws BGException {
        Long key = 0xFFFFFFFF00000000L & (long)cid << 32 | 0xFFFFFFFFL & (long)itemId;
        TariffModuleTreeSet tts = (TariffModuleTreeSet)this.pointTreeMap.get(key);
        if (tts == null) {
            TariffModuleTreeSetDao dao = new TariffModuleTreeSetDao(con);
            TariffModuleTreeSet newTts = dao.getTariffTreeSetForDay(cid, this.hour, "phone", this.moduleId, this.moduleId, itemId);
            dao.freeResources();
            tts = this.pointTreeMap.putIfAbsent(key, newTts);
            if (tts == null) {
                tts = newTts;
            }
        }
        return tts.getTreeList(this.hour);
    }
}

