/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.update.server.LibInfo;
import ru.bitel.bgbilling.kernel.update.server.LibInfoUtil;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

@WebServlet(name="ClientUpdate", urlPatterns={"/clientUpdate/*"})
public class ClientUpdate
extends HttpServlet {
    private Setup setup = null;
    private static final Logger logger = Logger.getLogger(ClientUpdate.class);

    public void init() throws ServletException {
        super.init();
        this.setup = Setup.getSetup();
        LibInfoUtil.getClientLibInfos();
        UserMap.initUserMap(Setup.getSetup());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String unencoded;
        String[] userPass;
        String userName = request.getParameter("userName");
        String userPassword = request.getParameter("userPassword");
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic ") && (userPass = (unencoded = Base64.decode(authorization = authorization.substring(6).trim(), "UTF-8")).split(":")).length > 1) {
            try {
                userName = userPass[0];
                userPassword = userPass[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String appsType = request.getParameter("appsType");
        String[] libNames = request.getParameterValues("libName");
        if (userName != null) {
            if (userPassword != null) {
                userPassword = Utils.getDigest(userPassword, "UTF-8");
            }
            String auth = "Error";
            String message = null;
            for (User user : UserMap.getMap().values()) {
                if (user.getId() <= 0 || !user.getLogin().equalsIgnoreCase(userName)) continue;
                if (user.getPassword().equals(userPassword)) {
                    auth = "Ok";
                    break;
                }
                message = String.format("%s [%s] \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438, \u043d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c", userName, ServletUtils.getIpFromHeader(request, this.setup));
                break;
            }
            if ("Error".equals(auth)) {
                if (message == null) {
                    message = String.format("%s [%s] \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438, \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", userName, ServletUtils.getIpFromHeader(request, this.setup));
                }
                logger.warn(message);
            }
            response.setContentType("text/plain;charset=UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
            writer.write("auth=" + auth + "\n");
            if ("Ok".equals(auth)) {
                writer.write("version=" + Setup.getSetup().get("bg.client.version") + "\n");
                for (LibInfo libInfo : LibInfoUtil.getClientLibInfos().values()) {
                    writer.write("lib=" + libInfo.getName() + "\t" + libInfo.getHash() + "\n");
                }
            }
            try {
                URI uRI = ClassLoader.getSystemResource("runner").toURI();
                File libsDir = new File(uRI);
                if (libsDir.exists() && libsDir.isDirectory()) {
                    for (File file : libsDir.listFiles()) {
                        if (!file.isFile() || !file.getName().startsWith("runner_")) continue;
                        writer.write("runner.version=" + file.getName().substring(7, 17) + "\n");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            writer.flush();
            writer.close();
            return;
        }
        if (Boolean.valueOf(request.getParameter("updateRunner")).booleanValue()) {
            response.setContentType("application/octet-stream");
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                URI runnerDir = ClassLoader.getSystemResource("runner").toURI();
                File libsDir = new File(runnerDir);
                if (!libsDir.exists() || !libsDir.isDirectory()) return;
                for (File file : libsDir.listFiles()) {
                    if (!file.isFile() || !file.getName().startsWith("runner_")) continue;
                    FileInputStream inputStream = new FileInputStream(file);
                    outputStream.write(this.longToBytes(Long.parseLong(file.getName().substring(7, 17))));
                    outputStream.write(this.longToBytes(file.length()));
                    Utils.flush(inputStream, (OutputStream)outputStream);
                    inputStream.close();
                }
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return;
            }
        }
        if ("getAppsLibInfos".equals(request.getParameter("action"))) {
            List<LibInfo> libInfos = LibInfoUtil.getAppsLibInfos().get(appsType);
            if (libInfos != null && libInfos.stream().anyMatch(e -> e.getHash() == null)) {
                try {
                    String libDir = System.getProperty("lib.dir");
                    File dir = libDir == null ? new File(ClientUpdate.class.getResource("/").toURI()) : new File(libDir);
                    for (LibInfo libInfo : libInfos) {
                        File file = new File(dir, "lib" + File.separatorChar + (libInfo.getDir() != null ? libInfo.getDir() : libInfo.getType()) + File.separatorChar + libInfo.getName() + ".jar");
                        libInfo.setFile(file);
                        libInfo.setHash(LibInfoUtil.sha256Hex(file.getPath()));
                    }
                }
                catch (URISyntaxException e1) {
                    libInfos = null;
                }
                if (libInfos != null) {
                    StringBuffer buffer = new StringBuffer();
                    libInfos.forEach(e -> {
                        if (e.getHash() == null) {
                            buffer.append(e.getFile()).append("\n");
                        }
                    });
                    if (buffer.length() > 0) {
                        System.err.println("######################## \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d\u042b \u0424\u0410\u0419\u041b\u042b \u0411\u0418\u0411\u041b\u0418\u041e\u0422\u0415\u041a ########################\n");
                        System.err.println(buffer.toString());
                        System.err.println("############################################################################");
                    }
                }
            }
            response.setContentType("text/plain;charset=UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
            if (libInfos != null) {
                for (LibInfo libInfo : libInfos) {
                    writer.write(libInfo.getType() + "\t" + libInfo.getName() + "\t" + libInfo.getHash() + "\n");
                }
            }
            writer.flush();
            writer.close();
            return;
        }
        if ("getAppsLibs".equals(request.getParameter("action"))) {
            if (libNames == null) return;
            response.setContentType("application/octet-stream");
            ServletOutputStream outputStream = response.getOutputStream();
            HashMap libInfoMap = new HashMap();
            LibInfoUtil.getAppsLibInfos().get(appsType).forEach(e -> libInfoMap.put(e.getType() + "*" + e.getName(), e));
            for (String libName : libNames) {
                LibInfo libInfo;
                if (!libInfoMap.containsKey(libName) || (libInfo = (LibInfo)libInfoMap.get(libName)).getHash() == null) continue;
                byte[] bytes = libInfo.getType().getBytes("UTF-8");
                outputStream.write(bytes.length);
                outputStream.write(bytes);
                bytes = libInfo.getName().getBytes("UTF-8");
                outputStream.write(bytes.length);
                outputStream.write(bytes);
                long length = libInfo.getFile().length();
                outputStream.write(this.longToBytes(length));
                int b2 = 0;
                bytes = new byte[1024];
                FileInputStream fileInputStream = new FileInputStream(libInfo.getFile());
                while ((b2 = fileInputStream.read(bytes)) > -1) {
                    outputStream.write(bytes, 0, b2);
                }
                fileInputStream.close();
            }
            outputStream.flush();
            outputStream.close();
            return;
        } else {
            void var11_37;
            if (libNames == null) return;
            response.setContentType("application/octet-stream");
            ServletOutputStream outputStream = response.getOutputStream();
            String[] stringArray = libNames;
            int n = stringArray.length;
            boolean bl = false;
            while (var11_37 < n) {
                String libName = stringArray[var11_37];
                LibInfo libInfo = LibInfoUtil.getClientLibInfos().get(libName);
                if (libInfo != null) {
                    byte[] bytes = libName.getBytes("UTF-8");
                    outputStream.write(bytes.length);
                    outputStream.write(bytes);
                    String hash = libInfo.getHash();
                    bytes = hash.getBytes("UTF-8");
                    outputStream.write(bytes.length);
                    outputStream.write(bytes);
                    long length = libInfo.getFile().length();
                    outputStream.write(this.longToBytes(length));
                    int b3 = 0;
                    bytes = new byte[1024];
                    FileInputStream fileInputStream = new FileInputStream(libInfo.getFile());
                    while ((b3 = fileInputStream.read(bytes)) > -1) {
                        outputStream.write(bytes, 0, b3);
                    }
                    fileInputStream.close();
                }
                ++var11_37;
            }
            outputStream.flush();
            outputStream.close();
        }
    }

    private byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static void main(String[] args) {
        List<LibInfo> libInfos = LibInfoUtil.getAppsLibInfos().get("inet");
        if (libInfos != null && libInfos.stream().anyMatch(e -> e.getHash() == null)) {
            try {
                File dir = new File(ClientUpdate.class.getResource("/").toURI());
                for (LibInfo libInfo : libInfos) {
                    File file = new File(dir, "lib" + File.separatorChar + libInfo.getType() + File.separatorChar + libInfo.getName());
                    libInfo.setFile(file);
                    libInfo.setHash(LibInfoUtil.sha256Hex(file.getPath()));
                }
            }
            catch (URISyntaxException e1) {
                libInfos = null;
            }
        }
    }
}

