/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RightType;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRule;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class UserRightRuleDao
extends AbstractIdDao<UserRightRule> {
    public UserRightRuleDao(Connection con) {
        super(con, 0, "user_right_rule");
    }

    public List<UserRightRule> getUserRightRules(int rightGroupId) throws BGException {
        return this.list("group_id=?", "title", rightGroupId);
    }

    @Override
    protected UserRightRule getFromRS(ResultSet rs) throws SQLException, BGException {
        UserRightRule userRightRule = new UserRightRule();
        userRightRule.setId(rs.getInt("id"));
        userRightRule.setRightGroupId(rs.getInt("group_id"));
        userRightRule.setTitle(rs.getString("title"));
        userRightRule.setModuleId(rs.getInt("module_id"));
        userRightRule.setRightType(RightType.getRightTypeByCode(rs.getByte("type")));
        userRightRule.setActive(rs.getBoolean("active"));
        userRightRule.setRule(rs.getString("rule"));
        return userRightRule;
    }

    @Override
    public void update(UserRightRule userRightRule) throws BGException {
        super.update(userRightRule);
    }

    @Override
    protected void updateImpl(UserRightRule userRightRule) throws BGException, SQLException {
        Throwable throwable;
        String sql;
        boolean insert;
        boolean bl = insert = userRightRule.getId() < 1;
        if (insert) {
            sql = "SELECT id FROM " + this.tableName + " WHERE group_id=? AND module_id=? AND title=? AND type=? AND rule=?";
            throwable = null;
            try (PreparedStatement psSelect = this.con.prepareStatement(sql);){
                int index = 1;
                psSelect.setInt(index++, userRightRule.getRightGroupId());
                psSelect.setInt(index++, userRightRule.getModuleId());
                psSelect.setString(index++, userRightRule.getTitle());
                psSelect.setByte(index++, userRightRule.getRightType().getCode());
                psSelect.setString(index++, userRightRule.getRule());
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    userRightRule.setId(rs.getInt(1));
                }
                rs.close();
            }
            catch (Throwable index) {
                throwable = index;
                throw index;
            }
            if (userRightRule.getId() > 0) {
                return;
            }
        }
        sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET group_id=?, module_id=?, title=?, type=?, rule=?" + (insert ? "" : " WHERE id=?");
        try {
            throwable = null;
            try (PreparedStatement ps = this.con.prepareStatement(sql, 1);){
                int index = 1;
                ps.setInt(index++, userRightRule.getRightGroupId());
                ps.setInt(index++, userRightRule.getModuleId());
                ps.setString(index++, userRightRule.getTitle());
                ps.setByte(index++, userRightRule.getRightType().getCode());
                ps.setString(index++, userRightRule.getRule());
                if (!insert) {
                    ps.setInt(index++, userRightRule.getId());
                }
                ps.executeUpdate();
                if (insert) {
                    userRightRule.setId(ServerUtils.lastInsertId(this.con));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }
}

