/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.service.server;

import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceInfo;
import ru.bitel.bgbilling.kernel.container.ws.common.Distribution;
import ru.bitel.common.worker.ThreadContext;

public class ServiceFactory {
    private static final Logger logger = Logger.getLogger(ServiceFactory.class);
    private Set<Object> serviceInstanceSet = Collections.newSetFromMap(new ConcurrentHashMap());

    public <T> T create(ServerContext ctx, Class<T> serviceClass, int moduleId) {
        Object t = null;
        try {
            Distribution.Address address;
            if (serviceClass.isInterface() && (address = ctx.getSetup().getDistribution().getAddress(serviceClass.getName())) != null) {
                return ctx.getSetup().getWSClient().getPort(address.url, serviceClass, moduleId);
            }
            ServiceInfo<T> helper = ServiceInfo.getServiceHelper(serviceClass);
            t = helper.newInstance();
            helper.postConstruct(ctx, moduleId, t);
        }
        catch (Exception e) {
            t = null;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (t != null && !(t instanceof Proxy) && !Proxy.isProxyClass(serviceClass)) {
            this.serviceInstanceSet.add(t);
        }
        return (T)t;
    }

    public void recycle(Object r) {
        try {
            if (!(r instanceof Proxy) && !Proxy.isProxyClass(r.getClass())) {
                this.serviceInstanceSet.remove(r);
                ServiceInfo<?> helper = ServiceInfo.getServiceHelper(r.getClass());
                helper.preDestroy(r);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void recycle() {
        Iterator<Object> iter = this.serviceInstanceSet.iterator();
        while (iter.hasNext()) {
            Object r = iter.next();
            iter.remove();
            try {
                if (r instanceof Proxy || Proxy.isProxyClass(r.getClass())) continue;
                ServiceInfo<?> helper = ServiceInfo.getServiceHelper(r.getClass());
                helper.preDestroy(r);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static <T> T newService(Class<T> serviceClass) throws BGException {
        return ServiceFactory.newService(serviceClass, -1);
    }

    public static <T> T newService(Class<T> serviceClass, int moduleId) throws BGException {
        ServerContext ctx = ThreadContext.get(ServerContext.class);
        return ServiceFactory.newService(ctx, serviceClass, moduleId);
    }

    public static <T> T newService(ServerContext ctx, Class<T> serviceClass, int moduleId) throws BGException {
        try {
            Distribution.Address address;
            if (serviceClass.isInterface() && (address = ctx.getSetup().getDistribution().getAddress(serviceClass.getName())) != null) {
                return ctx.getSetup().getWSClient().getPort(address.url, serviceClass, ctx.getModuleId());
            }
            ServiceInfo<T> helper = ServiceInfo.getServiceHelper(serviceClass);
            Object t = helper.newInstance();
            helper.postConstruct(ctx, moduleId, t);
            return (T)t;
        }
        catch (BGException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }
}

