/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.TransactionUtils;
import ru.bitel.bgbilling.kernel.container.web.action.ActionContext;
import ru.bitel.bgbilling.kernel.container.web.action.ActionRequest;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public abstract class AbstractAction {
    @Deprecated
    protected int mid = -1;
    protected int moduleId = -1;
    @Deprecated
    protected int cid = -1;
    protected int contractId = -1;
    protected int userId = -1;
    protected Setup setup = null;
    protected ParameterMap moduleSetup = null;
    protected ActionContext context;
    protected ActionRequest req;
    final Map<String, Object> result = new LinkedHashMap<String, Object>(8);
    protected Map<String, Object> dataMap = new HashMap<String, Object>();
    static final String ACTION_RESULT = "result";
    static final String ACTION_DATA_MAP = "dataMap";
    protected Connection con;

    protected void setResult(Object result) {
        this.result.put(ACTION_RESULT, result);
    }

    protected void setResultParam(String name, Object param) {
        this.result.put(name, param);
    }

    protected void addYearsElement(Result<?> result, ParameterMap moduleSetup) {
        int showYears = moduleSetup.getInt("showyears", 3);
        int currentYear = new GregorianCalendar().get(1);
        ArrayList<IdTitle> yearList = new ArrayList<IdTitle>();
        for (int i = 0; i < showYears; ++i) {
            int yearValue = currentYear - i;
            IdTitle year = new IdTitle();
            year.setId(yearValue);
            year.setTitle(String.valueOf(yearValue));
            yearList.add(year);
        }
        result.setAttribute("year_list", yearList);
    }

    @Deprecated
    protected Period getPeriodByYearsAndDays() {
        GregorianCalendar currentDate = new GregorianCalendar();
        int year = this.req.getInt("year", currentDate.get(1));
        int month = this.req.getInt("month", currentDate.get(2) + 1);
        int dayFrom = this.req.getInt("day_from", 0);
        int dayTo = this.req.getInt("day_to", 0);
        int day = this.req.getInt("day", 0);
        this.setResultParam("year", year);
        this.setResultParam("month", month);
        this.setResultParam("day_from", dayFrom);
        this.setResultParam("day_to", dayTo);
        if (day > 0) {
            dayFrom = day;
            dayTo = day;
        }
        if (dayFrom <= 0) {
            dayFrom = 1;
        }
        if (dayTo <= 0) {
            dayTo = ((Calendar)currentDate).getActualMaximum(5);
        }
        Period p = new Period(year, month - 1, dayFrom, dayTo);
        this.setResultParam("date_from", p.getDateFrom());
        this.setResultParam("date_to", p.getDateTo());
        if (TimeUtils.dateEqual(p.getDateFrom(), p.getDateTo())) {
            this.setResultParam("day", p.getDateFromCalendar().get(5));
        }
        this.setResultParam("period", p);
        this.setResultParam("now", new Date());
        return p;
    }

    protected Period getPeriodByYearMonthDays() {
        Period period = new Period();
        GregorianCalendar calendar = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
        int year = this.req.getInt("year", calendar.get(1));
        calendar.set(1, year);
        int month = this.req.getInt("month", calendar.get(2) + 1);
        if (month < 1 || month > 12) {
            month = calendar.get(2) + 1;
        }
        calendar.set(2, month - 1);
        int dayMax = ((Calendar)calendar).getActualMaximum(5);
        int dayFrom = this.req.getInt("day_from", 1);
        if (dayFrom < 0 || dayFrom > dayMax) {
            dayFrom = 1;
        }
        calendar.set(5, dayFrom);
        period.setDateFrom(calendar.getTime());
        int dayTo = this.req.getInt("day_to", dayMax);
        if (dayTo < dayFrom || dayTo > dayMax) {
            dayTo = dayMax;
        }
        calendar.set(5, dayTo);
        ((Calendar)calendar).add(5, 1);
        ((Calendar)calendar).add(14, -1);
        period.setDateTo(calendar.getTime());
        Element dateElement = XMLUtils.createElement((Element)this.context.getRootNode(), "date");
        dateElement.setAttribute("year", String.valueOf(year));
        dateElement.setAttribute("month", String.valueOf(month));
        dateElement.setAttribute("day_from", String.valueOf(dayFrom));
        dateElement.setAttribute("day_to", String.valueOf(dayTo));
        return period;
    }

    protected Period getPeriodByYearMonthDay() {
        Period period = new Period();
        GregorianCalendar now = new GregorianCalendar();
        Calendar calendar = (Calendar)((Calendar)now).clone();
        int year = this.req.getInt("year", calendar.get(1));
        calendar.set(1, year);
        int month = this.req.getInt("month", calendar.get(2) + 1);
        if (month < 1 || month > 12) {
            month = calendar.get(2) + 1;
        }
        calendar.set(2, month - 1);
        int day = this.req.getInt("day", 0);
        int dayMax = calendar.getActualMaximum(5);
        if (day < 1 || day > dayMax) {
            day = 0;
            calendar.set(5, 1);
            period.setDateFrom(calendar.getTime());
            calendar.set(5, dayMax);
            period.setDateTo(calendar.getTime());
        } else {
            calendar.set(5, day);
            period.setDateFrom(calendar.getTime());
            period.setDateTo(calendar.getTime());
        }
        Element dateElement = XMLUtils.createElement((Element)this.context.getRootNode(), "date");
        dateElement.setAttribute("year", String.valueOf(year));
        dateElement.setAttribute("month", String.valueOf(month));
        dateElement.setAttribute("day", String.valueOf(day));
        return period;
    }

    protected Page getPage() {
        Page page = new Page();
        page.setPageIndex(this.req.getInt("pageIndex", 1));
        page.setPageSize(this.req.getInt("pageSize", 25));
        this.setResultParam("page", page);
        this.dataMap.put("page", page);
        return page;
    }

    protected Period getPeriod() {
        GregorianCalendar nowDate = new GregorianCalendar();
        int mm = this.req.getInt("month", nowDate.get(2) + 1);
        int yy = this.req.getInt("year", nowDate.get(1));
        Period period = new Period(yy, mm - 1, 1, 32);
        this.dataMap.put("period", period);
        return period;
    }

    protected String getStatus(AbstractTransactionStatus statusDefault) {
        String status = this.req.get("status");
        if (status == null) {
            status = statusDefault.getCode();
        }
        this.dataMap.put("status", status);
        try {
            this.dataMap.put("statusList", Arrays.asList((AbstractTransactionStatus[])statusDefault.getClass().getMethod("values", new Class[0]).invoke((Object)statusDefault, new Object[0])));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return status;
    }

    protected void setMinMaxSum(String keyModuleSumMin, int moduleSumMin, String keyModuleSumMax, int moduleSumMax) {
        TransactionUtils.setMinMaxSum(this.moduleSetup, this.dataMap, keyModuleSumMin, moduleSumMin, keyModuleSumMax, moduleSumMax);
    }

    protected void setCustomerAddress(String keyCustomerAddressEnable, String keyCustomerAddressTitle, String keyCustomerAddressRequired) throws BGException {
        boolean customerAddressEnable = this.moduleSetup.getBoolean(keyCustomerAddressEnable, false);
        this.dataMap.put("customerAddressEnable", customerAddressEnable);
        if (customerAddressEnable) {
            this.dataMap.put("customerAddressTitle", this.moduleSetup.get(keyCustomerAddressTitle, "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 E-mail \u0438\u043b\u0438 \u043d\u043e\u043c\u0435\u0440 \u0441\u043e\u0442\u043e\u0432\u043e\u0433\u043e \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u0447\u0435\u043a\u0430"));
            this.dataMap.put("customerAddressRequired", this.moduleSetup.getBoolean(keyCustomerAddressRequired, false));
            try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.mid);){
                this.dataMap.put("customerAddress", contractModuleConfigDao.get(this.cid, "customerAddress"));
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        }
    }

    protected void setCustomerEmail(boolean customerEmailEnable, boolean customerEmailRequired) throws BGException {
        this.dataMap.put("customerEmailEnable", customerEmailEnable);
        if (customerEmailEnable) {
            this.dataMap.put("customerEmailRequired", customerEmailRequired);
            try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.mid);){
                this.dataMap.put("customerEmail", contractModuleConfigDao.get(this.cid, "customerEmail"));
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        }
    }

    protected void setAutopaymentEnabled(Autopayment autopayment, Preferences autopaymentModePreferences, String keyModuleAutopaymentModeDefault, int moduleAutopaymentModeDefault) {
        int autopaymentMode = this.moduleSetup.getInt(keyModuleAutopaymentModeDefault, moduleAutopaymentModeDefault);
        if (autopayment != null) {
            autopaymentMode = autopayment.getMode().getCode();
            autopaymentModePreferences.loadData(autopayment.getModeData(), "\n");
        }
        this.dataMap.put("autopayment.enable", true);
        this.dataMap.put("autopayment.mode", autopaymentMode);
    }

    protected void setAutopaymentModeWeek(Autopayment autopayment, Preferences autopaymentModePreferences, String keyModuleAutopaymentModeWeekEnable, String keyModuleAutopaymentModeWeekDayDefault, String keyModuleAutopaymentModeWeekSumDefault, int moduleAutopaymentModeWeekSumDefault, String keyModuleAutopaymentModeWeekSumMin, int moduleAutopaymentModeWeekSumMin, String keyModuleAutopaymentModeWeekSumMax, int moduleAutopaymentModeWeekSumMa) {
        boolean autopaymentModeWeekEnable = this.moduleSetup.getBoolean(keyModuleAutopaymentModeWeekEnable, false);
        this.dataMap.put("autopayment.mode.week.enable", autopaymentModeWeekEnable);
        if (autopaymentModeWeekEnable) {
            int autopaymentWeekDay = this.moduleSetup.getInt(keyModuleAutopaymentModeWeekDayDefault, 1);
            BigDecimal autopaymentWeekSum = this.moduleSetup.getBigDecimal(keyModuleAutopaymentModeWeekSumDefault, new BigDecimal(moduleAutopaymentModeWeekSumDefault));
            if (autopayment != null) {
                autopaymentWeekDay = autopaymentModePreferences.getInt("autopayment.mode.week.day", autopaymentWeekDay);
                autopaymentWeekSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.week.sum", autopaymentWeekSum);
            }
            this.dataMap.put("autopayment.mode.week.day", autopaymentWeekDay);
            this.dataMap.put("autopayment.mode.week.sum", autopaymentWeekSum);
            this.dataMap.put("autopayment.mode.week.sum.min", this.moduleSetup.getInt(keyModuleAutopaymentModeWeekSumMin, moduleAutopaymentModeWeekSumMin));
            this.dataMap.put("autopayment.mode.week.sum.max", this.moduleSetup.getInt(keyModuleAutopaymentModeWeekSumMax, moduleAutopaymentModeWeekSumMa));
        }
    }

    protected void setAutopaymentModeMonth(Autopayment autopayment, Preferences autopaymentModePreferences, String keyModuleAutopaymentModeMonthEnable, String keyModuleAutopaymentModeMonthDayDefault, String keyModuleAutopaymentModeMonthSumDefault, int moduleAutopaymentModeMonthSumDefault, String keyModuleAutopaymentModeMonthSumMin, int moduleAutopaymentModeMonthSumMin, String keyModuleAutopaymentModeMonthSumMax, int moduleAutopaymentModeMonthSumMax) {
        boolean autopaymentModeMonthEnable = this.moduleSetup.getBoolean(keyModuleAutopaymentModeMonthEnable, false);
        this.dataMap.put("autopayment.mode.month.enable", autopaymentModeMonthEnable);
        if (autopaymentModeMonthEnable) {
            int autopaymentMonthDay = this.moduleSetup.getInt(keyModuleAutopaymentModeMonthDayDefault, 1);
            BigDecimal autopaymentMonthSum = this.moduleSetup.getBigDecimal(keyModuleAutopaymentModeMonthSumDefault, new BigDecimal(moduleAutopaymentModeMonthSumDefault));
            if (autopayment != null) {
                autopaymentMonthDay = autopaymentModePreferences.getInt("autopayment.mode.month.day", autopaymentMonthDay);
                autopaymentMonthSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.month.sum", autopaymentMonthSum);
            }
            this.dataMap.put("autopayment.mode.month.day", autopaymentMonthDay);
            this.dataMap.put("autopayment.mode.month.sum", autopaymentMonthSum);
            this.dataMap.put("autopayment.mode.month.sum.min", this.moduleSetup.getInt(keyModuleAutopaymentModeMonthSumMin, moduleAutopaymentModeMonthSumMin));
            this.dataMap.put("autopayment.mode.month.sum.max", this.moduleSetup.getInt(keyModuleAutopaymentModeMonthSumMax, moduleAutopaymentModeMonthSumMax));
        }
    }

    protected void setAutopaymentModeAuto(Autopayment autopayment, Preferences autopaymentModePreferences, String keyModuleAutopaymentModeAutoEnable, String keyModuleAutopaymentModeAutoDaySumDefault, int moduleAutopaymentModeAutoDaySumDefault, String keyModuleAutopaymentModeAutoWeekSumDefault, int moduleAutopaymentModeAutoWeekSumDefault, String keyModuleAutopaymentModeAutoMonthSumDefault, int moduleAutopaymentModeAutoMonthSumDefault, String keyModuleAutopaymentModeAutoDaySumMax, int moduleAutopaymentModeAutoDaySumMax, String keyModuleAutopaymentModeAutoWeekSumMax, int moduleAutopaymentModeAutoWeekSumMax, String keyModuleAutopaymentModeAutoMonthSumMax, int moduleAutopaymentModeAutoMonthSumMax) {
        boolean autopaymentModeAutoEnable = this.moduleSetup.getBoolean(keyModuleAutopaymentModeAutoEnable, false);
        this.dataMap.put("autopayment.mode.auto.enable", autopaymentModeAutoEnable);
        if (autopaymentModeAutoEnable) {
            BigDecimal autopaymentAutoDaySum = this.moduleSetup.getBigDecimal(keyModuleAutopaymentModeAutoDaySumDefault, new BigDecimal(moduleAutopaymentModeAutoDaySumDefault));
            BigDecimal autopaymentAutoWeekSum = this.moduleSetup.getBigDecimal(keyModuleAutopaymentModeAutoWeekSumDefault, new BigDecimal(moduleAutopaymentModeAutoWeekSumDefault));
            BigDecimal autopaymentAutoMonthSum = this.moduleSetup.getBigDecimal(keyModuleAutopaymentModeAutoMonthSumDefault, new BigDecimal(moduleAutopaymentModeAutoMonthSumDefault));
            if (autopayment != null) {
                autopaymentAutoDaySum = autopaymentModePreferences.getBigDecimal("autopayment.mode.auto.day.sum", autopaymentAutoDaySum);
                autopaymentAutoWeekSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.auto.week.sum", autopaymentAutoWeekSum);
                autopaymentAutoMonthSum = autopaymentModePreferences.getBigDecimal("autopayment.mode.auto.month.sum", autopaymentAutoMonthSum);
            }
            this.dataMap.put("autopayment.mode.auto.day.sum", autopaymentAutoDaySum);
            this.dataMap.put("autopayment.mode.auto.day.sum.max", this.moduleSetup.getInt(keyModuleAutopaymentModeAutoDaySumMax, moduleAutopaymentModeAutoDaySumMax));
            this.dataMap.put("autopayment.mode.auto.week.sum", autopaymentAutoWeekSum);
            this.dataMap.put("autopayment.mode.auto.week.sum.max", this.moduleSetup.getInt(keyModuleAutopaymentModeAutoWeekSumMax, moduleAutopaymentModeAutoWeekSumMax));
            this.dataMap.put("autopayment.mode.auto.month.sum", autopaymentAutoMonthSum);
            this.dataMap.put("autopayment.mode.auto.month.sum.max", this.moduleSetup.getInt(keyModuleAutopaymentModeAutoMonthSumMax, moduleAutopaymentModeAutoMonthSumMax));
        }
    }

    protected void setHeaderPage() {
        Page page = (Page)this.dataMap.get("page");
        this.context.getResponse().setHeader("pageInfo", page != null ? page.toString() : "{}");
    }
}

