/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;

public class ContractDao
extends AbstractEntityAttrDao<Contract> {
    private static final Logger logger = Logger.getLogger(ContractDao.class);

    public ContractDao(Connection con, int userId) {
        super(con, 0, userId, "contract", CONTRACT_SUPPORT);
    }

    @Override
    public Directory<? extends Id> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractParameterGroup.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    @Override
    protected Directory<? extends EntitySpecAttr> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractParameterGroupAttr.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    @Override
    protected Contract getFromRS(ResultSet rs, boolean loadAttributes, boolean loadEntityTitle) throws SQLException {
        Contract contract = new Contract();
        contract.setId(rs.getInt("id"));
        contract.setTitle(rs.getString("title"));
        contract.setPassword(rs.getString("pswd"));
        contract.setComment(rs.getString("comment"));
        contract.setBalanceMode(rs.getByte("mode"));
        contract.setBalanceLimit(rs.getBigDecimal("closesumma"));
        contract.setGroups(rs.getLong("gr"));
        contract.setPersonType(rs.getByte("fc"));
        contract.setParamGroupId(rs.getInt("pgid"));
        contract.setDateFrom(rs.getDate("date1"));
        contract.setDateTo(rs.getDate("date2"));
        contract.setHidden(rs.getBoolean("del"));
        contract.setSuperCid(rs.getInt("scid"));
        contract.setDependSubList(rs.getString("sub_list"));
        contract.setBalanceSubMode(rs.getByte("sub_mode"));
        contract.setStatus(rs.getByte("status"));
        contract.setTitlePatternId(rs.getInt("title_pattern_id"));
        contract.setStatusTimeChange(rs.getDate("status_date"));
        contract.setDomainId(rs.getInt("domainId"));
        return contract;
    }

    public boolean updateContractParameter(int contractId, EntityAttr entityAttr) throws BGException {
        try {
            return super.updateEntityAttribute(contractId, entityAttr);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Deprecated
    public void updateContractParameters(int contractId, Map<Integer, EntityAttr> entityAttributes) throws BGException {
        try {
            super.updateEntityAttributes(contractId, entityAttributes);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public Map<Integer, EntityAttr> getContractParameters(int contractId, int paramGroupId) throws BGException {
        Map<Object, Object> result = paramGroupId > 0 ? super.getEntityAttributes(paramGroupId, contractId, false) : super.getAllEntityAttributes(contractId, false);
        return result != null ? result : new HashMap(4);
    }

    public Map<Integer, String> getContractParameterValuesForParameterIds(int contractId, Set<Integer> parameterIds) throws BGException {
        return super.getEntityValueForIds(contractId, parameterIds);
    }

    public EntityAttr getContractParameter(int contractId, int parameterId) throws BGException {
        return super.getEntityAttribute(contractId, parameterId);
    }

    @Override
    public void update(Contract contract) throws BGException {
        super.update(contract);
    }

    @Override
    protected void updateImpl(Contract contract) throws BGException, SQLException {
        StringBuilder query = new StringBuilder(50);
        query.append("UPDATE ").append(this.tableName).append(" SET gr=?, title=?, title_pattern_id=?, pswd=?, date1=?, date2=?,");
        query.append(" mode=?, closesumma=?, pgid=?, fc=?, comment=?, del=?,");
        query.append(" scid=?, sub_list=?, sub_mode=?, status=?, status_date=?, domainId=? WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            ps.setLong(index++, contract.getGroups());
            ps.setString(index++, contract.getTitle() != null ? contract.getTitle().trim() : null);
            ps.setInt(index++, contract.getTitlePatternId());
            ps.setString(index++, contract.getPassword());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(contract.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(contract.getDateTo()));
            ps.setInt(index++, contract.getBalanceMode());
            ps.setBigDecimal(index++, contract.getBalanceLimit());
            ps.setInt(index++, contract.getParamGroupId());
            ps.setInt(index++, contract.getPersonType());
            ps.setString(index++, contract.getComment());
            ps.setBoolean(index++, contract.isHidden());
            ps.setInt(index++, contract.getSuperCid());
            ps.setString(index++, contract.getDependSubList());
            ps.setInt(index++, contract.getBalanceSubMode());
            ps.setInt(index++, contract.getStatus());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(contract.getStatusTimeChange()));
            ps.setInt(index++, contract.getDomainId());
            ps.setInt(index++, contract.getId());
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Deprecated
    public void updateParameter(int contractId, EntityAttr a2) throws BGException {
        try {
            super.updateEntityAttribute(contractId, a2);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Deprecated
    public List<Contract> list(String title, String comment, int fc, long groupMaskAnd, int firm, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, Page page) throws BGException {
        ContractFilters contractFilters = new ContractFilters();
        contractFilters.setTitle(title);
        contractFilters.setComment(comment);
        contractFilters.setFc(fc);
        contractFilters.setGroupMask(groupMaskAnd);
        contractFilters.setSubContracts(subContracts);
        contractFilters.setClosed(closed);
        contractFilters.setHidden(hidden);
        return this.list(contractFilters, entityFilter, "title", page);
    }

    public List<Contract> list(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Page page) throws BGException {
        return this.list(contractFilters, entityFilter, "title", page);
    }

    @Deprecated
    public List<Contract> list(String title, String comment, int fc, long groupMaskAnd, int firm, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, String orderBy, Page page) throws BGException {
        ContractFilters contractFilters = new ContractFilters();
        contractFilters.setTitle(title);
        contractFilters.setComment(comment);
        contractFilters.setFc(fc);
        contractFilters.setGroupMask(groupMaskAnd);
        contractFilters.setSubContracts(subContracts);
        contractFilters.setClosed(closed);
        contractFilters.setHidden(hidden);
        return this.list(contractFilters, entityFilter, orderBy, page);
    }

    public List<Contract> list(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, String orderBy, Page page) throws BGException {
        Date sqlNow = TimeUtils.convertDateToSqlDate(new java.util.Date());
        StringBuilder where = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        if (!PermissionChecker.isAdmin(this.userId) && this.userId != 0) {
            ContractDao.addContractGroupFilter(where, this.userId);
            PermissionChecker.PermissionEntry pc = PermissionChecker.getUserPermition(this.userId);
            if (pc != null && pc.pairEntry != null) {
                sb.append("LEFT JOIN contract_parameter_type_8 as par ON par.cid=contract.id ");
                where.append(" AND par.pid=" + pc.pairEntry.pid + " AND par.val=" + pc.pairEntry.cid);
            }
        }
        boolean titleRegexp = this.isRegexp(contractFilters.getTitle());
        boolean commentRegexp = this.isRegexp(contractFilters.getComment());
        Object[] objectArray = new Object[14];
        objectArray[0] = contractFilters.getGroupMask();
        objectArray[1] = contractFilters.getGroupMask();
        objectArray[2] = contractFilters.getGroupMask();
        objectArray[3] = contractFilters.isSubContracts();
        objectArray[4] = contractFilters.getFc() != 0 && contractFilters.getFc() != 1;
        objectArray[5] = contractFilters.getFc();
        objectArray[6] = !contractFilters.isClosed();
        objectArray[7] = sqlNow;
        objectArray[8] = contractFilters.isHidden();
        objectArray[9] = contractFilters.getTitle();
        objectArray[10] = contractFilters.getTitle() != null ? (titleRegexp ? contractFilters.getTitle().toUpperCase() : "%" + contractFilters.getTitle() + "%") : null;
        objectArray[11] = contractFilters.getComment();
        objectArray[12] = contractFilters.getComment() != null ? (commentRegexp ? contractFilters.getComment().toUpperCase() : "%" + contractFilters.getComment() + "%") : null;
        objectArray[13] = contractFilters.getGroupMask() != 0L || contractFilters.getTitle() != null || contractFilters.getComment() != null || contractFilters.getFc() != -1 || entityFilter != null && entityFilter.size() > 0;
        return super.list(false, page, null, sb.toString(), entityFilter, " (?=0 OR contract.gr&?=?)" + where.toString() + " AND (? OR contract.scid IN (" + 0 + ", " + -1 + ")) AND (? OR contract.fc=?) AND (? OR contract.date2 IS NULL OR ?<=contract.date2) AND (? OR contract.del=0) AND (? IS NULL OR " + (titleRegexp ? "UPPER(contract.title) REGEXP" : "contract.title LIKE") + " ?) AND (? IS NULL OR " + (commentRegexp ? "UPPER(contract.comment) REGEXP" : "contract.comment LIKE") + " ?) AND (? OR contract.gr=0)", null, orderBy, objectArray);
    }

    private boolean isRegexp(String regex) {
        boolean result = false;
        try {
            Pattern.compile(regex);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public List<Contract> getContracts(String idList) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        if (Utils.isBlankString(idList)) {
            return result;
        }
        if ((idList = Utils.toString(Utils.toIntegerList(idList))).length() == 0) {
            return result;
        }
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM contract WHERE id IN ( " + idList + " )");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add((Contract)this.getFromRS(rs));
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<Contract> getSubContracts(int contractId, int subMode) throws BGException {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM contract WHERE scid=? AND (? OR sub_mode=?) ORDER BY title");){
            ps.setInt(1, contractId);
            ps.setBoolean(2, subMode == -1);
            ps.setInt(3, subMode);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add((Contract)this.getFromRS(rs));
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return result;
    }

    public Contract getByTitle(String title) throws BGException {
        return (Contract)this.get("`title`=?", title);
    }

    public void updatePassword(int contractId, String password) throws BGException {
        try {
            String query = "UPDATE contract SET pswd=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, password);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage());
        }
    }

    public static void addContractGroupFilter(StringBuilder where, int userId) {
        if (userId == 0) {
            return;
        }
        PermissionChecker.PermissionEntry userPermition = PermissionChecker.getUserPermition(userId);
        String domainIds = userPermition.getDomainIdsString();
        if (domainIds != null) {
            where.append(" AND contract.domainId IN (").append(domainIds).append(") ");
        }
        String contractGroupWhere = "";
        if (userPermition.contractGroups != 0L) {
            contractGroupWhere = "gr&" + userPermition.contractGroups + (userPermition.contractGroupsMode > 0 ? "=" + userPermition.contractGroups : ">0");
        }
        for (PermissionChecker.PermissionEntry entry : PermissionChecker.getGroupsPermissions(userId)) {
            if (entry.contractGroups == 0L) continue;
            contractGroupWhere = contractGroupWhere + (contractGroupWhere.isEmpty() ? "" : " OR ") + "gr&" + entry.contractGroups + (entry.contractGroupsMode > 0 ? "=" + entry.contractGroups : ">0");
        }
        if (!contractGroupWhere.isEmpty()) {
            where.append(" AND ( " + contractGroupWhere + " )");
        }
    }

    public void updateDomain(int contractId, int domainId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET domainId=? WHERE id=?");
            ps.setInt(1, domainId);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage());
        }
    }

    public List<Contract> getContractForTextlikeParamValue(int pid, String value) {
        if (Utils.isBlankString(value)) {
            return null;
        }
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            String query = "SELECT contract.* FROM contract  LEFT JOIN " + ContractParameterManager.CONTRACT_PARAMETER_TYPE_STRING + " as param_string  ON param_string.cid = contract.id AND param_string.pid = " + pid + " LEFT JOIN contract_parameter_type_phone_item as param_phone_item ON param_phone_item.cid = contract.id AND param_phone_item.pid = " + pid + " LEFT JOIN contract_parameter_type_3 as param_email ON param_email.cid = contract.id AND param_email.pid = " + pid + " WHERE param_string.val=? OR param_phone_item.phone=? OR param_email.email LIKE ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, value.trim());
            ps.setString(2, value.trim().replace(" ", "").replace("+", ""));
            ps.setString(3, "%<" + value.trim().replace(" ", "").replace(";", "") + ">%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add((Contract)this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String contractListByFilter(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Page page) throws BGException {
        return "{}";
    }

    public void checkContractParameter(EntityAttr entityAttr) throws BGException {
        super.checkEntityAttribute(entityAttr);
    }

    static {
        try {
            new AbstractEntityAttrDao.AddressItemModifiedEventListener(){

                @Override
                protected AbstractEntityAttrDao<?> newDao(ServerContext context) {
                    return new ContractDao(context.getConnection(), context.getUserId());
                }
            };
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
    }
}

