/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractPatternNamedNumberDao
extends AbstractIdDao<ContractPatternNamedNumber> {
    public ContractPatternNamedNumberDao(Connection con) {
        super(con, 0, "contract_pattern_named_numbers");
    }

    public List<ContractPatternNamedNumber> list() throws BGException {
        return this.list(null, null, new Object[0]);
    }

    public ContractPatternNamedNumber getFromTitle(String title) throws BGException {
        if (Utils.isBlankString(title)) {
            throw new BGIllegalArgumentException();
        }
        return (ContractPatternNamedNumber)this.get("title=?", title);
    }

    public int getNextNamedNumberIndex(String title) throws BGException {
        if (Utils.isBlankString(title)) {
            throw new BGIllegalArgumentException();
        }
        int result = -1;
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET ln=(@lastNumber:=ln)+1 WHERE title=?");
             PreparedStatement ps2 = this.con.prepareStatement("SELECT @lastNumber");){
            ResultSet rs;
            ps.setString(1, title);
            if (ps.executeUpdate() > 0 && (rs = ps2.executeQuery()).next()) {
                result = rs.getInt(1) + 1;
            }
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return result;
    }

    @Override
    protected void updateImpl(ContractPatternNamedNumber namedNumber) throws BGException, SQLException {
        PreparedStatement ps;
        if (namedNumber.getId() <= 0) {
            String query = "INSERT INTO " + this.tableName + " ( title, ln, count_number, comment ) VALUES (?, " + namedNumber.getIndex() + ", " + namedNumber.getCountNumber() + ", ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            String query = "UPDATE " + this.tableName + " SET title=?, comment=? WHERE id=" + namedNumber.getId();
            ps = this.con.prepareStatement(query);
        }
        ps.setString(1, namedNumber.getTitle());
        ps.setString(2, namedNumber.getComment());
        try {
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGMessageException("\u0414\u0443\u0431\u043b\u0438\u043a\u0430\u0442 \u0438\u043c\u0435\u043d\u0438 \"" + namedNumber.getTitle() + "\"! \u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0435 \u0438\u043c\u044f.");
        }
        if (namedNumber.getId() <= 0) {
            namedNumber.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    protected ContractPatternNamedNumber getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractPatternNamedNumber namedNumber = new ContractPatternNamedNumber();
        namedNumber.setId(rs.getInt("id"));
        namedNumber.setTitle(rs.getString("title"));
        namedNumber.setIndex(rs.getInt("ln"));
        namedNumber.setCountNumber(rs.getInt("count_number"));
        namedNumber.setComment(rs.getString("comment"));
        return namedNumber;
    }
}

