/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.PasswordManager;
import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractPasswordChangedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPasswordLogDao;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.bgbilling.kernel.contract.search.server.ContractHistoryRecordDao;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractParamBeforeChangeEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ValidateTextParamEvent;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService")
public class ContractServiceImpl
extends AbstractService
implements ContractService {
    ContractDao contractDao;
    protected static final Logger logger = Logger.getLogger(ContractServiceImpl.class);

    private ContractDao getDao() {
        if (this.contractDao == null) {
            this.contractDao = new ContractDao(this.getConnection(), this.userId);
        }
        return this.contractDao;
    }

    @PreDestroy
    private void destroy() {
        try {
            if (this.contractDao != null) {
                this.contractDao.close();
                this.contractDao = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Contract contractGet(int contractId) throws BGException {
        return (Contract)this.getDao().get(contractId);
    }

    @Override
    public void contractGroupRemove(int contractId, int contractGroupId) throws BGException {
        if (contractId < 0 || contractGroupId < 0) {
            return;
        }
        try {
            Directory<ContractGroup> contractGroupDir = this.context.getDirectory(ContractGroup.class, 0);
            ContractGroup contractGroup = contractGroupDir.get(contractGroupId);
            if (contractGroup == null) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            if (!contractGroup.isEditable()) {
                throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430).");
            }
            ContractManager contractManager = new ContractManager(this.getConnection());
            contractManager.deleteContractGroup(contractId, contractGroupId);
            contractManager.close();
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    public void contractGroupAdd(int contractId, int contractGroupId) throws BGException {
        if (contractId < 0 || contractGroupId < 0) {
            return;
        }
        try {
            Directory<ContractGroup> contractGroupDir = this.context.getDirectory(ContractGroup.class, 0);
            ContractGroup contractGroup = contractGroupDir.get(contractGroupId);
            if (contractGroup == null) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            if (!contractGroup.isEditable()) {
                throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430).");
            }
            ContractManager contractManager = new ContractManager(this.getConnection());
            contractManager.addContractGroup(contractId, contractGroupId);
            contractManager.close();
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    public List<Contract> contractSubList(int contractId, int subMode, boolean withSuperCid) throws BGException {
        Contract contract = null;
        if (subMode == 0 || withSuperCid) {
            contract = (Contract)this.getDao().get(contractId);
        }
        List<Contract> list = subMode == 0 ? this.getDao().getContracts(contract.getDependSubList()) : this.getDao().getSubContracts(contractId, subMode);
        if (withSuperCid) {
            list.add(0, contract);
        }
        return list;
    }

    @Override
    public List<Contract> contractList(String title, String comment, int fc, long groupMask, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, Holder<Page> pageHolder) throws BGException {
        Page page;
        if (pageHolder == null || (page = (Page)pageHolder.value) == null) {
            page = new Page(1, 25);
        }
        ContractFilters contractFilters = new ContractFilters();
        contractFilters.setTitle(title);
        contractFilters.setComment(comment);
        contractFilters.setFc(fc);
        contractFilters.setGroupMask(groupMask);
        contractFilters.setSubContracts(subContracts);
        contractFilters.setClosed(closed);
        contractFilters.setHidden(hidden);
        List<Contract> list = this.getDao().list(contractFilters, entityFilter, page);
        if (pageHolder != null) {
            pageHolder.value = page;
        }
        return list;
    }

    @Override
    public void contractPasswordUpdate(int contractId, String password, boolean generate) throws BGException {
        if (contractId < 0) {
            throw new BGIllegalArgumentException();
        }
        if (generate) {
            password = PswdGen.generatePassword(this.getSetup());
        } else {
            int passwordMin = PswdGen.getPasswordLengthMin(this.getSetup());
            int passwordMax = PswdGen.getPasswordLengthMax(this.getSetup());
            String passwordChars = PswdGen.getPasswordChars(this.getSetup());
            if (Utils.isEmptyString(password)) {
                throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
            }
            if ((password = password.trim()).length() < passwordMin || password.length() > passwordMax) {
                throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
            }
            if (!PswdGen.checkPasswordChars(password, passwordChars)) {
                throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + passwordChars);
            }
        }
        this.getDao().updatePassword(contractId, password);
        this.context.publishAfterCommit(new ContractPasswordChangedEvent(this.userId, contractId, password));
        ContractPasswordLogItem item = new ContractPasswordLogItem();
        item.setDatetime(new Date());
        item.setContractId(contractId);
        item.setUserId(this.userId);
        try (ContractPasswordLogDao dao = new ContractPasswordLogDao(this.getConnection());){
            dao.addContractPasswordLogItem(item);
        }
    }

    @Override
    public boolean hasModuleInstance(int contractId, int moduleId) throws BGException {
        Set<Integer> contractModuleSet = new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId);
        return contractModuleSet.contains(moduleId);
    }

    @Override
    public void contractPasswordReset(int contractId, String email) throws BGException {
        Integer authMode;
        Setup setup = Setup.getSetup();
        Connection con = this.getConnection();
        Contract contract = this.contractGet(contractId);
        if (contract == null) {
            throw new BGException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "passwordReset.contract.notFound");
        }
        ContractParameterManager contractParameterManager = new ContractParameterManager(con);
        int paramId = setup.getInt("contract.password.forgot.email.param.id", -1);
        String contractEmail = contractParameterManager.getEmailFromParam(contractId, paramId);
        if (contractEmail == null) {
            contractParameterManager.close();
            throw new BGException("Email \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d", "passwordReset.email.notFound");
        }
        if (email != null && !this.checkEmail(email, contractEmail)) {
            contractParameterManager.close();
            throw new BGException("Email \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", "passwordReset.email.notValid");
        }
        PasswordManager passwordManager = new PasswordManager(con);
        long passwordExpireHour = setup.getLong("contract.password.forgot.expire.hour", 24L);
        String emailLink = setup.get("contract.password.forgot.link", "http://localhost:8080/bgbilling/webexecuter?action=ChangePassword&mid=contract&passwordOnce=${password}");
        String emailSubject = setup.get("contract.password.forgot.email.subject", "\u0412\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f");
        String emailText = setup.get("contract.password.forgot.email.body", "\u0414\u043b\u044f \u0432\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {contract} - \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0438\u0436\u0435 (\u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 {hour} \u0447\u0430\u0441\u043e\u0432) \u0438 \u0441\u043c\u0435\u043d\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c.");
        String charArray = setup.get("contract.password.forgot.char.array", "1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm");
        String password = passwordManager.getOncePassword(charArray);
        HashMap<Integer, Integer> authModes = new HashMap<Integer, Integer>();
        String modes = setup.get("web.auth.modes", null);
        if (modes != null) {
            String[] parts = modes.split(";");
            for (int i = 0; i < parts.length; ++i) {
                String[] mid_mode = parts[i].split(":");
                if (mid_mode.length != 2) continue;
                authModes.put(Utils.parseInt(mid_mode[0].trim(), 0), Utils.parseInt(mid_mode[1].trim(), 0));
            }
        }
        if ((authMode = (Integer)authModes.get(0)) != null && authMode > 0 && authMode < 3) {
            if (authMode == 1) {
                passwordManager.deleteByContract(contract.getTitle());
                passwordManager.addPassword(contract.getTitle(), passwordExpireHour, password);
            } else if (authMode == 2) {
                paramId = setup.getInt("web.auth.contract.text.parameter", 0);
                if (paramId > 0) {
                    String value = contractParameterManager.getTextlikeParam(contract.getId(), paramId);
                    passwordManager.deleteByContract(value);
                    passwordManager.addPassword(value, passwordExpireHour, password);
                } else {
                    logger.error((Object)"Not set parameter 'web.auth.contract.text.parameter' in config!");
                }
            }
            emailText = emailText.replaceAll("\\{contract\\}", contract.getTitle());
            emailText = emailText.replaceAll("\\{hour\\}", String.valueOf(passwordExpireHour));
            emailLink = emailLink.contains("${password}") ? emailLink.replaceAll("\\$\\{password\\}", password) : emailLink + "&passwordOnce=" + password;
            new MailMsg(setup).sendMessage(contractEmail, emailSubject, emailText + "\n" + emailLink);
            contractParameterManager.close();
            return;
        }
        contractParameterManager.close();
        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", "passwordReset.webAuthModes.notValid");
    }

    private boolean checkEmail(String email, String emailList) {
        boolean result;
        block1: {
            String token;
            result = false;
            if (email == null || emailList == null) break block1;
            StringTokenizer st = new StringTokenizer(emailList, "\n");
            email = email.toLowerCase();
            while (st.hasMoreTokens() && !(result = (token = st.nextToken().toLowerCase()).equals(email) || token.indexOf("<" + email + ">") > -1)) {
            }
        }
        return result;
    }

    @Override
    public int contractPasswordOnceCheck(String passwordOnce) throws BGException {
        PasswordManager passwordManager = new PasswordManager(this.getConnection());
        String contractTitle = passwordManager.findContractTitle(passwordOnce);
        passwordManager.deleteContractTitle(passwordOnce);
        Contract contract = this.getDao().getByTitle(contractTitle);
        if (contract != null) {
            return contract.getId();
        }
        return 0;
    }

    @Override
    public MapHolder<Integer, EntityAttr> contractParameterMap(int contractId, int paramGroupId) throws BGException {
        Map<Integer, EntityAttr> result = this.getDao().getContractParameters(contractId, paramGroupId);
        if (this.userId != 0 && this.userId != 1 && result != null && result.size() > 0) {
            PermissionChecker.PermissionEntry userPermission = PermissionChecker.getUserPermition(this.userId);
            Iterator<Integer> iter = result.keySet().iterator();
            while (iter.hasNext()) {
                if (PermissionChecker.checkReadContractParameter(userPermission, (int)iter.next())) continue;
                iter.remove();
            }
        }
        return new MapHolder<Integer, EntityAttr>(result);
    }

    @Override
    @Deprecated
    public ContractParameterGroup contractParameterGroupGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).get(id);
    }

    @Override
    @Deprecated
    public List<ContractParameterGroup> contractParameterGroupList() throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).list();
    }

    @Override
    public SearchResult<ContractHistoryRecord> searchContractHistoryRecord(Page page) throws BGException {
        SearchResult<ContractHistoryRecord> searchResult = new SearchResult<ContractHistoryRecord>(null, page);
        ContractHistoryRecordDao contractHistoryRecordDao = new ContractHistoryRecordDao(this.getConnection());
        contractHistoryRecordDao.searchContractHistoryRecord(searchResult, this.userId);
        contractHistoryRecordDao.close();
        return searchResult;
    }

    @Override
    public void updateContractHistoryRecord(int contractId) throws BGException {
        ContractHistoryRecord contractHistoryRecord = new ContractHistoryRecord();
        contractHistoryRecord.setContractId(contractId);
        contractHistoryRecord.setUserId(this.userId);
        contractHistoryRecord.setLastOpen(new Date());
        ContractHistoryRecordDao contractHistoryRecordDao = new ContractHistoryRecordDao(this.getConnection());
        contractHistoryRecordDao.update(contractHistoryRecord);
        contractHistoryRecordDao.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String contractModuleConfigGet(int contractId, int moduleId, String key) throws BGException {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), moduleId);){
            String string = contractModuleConfigDao.get(contractId, key);
            return string;
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public void contractModuleConfigSet(int contractId, int moduleId, String key, String value) throws BGException {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), moduleId);){
            if (Utils.isBlankString(value)) {
                contractModuleConfigDao.delete(contractId, key);
            } else {
                contractModuleConfigDao.update(contractId, key, value);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public void contractDomainUpdate(int contractId, int domainId) throws BGException {
        this.getDao().updateDomain(contractId, domainId);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    @Override
    public void contractParameterUpdate(int contractId, EntityAttr entityAttr) throws BGException {
        ContractParameterListItem item;
        EntityAttrList a2;
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (entityAttr == null) {
            throw new BGIllegalArgumentException("entityAttr");
        }
        if (entityAttr.getEntityId() != 0 && contractId != entityAttr.getEntityId()) {
            throw new BGIllegalArgumentException("entityAttr.entityId");
        }
        entityAttr.setEntityId(contractId);
        this.getDao().checkContractParameter(entityAttr);
        if (entityAttr instanceof EntityAttrList && (a2 = (EntityAttrList)entityAttr).getValue() > 0 && (item = this.context.getDirectory(ContractParameterListItem.class, a2.getEntitySpecAttrId()).get(a2.getValue())) != null && item.getId() == a2.getValue()) {
            a2.setTitle(item.getTitle());
        }
        if (entityAttr instanceof EntityAttrText) {
            ValidateTextParamEvent event = new ValidateTextParamEvent(contractId, ((EntityAttrText)entityAttr).getValue());
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString(event.getError())) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438: " + event.getError());
            }
        }
        ContractParamBeforeChangeEvent checkEvent = new ContractParamBeforeChangeEvent(this.userId, contractId, entityAttr.getEntitySpecAttrId(), entityAttr);
        checkEvent = EventProcessor.getInstance().request(checkEvent);
        if (Utils.notBlankString(checkEvent.getError())) {
            throw new BGMessageException(checkEvent.getError());
        }
        this.getDao().updateContractParameter(contractId, entityAttr);
        try {
            new CommentPatternManager(this.getConnection()).updateContractComment(contractId);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        this.context.publishAfterCommit(new ContractParamChangedEvent(this.userId, contractId, entityAttr.getEntitySpecAttrId(), entityAttr));
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    @Override
    public EntityAttr contractParameterGet(int contractId, int parameterId) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        PermissionChecker.PermissionEntry userPermission;
        if (this.userId != 0 && this.userId != 1 && !PermissionChecker.checkReadContractParameter(userPermission = PermissionChecker.getUserPermition(this.userId), parameterId)) {
            throw new BGIllegalAccessException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0440\u043e\u0441\u043c\u0430\u0442\u0440\u0438\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
        }
        return this.getDao().getContractParameter(contractId, parameterId);
    }

    @Override
    public void contractUpdate(int contractId, Contract contract) throws BGException {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (contract == null) {
            throw new BGIllegalArgumentException("contract");
        }
        if (contract.getId() <= 0) {
            contract.setId(contractId);
        } else if (contract.getId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        this.getDao().update(contract);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contract.getId()));
    }

    @Override
    public MapHolder<Integer, EntityAttr> contractParameterMapByType(int contractId, int parameterType) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
        MapHolder<Integer, EntityAttr> map = new MapHolder<Integer, EntityAttr>();
        List parametersIds = this.context.getService(ContractParameterService.class, this.moduleId).contractParameterGroupAttrList().stream().filter(a2 -> a2.getType() == parameterType).map(a2 -> a2.getId()).collect(Collectors.toList());
        PermissionChecker.PermissionEntry userPermission = null;
        if (this.userId != 0 && this.userId != 1) {
            userPermission = PermissionChecker.getUserPermition(this.userId);
        }
        Iterator iterator = parametersIds.iterator();
        while (iterator.hasNext()) {
            int parameterId = (Integer)iterator.next();
            if (userPermission != null && !PermissionChecker.checkReadContractParameter(userPermission, parameterId)) continue;
            map.getMap().put(parameterId, this.getDao().getContractParameter(contractId, parameterId));
        }
        return map;
    }

    @Override
    public String contractListByFilter(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Holder<Page> pageHolder) throws BGException {
        Page page;
        if (pageHolder == null || (page = (Page)pageHolder.value) == null) {
            page = new Page(1, 25);
        }
        String list = this.getDao().contractListByFilter(contractFilters, entityFilter, page);
        if (pageHolder != null) {
            pageHolder.value = page;
        }
        return list;
    }
}

