/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.server.bean;

import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.LimitChangeTask;
import bitel.billing.server.util.Config;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvto;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvtoStatus;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitLog;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.ContractLimitLogManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.LimitChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public final class LimitManager {
    private Connection con;
    private static final String TABLE_CONTRACT_LIMIT_PERIOD = "contract_limit_period";
    private static final String TABLE_CONTRACT_LIMIT_MANAGE = "contract_limit_manage";
    private static final String TABLE_CONTRACT_LIMIT_MANAGE_MODE = "contract_limit_manage_mode";
    private static final String TABLE_CONTRACT_LIMIT_MANAGE_MODE_LOG = "log_contract_limit_manage_mode";
    public static final int VPAY_NOT_PAYOFFED = 0;
    public static final int VPAY_PARTIAL_PAYOFFED = 1;
    public static final int VPAY_PAYOFFED = 2;
    public static final int VPAY_EXPIRED = 3;
    private static final int MODE_ENABLED = 0;
    private static final int MODE_DISABLED = 1;
    private static final int MODE_DISABLED_FOR_EXPIRED = 2;
    public static final Object limitMutex = new Object();
    private PreparedStatement psSelectPeriodLimits;
    private PreparedStatement psUpdatePeriodLimit;
    private PreparedStatement psDeletePeriodLimit;
    private PreparedStatement psUpdateLimit;
    private PreparedStatement psGetUserLimitMove;
    private PreparedStatement psUpdateUserLimitMoveStatus;
    private PreparedStatement psUpdateUserLimitManageMode;
    private PreparedStatement psInsertManageMode;

    public LimitManager(Connection con) {
        this.con = con;
    }

    public void searchContractLimitAvto(SearchResult<ContractLimitAvto> searchResult, int contractId, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
            }
            List<ContractLimitAvto> list = searchResult.getList();
            String whereQuery = " WHERE cid=?" + (status != null && !ContractLimitAvtoStatus.ALL.getCode().equals(status) ? " AND status='" + status + "'" : "");
            try {
                PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(*) FROM contract_limit_period" + whereQuery);
                ps.setInt(1, contractId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                }
                rs.close();
                ps.close();
                ps = null;
                if (page.getPageIndex() > page.getPageCount()) {
                    page.setPageIndex(page.getPageCount());
                }
                ps = this.con.prepareStatement("SELECT * FROM contract_limit_period" + whereQuery + " ORDER BY dt" + page.sqlLimit());
                ps.setInt(1, contractId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    ContractLimitAvto contractLimitAvto = new ContractLimitAvto();
                    contractLimitAvto.setId(rs.getInt("id"));
                    contractLimitAvto.setUserId(rs.getInt("uid"));
                    contractLimitAvto.setDate(rs.getDate("dt"));
                    contractLimitAvto.setValue(rs.getBigDecimal("value"));
                    contractLimitAvto.setStatus(rs.getString("status"));
                    list.add(contractLimitAvto);
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
    }

    public List<LimitChangeTask> getContractMoveTasks(int contractId) {
        ArrayList<LimitChangeTask> result = new ArrayList<LimitChangeTask>();
        try {
            String query = "SELECT per.*, low.id as low_id FROM contract_limit_period as per LEFT JOIN contract_limit_manage as low ON per.id=low.clp_id WHERE per.cid=? AND per.status=? ORDER BY dt";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setString(2, ContractLimitAvtoStatus.ON.getCode());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getMoveFromRSContract(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int addMoveTask(LimitChangeTask task) throws BGException {
        int id = -1;
        try {
            String query = "INSERT INTO contract_limit_period SET cid=?, dt=?, uid=?, value=?";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setInt(1, task.getContractId());
            ps.setDate(2, TimeUtils.convertDateToSqlDate(task.getDate()));
            ps.setInt(3, task.getUserId());
            ps.setBigDecimal(4, task.getDeltaSum());
            ps.executeUpdate();
            id = ServerUtils.lastInsertId(ps);
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage());
        }
        return id;
    }

    public void cancelMoveTask(List<Integer> taskIds) throws BGException {
        try {
            PreparedStatement psSelect = this.con.prepareStatement("SELECT id FROM contract_limit_manage WHERE clp_id=?");
            PreparedStatement psUpdate = this.con.prepareStatement("UPDATE contract_limit_period SET status=? WHERE id=?");
            for (int taskId : taskIds) {
                psSelect.setInt(1, taskId);
                boolean fl = psSelect.executeQuery().next();
                if (fl) {
                    throw new BGMessageException("\u0414\u0430\u043d\u043d\u043e\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043e \u0434\u043b\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0435\u0433\u043e \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c. \u0415\u0433\u043e \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c.");
                }
                psUpdate.setString(1, ContractLimitAvtoStatus.CANCEL.getCode());
                psUpdate.setInt(2, taskId);
                psUpdate.executeUpdate();
            }
            psSelect.close();
            psUpdate.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void deleteMoveTaskAndLog(int taskId, int contractId, int userId) {
        try {
            this.cancelMoveTask(Arrays.asList(taskId));
            String query = "DELETE FROM contract_limit_manage WHERE clp_id = ? AND cid = ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, taskId);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            try (ContractLimitLogManager contractLimitLogManager = new ContractLimitLogManager(this.con);){
                contractLimitLogManager.deleteContractLimitLog(contractId, -1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<LimitChangeTask> getFullTaskList() {
        ArrayList<LimitChangeTask> result = new ArrayList<LimitChangeTask>();
        try {
            String query = "SELECT * FROM contract_limit_period GROUP BY cid";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getMoveFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private LimitChangeTask getMoveFromRS(ResultSet rs) throws SQLException {
        LimitChangeTask limitMove = new LimitChangeTask();
        limitMove.setId(rs.getInt("id"));
        limitMove.setContractId(rs.getInt("cid"));
        limitMove.setDate(rs.getDate("dt"));
        limitMove.setUserId(rs.getInt("uid"));
        limitMove.setDeltaSum(rs.getBigDecimal("value"));
        limitMove.setStatus(ContractLimitAvtoStatus.ALL.getStatusByCode(rs.getString("status")));
        return limitMove;
    }

    private LimitChangeTask getMoveFromRSContract(ResultSet rs) throws SQLException {
        LimitChangeTask limitMove = this.getMoveFromRS(rs);
        limitMove.setCreateByContract(rs.getInt("low_id") != 0);
        return limitMove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContractLimit(int userId, BigDecimal limitValue, int contractId, String comment, int days) {
        Object object = limitMutex;
        synchronized (object) {
            try {
                ContractLimitLog contractLimitLog = new ContractLimitLog();
                contractLimitLog.setUserId(userId);
                contractLimitLog.setLimitValue(limitValue);
                contractLimitLog.setContractId(contractId);
                contractLimitLog.setComment(comment);
                contractLimitLog.setDays(days);
                try (ContractLimitLogManager contractLimitLogManager = new ContractLimitLogManager(this.con);){
                    contractLimitLogManager.addContractLimitLog(contractLimitLog);
                }
                String query = "UPDATE contract SET closesumma=? WHERE id=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setBigDecimal(1, limitValue);
                ps.setInt(2, contractId);
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean initRestoreLimitTask(Calendar date) {
        boolean result = false;
        try {
            String query = "SELECT id, cid, value FROM contract_limit_period WHERE dt<=? AND status=? ORDER BY id";
            this.psSelectPeriodLimits = this.con.prepareStatement(query);
            this.psSelectPeriodLimits.setDate(1, TimeUtils.convertCalendarToSqlDate(date));
            this.psSelectPeriodLimits.setString(2, ContractLimitAvtoStatus.ON.getCode());
            query = "UPDATE contract_limit_period SET status=? WHERE id=?";
            this.psUpdatePeriodLimit = this.con.prepareStatement(query);
            this.psUpdatePeriodLimit.setString(1, ContractLimitAvtoStatus.OFF.getCode());
            query = "DELETE FROM contract_limit_period WHERE dt< NOW() - INTERVAL 1 YEAR";
            this.psDeletePeriodLimit = this.con.prepareStatement(query);
            query = "UPDATE contract SET closesumma=closesumma-? WHERE id=?";
            this.psUpdateLimit = this.con.prepareStatement(query);
            query = "SELECT * FROM contract_limit_manage WHERE clp_id=? AND cid=? ";
            this.psGetUserLimitMove = this.con.prepareStatement(query);
            this.psUpdateUserLimitMoveStatus = this.con.prepareStatement("UPDATE contract_limit_manage SET status=?, clp_id = NULL WHERE id=? ");
            this.psUpdateUserLimitManageMode = this.con.prepareStatement("UPDATE contract_limit_manage_mode SET cnt=cnt+1 WHERE cid=?");
            this.psInsertManageMode = this.con.prepareStatement("INSERT INTO contract_limit_manage_mode SET cid=?, mode=?, cnt=?");
            result = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRestoreLimitTask(Calendar now, ContractDao contractDao, String comment) {
        Object object = limitMutex;
        synchronized (object) {
            try (ContractLimitLogManager contractLimitLogManager = new ContractLimitLogManager(this.con);
                 BalanceUtils balanceUtils = new BalanceUtils(this.con);
                 ResultSet rs = this.psSelectPeriodLimits.executeQuery();){
                while (rs.next()) {
                    BigDecimal contractBalance;
                    int id = rs.getInt(1);
                    int contractId = rs.getInt(2);
                    BigDecimal value = Utils.maskNull(rs.getBigDecimal(3));
                    this.psUpdatePeriodLimit.setInt(2, id);
                    this.psUpdatePeriodLimit.executeUpdate();
                    if (value.equals(BigDecimal.ZERO)) continue;
                    this.psUpdateLimit.setBigDecimal(1, value);
                    this.psUpdateLimit.setInt(2, contractId);
                    this.psUpdateLimit.executeUpdate();
                    ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract = (ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract)contractDao.get(contractId);
                    if (contract == null || (contractBalance = balanceUtils.getBalance(new Date(), contract)).compareTo(contract.getBalanceLimit()) >= 0) continue;
                    this.psGetUserLimitMove.setInt(1, id);
                    this.psGetUserLimitMove.setInt(2, contractId);
                    ResultSet rs2 = this.psGetUserLimitMove.executeQuery();
                    if (rs2.next() && rs2.getInt("status") != 3) {
                        this.psUpdateUserLimitMoveStatus.setInt(1, 3);
                        this.psUpdateUserLimitMoveStatus.setInt(2, rs2.getInt("id"));
                        this.psUpdateUserLimitMoveStatus.executeUpdate();
                        this.psUpdateUserLimitManageMode.setInt(1, contractId);
                        if (this.psUpdateUserLimitManageMode.executeUpdate() <= 0) {
                            this.psInsertManageMode.setInt(1, contractId);
                            this.psInsertManageMode.setInt(2, 0);
                            this.psInsertManageMode.setInt(3, 1);
                            this.psInsertManageMode.executeUpdate();
                        }
                    }
                    rs2.close();
                    EventProcessor.getInstance().publish(new SystemLimitChangedEvent(contractId, contract.getBalanceLimit()));
                    EventProcessor.getInstance().publish(new LimitChangedEvent(contractId, contract.getBalanceLimit()));
                    ContractLimitLog contractLimitLog = new ContractLimitLog();
                    contractLimitLog.setUserId(0);
                    contractLimitLog.setLimitValue(contract.getBalanceLimit());
                    contractLimitLog.setContractId(contractId);
                    contractLimitLog.setComment(comment);
                    contractLimitLogManager.addContractLimitLog(contractLimitLog);
                }
                rs.close();
                this.psDeletePeriodLimit.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreLimit(Connection con, int id, int contractId, BigDecimal limitValue) {
        Object object = limitMutex;
        synchronized (object) {
            block18: {
                try {
                    if (limitValue.compareTo(BigDecimal.ZERO) == 0) break block18;
                    String query = "DELETE FROM contract_limit_period WHERE id=?";
                    PreparedStatement psDeletePeriodLimit = con.prepareStatement(query);
                    psDeletePeriodLimit.setInt(1, id);
                    psDeletePeriodLimit.executeUpdate();
                    psDeletePeriodLimit.close();
                    query = "UPDATE contract_limit_manage SET clp_id = NULL  WHERE clp_id=?";
                    PreparedStatement updateLimitManage = con.prepareStatement(query);
                    updateLimitManage.setInt(1, id);
                    updateLimitManage.executeUpdate();
                    updateLimitManage.close();
                    query = "UPDATE contract SET closesumma=closesumma-? WHERE id=?";
                    PreparedStatement psUpdateLimit = con.prepareStatement(query);
                    psUpdateLimit.setBigDecimal(1, limitValue);
                    psUpdateLimit.setInt(2, contractId);
                    psUpdateLimit.executeUpdate();
                    psUpdateLimit.close();
                    try (ContractDao contractDao = new ContractDao(con, 0);){
                        ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract = (ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract)contractDao.get(contractId);
                        if (contract != null) {
                            ContractLimitLog contractLimitLog = new ContractLimitLog();
                            contractLimitLog.setLimitValue(contract.getBalanceLimit());
                            contractLimitLog.setUserId(0);
                            contractLimitLog.setContractId(contractId);
                            contractLimitLog.setComment("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430 \u043d\u0430 " + limitValue.toPlainString());
                            ContractLimitLogManager contractLimitLogManager = new ContractLimitLogManager(con);
                            contractLimitLogManager.addContractLimitLog(contractLimitLog);
                            contractLimitLogManager.close();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clientPaymentEvent(Connection con, PaymentEvent event) throws BGException {
        Object object = limitMutex;
        synchronized (object) {
            try {
                PreparedStatement ps = con.prepareStatement("SELECT * FROM contract_limit_manage WHERE cid=? AND status<?");
                ps.setInt(1, event.getContractId());
                ps.setInt(2, 2);
                ResultSet rs = ps.executeQuery();
                PaymentDao paymentDao = new PaymentDao(con);
                BigDecimal rest = event.getPayment().getSum();
                int i = 0;
                while (rs.next()) {
                    PreparedStatement psUpdate;
                    ++i;
                    int status = rs.getInt("status");
                    int id = rs.getInt("id");
                    BigDecimal limitSumm = rs.getBigDecimal("summ");
                    int cid = event.getContractId();
                    List<Integer> pids = Utils.toIntegerList(rs.getString("pids"));
                    BigDecimal sum = rest.add(rs.getBigDecimal("rest"));
                    for (Integer pid : pids) {
                        Payment p = (Payment)paymentDao.get(pid);
                        if (p == null) continue;
                        sum = sum.add(p.getSum());
                    }
                    if (i == 1) {
                        psUpdate = con.prepareStatement("UPDATE contract_limit_manage SET pids=? WHERE id=?");
                        pids.add(event.getPayment().getId());
                        psUpdate.setString(1, Utils.toString(pids));
                        psUpdate.setInt(2, id);
                        psUpdate.executeUpdate();
                        psUpdate.close();
                    } else {
                        psUpdate = con.prepareStatement("UPDATE contract_limit_manage SET rest=? WHERE id=?");
                        psUpdate.setBigDecimal(1, rest);
                        psUpdate.setInt(2, id);
                        psUpdate.executeUpdate();
                        psUpdate.close();
                    }
                    if (sum.compareTo(limitSumm) >= 0) {
                        psUpdate = con.prepareStatement("UPDATE contract_limit_manage SET status=?, date2=? WHERE id=?");
                        psUpdate.setInt(1, 2);
                        psUpdate.setDate(2, TimeUtils.convertDateToSqlDate(event.getPayment().getDate()));
                        psUpdate.setInt(3, id);
                        psUpdate.executeUpdate();
                        psUpdate.close();
                        int limitPeriodId = rs.getInt("clp_id");
                        LimitManager.restoreLimit(con, limitPeriodId, cid, limitSumm.negate());
                        rest = sum.subtract(limitSumm);
                        continue;
                    }
                    if (sum.compareTo(BigDecimal.ZERO) <= 0 && status != 0) {
                        psUpdate = con.prepareStatement("UPDATE contract_limit_manage SET status=? WHERE id=?");
                        psUpdate.setInt(1, 0);
                        psUpdate.setInt(2, id);
                        psUpdate.executeUpdate();
                        psUpdate.close();
                        break;
                    }
                    if (status == 1) break;
                    psUpdate = con.prepareStatement("UPDATE contract_limit_manage SET status=? WHERE id=?");
                    psUpdate.setInt(1, 1);
                    psUpdate.setInt(2, id);
                    psUpdate.executeUpdate();
                    psUpdate.close();
                    break;
                }
                rs.close();
                ps.close();
                paymentDao.close();
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    public static final List<ContractLimitParameters> load(Setup setup) {
        ArrayList<ContractLimitParameters> result = new ArrayList<ContractLimitParameters>();
        String _groups = setup.get("contract.limit.1.groups", null);
        int i = 1;
        String prefix = "contract.limit.1";
        while (_groups != null) {
            List<Integer> grs = Utils.toIntegerList(_groups);
            long groups = 0L;
            for (Integer g : grs) {
                groups |= 1L << g;
            }
            int maxNotPayoffed = setup.getInt(prefix + ".maxnotpayoffed", 0);
            int maxPartialPayoffed = setup.getInt(prefix + ".maxpartialpayoffed", 0);
            int maxExpiredForBlock = setup.getInt(prefix + ".maxexpiredforblock", 0);
            int minDays = setup.getInt(prefix + ".mindays", 1);
            int maxDays = setup.getInt(prefix + ".maxdays", 10);
            BigDecimal minSumm = setup.getBigDecimal(prefix + ".minsumm", new BigDecimal(10));
            BigDecimal maxSumm = setup.getBigDecimal(prefix + ".maxsumm", new BigDecimal(100));
            BigDecimal minLimit = setup.getBigDecimal(prefix + ".minlimit", new BigDecimal(-100));
            result.add(new ContractLimitParameters(groups, maxNotPayoffed, maxPartialPayoffed, maxExpiredForBlock, minDays, maxDays, minSumm, maxSumm, minLimit));
            prefix = "contract.limit." + ++i;
            _groups = setup.get(prefix + ".groups", null);
        }
        return result;
    }

    @Deprecated
    public ContractLimitParameters getContractLimitParameters(Setup setup, Contract contract) throws BGException {
        return this.getContractLimitParameters(setup, contract.getNewContract());
    }

    public ContractLimitParameters getContractLimitParameters(Setup setup, ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract) throws BGException {
        List<ContractLimitParameters> contractLimitParameters = setup.getConfig((int)0, Conf.class).contractLimitParameters;
        if (contractLimitParameters == null) {
            contractLimitParameters = LimitManager.load(setup);
        }
        try {
            long groups = contract.getGroups();
            for (ContractLimitParameters l : contractLimitParameters) {
                if ((l.getGroups() & groups) <= 0L) continue;
                PreparedStatement ps = this.con.prepareStatement("SELECT mode, cnt FROM contract_limit_manage_mode WHERE cid=?");
                ps.setInt(1, contract.getId());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    switch (rs.getInt(1)) {
                        case 1: {
                            throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
                        }
                        case 2: {
                            throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"));
                        }
                    }
                    if (l.getMaxExpiredForBlock() > 0 && l.getMaxExpiredForBlock() <= rs.getInt(2)) {
                        this.setLimitManageMode(0, contract.getId(), 2);
                        throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"));
                    }
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT COUNT(id) FROM contract_limit_manage WHERE cid=? AND status=?");
                ps.setInt(1, contract.getId());
                ps.setInt(2, 0);
                rs = ps.executeQuery();
                int notPayoffed = rs.next() ? rs.getInt(1) : 0;
                rs.close();
                ps.setInt(2, 1);
                rs = ps.executeQuery();
                int partialPayoffed = rs.next() ? rs.getInt(1) : 0;
                rs.close();
                ps.close();
                if (l.getMaxNotPayoffed() < notPayoffed || l.getMaxPartialPayoffed() < partialPayoffed) {
                    throw new BGMessageException(setup.get("limit.max.current.msg", "\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043e\u043d\u0438\u0437\u0438\u0442\u044c \u043b\u0438\u043c\u0438\u0442. \u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u0438/\u0438\u043b\u0438 \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439"));
                }
                return l;
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lowLimit(int cid, BigDecimal sum, int days) throws BGException {
        Object object = limitMutex;
        synchronized (object) {
            GregorianCalendar now = new GregorianCalendar();
            Calendar limitDate = (Calendar)((Calendar)now).clone();
            limitDate.add(5, days);
            try {
                BigDecimal newLimit = null;
                try (ContractManager contractManager = new ContractManager(this.con);){
                    newLimit = contractManager.getContractById(cid).getBalanceLimit().subtract(sum);
                }
                this.updateContractLimit(-1, newLimit, cid, "", days);
                LimitChangeTask task = new LimitChangeTask();
                task.setContractId(cid);
                task.setUserId(-1);
                task.setDate(limitDate.getTime());
                task.setDeltaSum(sum.negate());
                int taskId = this.addMoveTask(task);
                String query = "INSERT INTO contract_limit_manage (cid, clp_id, summ, date1, date2, status) VALUES (?,?,?,?,?,?)";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setInt(2, taskId);
                ps.setBigDecimal(3, sum);
                ps.setTimestamp(4, TimeUtils.convertCalendarToTimestamp(now));
                ps.setTimestamp(5, TimeUtils.convertCalendarToTimestamp(limitDate));
                ps.setInt(6, 0);
                ps.executeUpdate();
                ps.close();
                if (!this.con.getAutoCommit()) {
                    this.con.commit();
                }
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    public List<UserLimitMove> getUserLimitMove(int cid, int yy, int mm) {
        GregorianCalendar date1 = new GregorianCalendar(yy, mm - 1, 1);
        Calendar date2 = (Calendar)((Calendar)date1).clone();
        date2.add(2, 1);
        date2.add(5, -1);
        return this.getUserLimitMove(cid, date1, date2);
    }

    public List<UserLimitMove> getUserLimitMove(int cid, Calendar date1, Calendar date2) {
        ArrayList<UserLimitMove> result = new ArrayList<UserLimitMove>();
        try {
            PreparedStatement ps;
            if (date1 == null && date2 == null) {
                ps = this.con.prepareStatement("SELECT * FROM contract_limit_manage WHERE cid=?");
                ps.setInt(1, cid);
            } else if (date1 != null && date2 != null) {
                ps = this.con.prepareStatement("SELECT * FROM contract_limit_manage WHERE cid=? AND ((TO_DAYS(date1)>=TO_DAYS(?) AND TO_DAYS(date1)<=TO_DAYS(?)) OR (TO_DAYS(date2)>=TO_DAYS(?) AND TO_DAYS(date2)<=TO_DAYS(?)))");
                ps.setInt(1, cid);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate(date1));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate(date2));
                ps.setDate(4, TimeUtils.convertCalendarToSqlDate(date1));
                ps.setDate(5, TimeUtils.convertCalendarToSqlDate(date2));
            } else if (date1 != null) {
                ps = this.con.prepareStatement("SELECT * FROM contract_limit_manage WHERE cid=? AND ((TO_DAYS(date1)>=TO_DAYS(?)) OR (TO_DAYS(date2)>=TO_DAYS(?)))");
                ps.setInt(1, cid);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate(date1));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate(date1));
            } else {
                ps = this.con.prepareStatement("SELECT * FROM contract_limit_manage WHERE cid=? AND ((TO_DAYS(date1)<=TO_DAYS(?)) OR (TO_DAYS(date2)<=TO_DAYS(?)))");
                ps.setInt(1, cid);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate(date2));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate(date2));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                UserLimitMove m = new UserLimitMove();
                m.date1 = TimeUtils.convertDateToCalendar(rs.getDate("date1"));
                m.date2 = TimeUtils.convertDateToCalendar(rs.getDate("date2"));
                m.summ = rs.getFloat("summ");
                m.status = rs.getInt("status");
                m.id = rs.getInt("id");
                result.add(m);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setLimitManageMode(int uid, int cid, int mode) {
        try {
            String query = "UPDATE contract_limit_manage_mode SET mode=?, cnt=? WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mode);
            ps.setInt(2, 0);
            ps.setInt(3, cid);
            int row = ps.executeUpdate();
            ps.close();
            if (row <= 0) {
                query = "INSERT INTO contract_limit_manage_mode SET cid=?, mode=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setInt(2, mode);
                ps.executeUpdate();
                ps.close();
            }
            query = "INSERT INTO log_contract_limit_manage_mode VALUES ( now(), ?, ?, ? )";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ps.setInt(2, mode);
            ps.setInt(3, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public class UserLimitMove {
        private int id;
        private float summ;
        private Calendar date1;
        private Calendar date2;
        private int status;

        public Calendar getDate1() {
            return this.date1;
        }

        public void setDate1(Calendar date1) {
            this.date1 = date1;
        }

        public Calendar getDate2() {
            return this.date2;
        }

        public void setDate2(Calendar date2) {
            this.date2 = date2;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public float getSumm() {
            return this.summ;
        }

        public void setSumm(float summ) {
            this.summ = summ;
        }
    }

    private static class Conf
    extends Config {
        final List<ContractLimitParameters> contractLimitParameters;

        public Conf(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            this.contractLimitParameters = LimitManager.load(serverSetup);
        }
    }
}

