/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.script.server;

import bitel.billing.server.contract.bean.ContractScriptManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.script.common.ContractScriptService;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.AdditionalContractAction;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.AdditionalContractActionResult;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScriptLog;
import ru.bitel.bgbilling.kernel.contract.script.server.bean.ContractScriptLogDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.AdditionalActionEvent;
import ru.bitel.bgbilling.kernel.event.events.GetAdditionalActionListEvent;
import ru.bitel.bgbilling.kernel.event.events.GetAdditionalWebActionListEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.script.common.ContractScriptService")
public class ContractScriptServiceImpl
extends AbstractService
implements ContractScriptService {
    /*
     * Loose catch block
     */
    @Override
    public List<String> getScriptLogTitleList(int contractId, Period period) throws BGException, BGMessageException {
        if (period == null || period.getDateFrom() == null) {
            throw new BGIllegalArgumentException();
        }
        String tableName = ServerUtils.getMonthTableName("log_function_process", period.getDateFrom());
        Connection con = this.getSetup().getDBTrashOrSlaveConnectionFromPool(tableName);
        try {
            try (ContractScriptLogDao dao = new ContractScriptLogDao(con, tableName);){
                List<String> list = dao.getScriptLogTitleList(contractId, period);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public List<ContractScriptLog> getScriptLogList(int contractId, Period period, String title, Holder<Page> pageHolder) throws BGException, BGMessageException {
        if (period == null || period.getDateFrom() == null) {
            throw new BGIllegalArgumentException();
        }
        String tableName = ServerUtils.getMonthTableName("log_function_process", period.getDateFrom());
        Connection con = this.getSetup().getDBTrashOrSlaveConnectionFromPool(tableName);
        try {
            try (ContractScriptLogDao dao = new ContractScriptLogDao(con, tableName);){
                List<ContractScriptLog> list = dao.getScriptLogList(contractId, period, title, pageHolder != null ? (Page)pageHolder.value : null);
                return list;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    @Override
    public void deleteScript(int id) {
        new ContractScriptManager(this.getConnection()).deleteContractScript(id);
    }

    @Override
    @Deprecated
    public List<AdditionalContractAction> additionalContractActionList(int contractId, boolean customer) throws BGException, BGMessageException {
        return this.additionalContractActionList(contractId, customer, null);
    }

    @Override
    public List<AdditionalContractAction> additionalContractActionList(int contractId, boolean customer, MapHolder<String, String> params) throws BGException, BGMessageException {
        if (customer) {
            GetAdditionalWebActionListEvent event = new GetAdditionalWebActionListEvent(contractId, null);
            event.setParams(new ParameterMap.DefaultParameterMap(params != null && params.getMap() != null ? params.getMap() : Collections.emptyMap()));
            EventProcessor.getInstance().request(event);
            return new ArrayList<AdditionalContractAction>(event.getActionList());
        }
        GetAdditionalActionListEvent event = new GetAdditionalActionListEvent(this.userId, contractId);
        event = EventProcessor.getInstance().request(event);
        return new ArrayList<AdditionalContractAction>(event.getActionList());
    }

    @Override
    public AdditionalContractActionResult additionalContractActionInvoke(int contractId, int actionId, boolean customer, MapHolder<String, String> params) throws BGException, BGMessageException {
        if (contractId <= 0 || actionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (customer) {
            GetAdditionalWebActionListEvent event = new GetAdditionalWebActionListEvent(contractId, null);
            event.setParams(new ParameterMap.DefaultParameterMap(params != null && params.getMap() != null ? params.getMap() : Collections.emptyMap()));
            event = EventProcessor.getInstance().request(event);
            if (!event.actionAllowed(actionId)) {
                throw new BGMessageException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e!", "additionalContractAction.notAllowed");
            }
            AdditionalActionEvent eventAction = new AdditionalActionEvent(contractId, actionId, this.userId);
            eventAction.setParams(new ParameterMap.DefaultParameterMap(params != null && params.getMap() != null ? params.getMap() : Collections.emptyMap()));
            eventAction = EventProcessor.getInstance().request(eventAction);
            AdditionalContractActionResult result = new AdditionalContractActionResult();
            result.setReport(eventAction.getReport());
            return result;
        }
        GetAdditionalActionListEvent event = new GetAdditionalActionListEvent(this.userId, contractId);
        event = EventProcessor.getInstance().request(event);
        if (!event.actionAllowed(actionId)) {
            throw new BGMessageException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e!", "additionalContractAction.notAllowed");
        }
        AdditionalActionEvent eventAction = new AdditionalActionEvent(contractId, actionId, this.userId);
        eventAction = EventProcessor.getInstance().request(eventAction);
        AdditionalContractActionResult result = new AdditionalContractActionResult();
        result.setReport(eventAction.getReport());
        return result;
    }
}

