/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.address;

import bitel.billing.server.admin.bean.AddressCountry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.address.AddressArea;
import ru.bitel.bgbilling.kernel.directory.address.AddressCity;
import ru.bitel.bgbilling.kernel.directory.address.AddressHouse;
import ru.bitel.bgbilling.kernel.directory.address.AddressQuarter;
import ru.bitel.bgbilling.kernel.directory.address.AddressStreet;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class AddressDirectoryManager {
    private final String TABLE_ADDRESS_COUNTRY = "address_country";
    private final String TABLE_ADDRESS_CITY = "address_city";
    private final String TABLE_ADDRESS_AREA = "address_area";
    private final String TABLE_ADDRESS_QUARTER = "address_quarter";
    private final String TABLE_ADDRESS_STREET = "address_street";
    private final String TABLE_ADDRESS_HOUSE = "address_house";
    protected Connection con;

    public AddressDirectoryManager(Connection con) {
        this.con = con;
    }

    public AddressCountry getAddressCountry(int id) throws SQLException {
        AddressCountry addressCountry = null;
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM ");
        query.append("address_country");
        query.append(" WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                addressCountry = new AddressCountry();
                addressCountry.setId(id);
                addressCountry.setTitle(rs.getString("title"));
            }
            rs.close();
        }
        return addressCountry;
    }

    public AddressCity getAddressCity(int id) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        AddressCity addressCity = null;
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("*");
        query.append(" FROM ");
        query.append("address_city");
        query.append(" WHERE ");
        query.append("id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressCity = new AddressCity();
            addressCity.setId(id);
            addressCity.setPositionIndex(rs.getInt("pos"));
            addressCity.setCountryId(rs.getInt("country_id"));
            addressCity.setTitle(rs.getString("title"));
        }
        rs.close();
        ps.close();
        return addressCity;
    }

    public void updateCity(AddressCity addressCity) throws BGException {
        if (addressCity != null) {
            try {
                StringBuffer query;
                int index;
                boolean insertFlag = true;
                PreparedStatement ps = null;
                if (addressCity.getId() > 0) {
                    index = 1;
                    query = new StringBuffer();
                    query.append("UPDATE ");
                    query.append("address_city");
                    query.append(" SET ");
                    query.append("country_id=?, title=?, pos=?");
                    query.append(" WHERE ");
                    query.append("id=?");
                    ps = this.con.prepareStatement(query.toString());
                    ps.setInt(index++, addressCity.getCountryId());
                    ps.setString(index++, addressCity.getTitle());
                    ps.setInt(index++, addressCity.getPositionIndex());
                    ps.setInt(index++, addressCity.getId());
                    insertFlag = ps.executeUpdate() == 0;
                    ps.close();
                }
                if (insertFlag) {
                    index = 1;
                    query = new StringBuffer();
                    query.append("INSERT INTO ");
                    query.append("address_city");
                    query.append(" SET ");
                    if (addressCity.getId() > 0) {
                        query.append("id=?, ");
                    }
                    query.append("country_id=?, title=?, pos=?");
                    ps = this.con.prepareStatement(query.toString(), 1);
                    if (addressCity.getId() > 0) {
                        ps.setInt(index++, addressCity.getId());
                    }
                    ps.setInt(index++, addressCity.getCountryId());
                    ps.setString(index++, addressCity.getTitle());
                    ps.setInt(index++, addressCity.getPositionIndex());
                    ps.executeUpdate();
                    if (addressCity.getId() < 1) {
                        addressCity.setId(ServerUtils.lastInsertId(ps));
                    }
                    ps.close();
                }
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
    }

    public AddressArea getAddressArea(int id) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        AddressArea addressArea = null;
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("*");
        query.append(" FROM ");
        query.append("address_area");
        query.append(" WHERE ");
        query.append("id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressArea = new AddressArea();
            addressArea.setId(id);
            addressArea.setCityId(rs.getInt("cityid"));
            addressArea.setTitle(rs.getString("title"));
        }
        rs.close();
        ps.close();
        return addressArea;
    }

    public void updateArea(AddressArea addressArea) throws SQLException {
        if (addressArea != null) {
            StringBuffer query;
            int index;
            boolean insertFlag = true;
            PreparedStatement ps = null;
            if (addressArea.getId() > 0) {
                index = 1;
                query = new StringBuffer();
                query.append("UPDATE ");
                query.append("address_area");
                query.append(" SET ");
                query.append("cityid=?, title=?");
                query.append(" WHERE ");
                query.append("id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, addressArea.getCityId());
                ps.setString(index++, addressArea.getTitle());
                ps.setInt(index++, addressArea.getId());
                insertFlag = ps.executeUpdate() == 0;
                ps.close();
            }
            if (insertFlag) {
                index = 1;
                query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append("address_area");
                query.append(" SET ");
                if (addressArea.getId() > 0) {
                    query.append("id=?, ");
                }
                query.append("cityid=?, title=?");
                ps = this.con.prepareStatement(query.toString(), 1);
                if (addressArea.getId() > 0) {
                    ps.setInt(index++, addressArea.getId());
                }
                ps.setInt(index++, addressArea.getCityId());
                ps.setString(index++, addressArea.getTitle());
                ps.executeUpdate();
                if (addressArea.getId() < 1) {
                    addressArea.setId(ServerUtils.lastInsertId(ps));
                }
                ps.close();
            }
        }
    }

    public AddressQuarter getAddressQuarter(int id) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        AddressQuarter addressQuarter = null;
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("*");
        query.append(" FROM ");
        query.append("address_quarter");
        query.append(" WHERE ");
        query.append("id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressQuarter = new AddressQuarter();
            addressQuarter.setId(id);
            addressQuarter.setCityId(rs.getInt("cityid"));
            addressQuarter.setTitle(rs.getString("title"));
        }
        rs.close();
        ps.close();
        return addressQuarter;
    }

    public void updateQuarter(AddressQuarter addressQuarter) throws SQLException {
        if (addressQuarter != null) {
            StringBuffer query;
            int index;
            boolean insertFlag = true;
            PreparedStatement ps = null;
            if (addressQuarter.getId() > 0) {
                index = 1;
                query = new StringBuffer();
                query.append("UPDATE ");
                query.append("address_quarter");
                query.append(" SET ");
                query.append("cityid=?, title=?");
                query.append(" WHERE ");
                query.append("id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, addressQuarter.getCityId());
                ps.setString(index++, addressQuarter.getTitle());
                ps.setInt(index++, addressQuarter.getId());
                insertFlag = ps.executeUpdate() == 0;
                ps.close();
            }
            if (insertFlag) {
                index = 1;
                query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append("address_quarter");
                query.append(" SET ");
                if (addressQuarter.getId() > 0) {
                    query.append("id=?, ");
                }
                query.append("cityid=?, title=?");
                ps = this.con.prepareStatement(query.toString(), 1);
                if (addressQuarter.getId() > 0) {
                    ps.setInt(index++, addressQuarter.getId());
                }
                ps.setInt(index++, addressQuarter.getCityId());
                ps.setString(index++, addressQuarter.getTitle());
                ps.executeUpdate();
                if (addressQuarter.getId() < 1) {
                    addressQuarter.setId(ServerUtils.lastInsertId(ps));
                }
                ps.close();
            }
        }
    }

    public AddressStreet getAddressStreet(int id) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        AddressStreet addressStreet = null;
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("*");
        query.append(" FROM ");
        query.append("address_street");
        query.append(" WHERE ");
        query.append("id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            addressStreet = new AddressStreet();
            addressStreet.setId(id);
            addressStreet.setCityId(rs.getInt("cityid"));
            addressStreet.setTitle(rs.getString("title"));
        }
        rs.close();
        ps.close();
        return addressStreet;
    }

    public void updateStreet(AddressStreet addressStreet) throws SQLException {
        if (addressStreet != null) {
            StringBuffer query;
            int index;
            boolean insertFlag = true;
            PreparedStatement ps = null;
            if (addressStreet.getId() > 0) {
                index = 1;
                query = new StringBuffer();
                query.append("UPDATE ");
                query.append("address_street");
                query.append(" SET ");
                query.append("cityid=?, title=?");
                query.append(" WHERE ");
                query.append("id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, addressStreet.getCityId());
                ps.setString(index++, addressStreet.getTitle());
                ps.setInt(index++, addressStreet.getId());
                insertFlag = ps.executeUpdate() == 0;
                ps.close();
            }
            if (insertFlag) {
                index = 1;
                query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append("address_street");
                query.append(" SET ");
                if (addressStreet.getId() > 0) {
                    query.append("id=?, ");
                }
                query.append("cityid=?, title=?");
                ps = this.con.prepareStatement(query.toString(), 1);
                if (addressStreet.getId() > 0) {
                    ps.setInt(index++, addressStreet.getId());
                }
                ps.setInt(index++, addressStreet.getCityId());
                ps.setString(index++, addressStreet.getTitle());
                ps.executeUpdate();
                if (addressStreet.getId() < 1) {
                    addressStreet.setId(ServerUtils.lastInsertId(ps));
                }
                ps.close();
            }
        }
    }

    public AddressHouse getAddressHouse(int id) throws SQLException {
        AddressHouse addressHouse = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM address_house WHERE id=" + id);){
            addressHouse = this.getAddressHouseFromRs(ps.executeQuery());
        }
        return addressHouse;
    }

    private AddressHouse getAddressHouseFromRs(ResultSet rs) throws SQLException {
        AddressHouse addressHouse = null;
        if (rs.next()) {
            addressHouse = new AddressHouse();
            addressHouse.setId(rs.getInt("id"));
            addressHouse.setAreaId(rs.getInt("areaid"));
            addressHouse.setStreetId(rs.getInt("streetid"));
            addressHouse.setQuarterId(rs.getInt("quarterid"));
            addressHouse.setHouse(rs.getInt("house"));
            addressHouse.setFrac(rs.getString("frac"));
            addressHouse.setComment(rs.getString("comment"));
            addressHouse.setPostIndex(rs.getString("box_index"));
            addressHouse.setAmount(rs.getInt("amount"));
        }
        return addressHouse;
    }

    public void updateHouse(AddressHouse addressHouse) throws SQLException {
        if (addressHouse != null) {
            StringBuffer query;
            int index;
            boolean insertFlag = true;
            PreparedStatement ps = null;
            if (addressHouse.getId() > 0) {
                index = 1;
                query = new StringBuffer();
                query.append("UPDATE ");
                query.append("address_house");
                query.append(" SET ");
                query.append("areaid=?, quarterid=?, streetid=?, house=?, frac=?, comment=?, box_index=?, amount=?");
                query.append(" WHERE ");
                query.append("id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(index++, addressHouse.getAreaId());
                ps.setInt(index++, addressHouse.getQuarterId());
                ps.setInt(index++, addressHouse.getStreetId());
                ps.setInt(index++, addressHouse.getHouse());
                ps.setString(index++, addressHouse.getFrac());
                ps.setString(index++, addressHouse.getComment());
                ps.setString(index++, addressHouse.getPostIndex());
                ps.setInt(index++, addressHouse.getAmount());
                ps.setInt(index++, addressHouse.getId());
                insertFlag = ps.executeUpdate() == 0;
                ps.close();
            }
            if (insertFlag) {
                index = 1;
                query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append("address_house");
                query.append(" SET ");
                if (addressHouse.getId() > 0) {
                    query.append("id=?, ");
                }
                query.append("areaid=?, quarterid=?, streetid=?, house=?, frac=?, comment=?, box_index=?, amount=?");
                ps = this.con.prepareStatement(query.toString(), 1);
                if (addressHouse.getId() > 0) {
                    ps.setInt(index++, addressHouse.getId());
                }
                ps.setInt(index++, addressHouse.getAreaId());
                ps.setInt(index++, addressHouse.getQuarterId());
                ps.setInt(index++, addressHouse.getStreetId());
                ps.setInt(index++, addressHouse.getHouse());
                ps.setString(index++, addressHouse.getFrac());
                ps.setString(index++, addressHouse.getComment());
                ps.setString(index++, addressHouse.getPostIndex());
                ps.setInt(index++, addressHouse.getAmount());
                ps.executeUpdate();
                if (addressHouse.getId() < 1) {
                    addressHouse.setId(ServerUtils.lastInsertId(ps));
                }
                ps.close();
            }
        }
    }

    public void deleteCityRows() throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append("address_city");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
    }

    public void deleteAreaRows() throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append("address_area");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
    }

    public void deleteStreetRows() throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append("address_street");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
    }

    public void deleteQuarterRows() throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append("address_quarter");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
    }

    public void deleteHouseRows() throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("DELETE FROM ");
        query.append("address_house");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.executeUpdate();
        ps.close();
    }
}

