/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.processors;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.bean.ContractPattern;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.ObjectManager;
import java.sql.Connection;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.LocalEvent;
import ru.bitel.bgbilling.kernel.event.events.system.CommonEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractSerializeEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class CommonKernelEventProcessor
implements EventListener<LocalEvent> {
    private Logger logger = Logger.getLogger(CommonKernelEventProcessor.class);
    private ModuleCache moduleCache = ModuleCache.getInstance();

    public CommonKernelEventProcessor(Setup setup) throws BGException {
        EventProcessor ep = EventProcessor.getInstance();
        if (setup.get("no.event.process", null) == null) {
            ep.addListener(this, CommonEvent.class);
            ep.addListener(this, ContractCloseEvent.class);
            ep.addListener(this, ContractCreateEvent.class);
            ep.addListener(this, ContractDeleteEvent.class, 0, null);
            ep.addListener(this, ContractSerializeEvent.class);
            ep.addListener(this, ContractWrapEvent.class);
            ep.addListener(this, ObjectMoveEvent.class);
            for (final BGModule module : this.moduleCache.getModulesList()) {
                ep.addListener(new EventListener<ContractDeleteEvent>(){

                    @Override
                    public void notify(ContractDeleteEvent event, EventListenerContext ctx) throws BGException {
                        try {
                            CommonKernelEventProcessor.this.moduleCache.getApplicationModule(module.getName()).moduleAction(ctx, module.getId(), event);
                        }
                        catch (Exception e) {
                            throw new BGException(e);
                        }
                    }
                }, ContractDeleteEvent.class, module.getId(), null);
            }
        }
    }

    @Override
    public void notify(LocalEvent event, EventListenerContext ctx) throws BGException {
        int contractId = event.getContractId();
        this.logger.info((Object)("Process event cid:" + contractId + "; event:" + event.toString()));
        ConnectionSet connectionSet = ctx.getConnectionSet();
        Connection con = connectionSet.getConnection();
        try {
            if (event.getModuleId() <= 0) {
                ContractCloseEvent ccEvent;
                Set<Object> moduleSet = new HashSet();
                if (event instanceof ContractCreateEvent && ((ContractCreateEvent)event).isCheck()) {
                    ContractPattern contractPattern = ((ContractCreateEvent)event).getPattern();
                    List<String> moduleIdStrings = contractPattern.getModuleList();
                    moduleSet = new HashSet();
                    int size = moduleIdStrings.size();
                    for (int i = 0; i < size; ++i) {
                        int moduleId = Utils.parseInt(moduleIdStrings.get(i), 0);
                        if (moduleId <= 0) continue;
                        moduleSet.add(moduleId);
                    }
                } else {
                    ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(connectionSet, (Integer)contractId);
                    if (contractRuntime != null) {
                        moduleSet = contractRuntime.getModuleIds();
                    }
                }
                List<BGModule> moduleEventList = this.moduleCache.getModulesListProcessSorted(moduleSet);
                if (event instanceof ContractCloseEvent && !(ccEvent = (ContractCloseEvent)event).isCheck()) {
                    ObjectManager om = new ObjectManager(con);
                    List<ContractObject> objectList = om.getObjectList(event.getContractId());
                    Calendar closeDate = TimeUtils.convertDateToCalendar(ccEvent.getDate());
                    for (ContractObject o : objectList) {
                        if (o.getDate2() != null) continue;
                        o.setDate2(closeDate);
                        om.updateObject(o);
                    }
                }
                for (BGModule module : moduleEventList) {
                    ApplicationModule applicationModule;
                    if (module == null || (applicationModule = this.moduleCache.getApplicationModule(module.getName())) == null) continue;
                    applicationModule.moduleAction(ctx, module.getId(), event);
                }
            } else {
                this.logger.error((Object)"Not supported event!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BGException(e);
        }
    }
}

