/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.hourly;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogEntry;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLog;
import ru.bitel.common.ParameterMap;

public class IPHourlyDataLogEntry
extends HourlyDataLogEntry<IPDataLog> {
    public IPHourlyDataLogEntry(ParameterMap setup, String logDirParamName, int sourceId, String sourceConfig, String type, Calendar hour, Map<DataLog.Parameter<?>, Object> parameters) throws IOException {
        super(setup, logDirParamName, sourceId, sourceConfig, type, hour, parameters);
    }

    @Override
    protected IPDataLog create(int id, File file, RandomAccessFile raf, String type, ParameterMap params) {
        int defaultStrategy;
        int defaultLevel;
        IPDataLog dataLog = new IPDataLog(id, file, raf, raf.getChannel());
        IPDataLog.IPDataLogType logType = new IPDataLog.IPDataLogType();
        logType.logSubType = 0;
        logType.logSubTypeVersion = 0;
        BGDataLog.Compression compression = new BGDataLog.Compression();
        compression.type = params.getInt("datalog.compression.type", 1);
        switch (compression.type) {
            case 1: {
                defaultLevel = 5;
                defaultStrategy = 1;
                break;
            }
            case 3: {
                defaultLevel = 3;
                defaultStrategy = 0;
                break;
            }
            default: {
                defaultLevel = 5;
                defaultStrategy = 0;
            }
        }
        compression.level = params.getInt("datalog.compression.level", defaultLevel);
        compression.strategy = params.getInt("datalog.compression.strategy", defaultStrategy);
        BGDataLog.Buffer buffer = new BGDataLog.Buffer();
        if ("sflow".equals(type)) {
            logType.logType = logType.SFLOW;
            buffer.type = buffer.CHUNKED;
            buffer.size = params.getInt("datalog.flow.chunk.size", params.getInt("datalog.chunk.size", 524288));
            compression.type = params.getInt("datalog.flow.compression.type", compression.type);
            compression.level = params.getInt("datalog.flow.compression.level", compression.level);
            compression.strategy = params.getInt("datalog.flow.compression.strategy", compression.strategy);
        } else if ("snmp".equals(type)) {
            logType.logType = logType.SNMP;
            logType.logSubType = 1;
            logType.logSubTypeVersion = 1;
            buffer.type = buffer.NONE;
            buffer.size = params.getInt("datalog.snmp.buffer.size", params.getInt("datalog.buffer.size", 2048));
            buffer.size -= buffer.size % 76;
            compression.type = params.getInt("datalog.snmp.compression.type", compression.type);
            compression.level = params.getInt("datalog.snmp.compression.level", compression.level);
            compression.strategy = params.getInt("datalog.snmp.compression.strategy", compression.strategy);
        } else if ("netflow9".equals(type)) {
            logType.logType = logType.NETFLOW9;
            buffer.type = buffer.CHUNKED;
            buffer.size = params.getInt("datalog.flow.chunk.size", params.getInt("datalog.chunk.size", 524288));
            compression.type = params.getInt("datalog.flow.compression.type", compression.type);
            compression.level = params.getInt("datalog.flow.compression.level", compression.level);
            compression.strategy = params.getInt("datalog.flow.compression.strategy", compression.strategy);
        } else if ("ipfix".equals(type)) {
            logType.logType = logType.IPFIX;
            buffer.type = buffer.CHUNKED;
            buffer.size = params.getInt("datalog.flow.chunk.size", params.getInt("datalog.chunk.size", 524288));
            compression.type = params.getInt("datalog.flow.compression.type", compression.type);
            compression.level = params.getInt("datalog.flow.compression.level", compression.level);
            compression.strategy = params.getInt("datalog.flow.compression.strategy", compression.strategy);
        } else {
            logType.logType = logType.NETFLOW;
            buffer.type = buffer.CHUNKED;
            buffer.size = params.getInt("datalog.flow.chunk.size", params.getInt("datalog.chunk.size", 524288));
            compression.type = params.getInt("datalog.flow.compression.type", compression.type);
            compression.level = params.getInt("datalog.flow.compression.level", compression.level);
            compression.strategy = params.getInt("datalog.flow.compression.strategy", compression.strategy);
        }
        dataLog.setParameter(IPDataLog.BUFFER, buffer);
        dataLog.setParameter(IPDataLog.IP_DATALOG_TYPE, logType);
        dataLog.setParameter(IPDataLog.COMPRESSION, compression);
        dataLog.setParameter(IPDataLog.DISTRIBUTED, new BGDataLog.Distributed());
        return dataLog;
    }
}

