/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLog;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Array;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Record;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.Netflow9Processor;

public class Netflow9DataLogReader
extends BGDataLogReader<IPDataLog>
implements FlowReader {
    private static final Logger log = Logger.getLogger(Netflow9DataLogReader.class);
    protected final NetFlow9Array recordList;
    private final ConcurrentMap<Integer, NetFlow9Template> templates;

    public Netflow9DataLogReader(IPDataLog dataLog) {
        super(dataLog);
        this.templates = Netflow9DataLogReader.getTemplates(dataLog);
        this.readBuffer.position(this.readBuffer.capacity());
        int recordSize = 30;
        int size = this.readBuffer.capacity() / recordSize;
        this.recordList = new NetFlow9Array(size);
    }

    private static ConcurrentMap<Integer, NetFlow9Template> getTemplates(IPDataLog dataLog) {
        ConcurrentMap<Object, Object> attributeMap = dataLog.getAttributeMap();
        ConcurrentHashMap<Integer, NetFlow9Template> templates = (ConcurrentHashMap<Integer, NetFlow9Template>)attributeMap.get("netflow9Templates");
        if (templates == null) {
            ConcurrentHashMap<Integer, NetFlow9Template> newTemplates = new ConcurrentHashMap<Integer, NetFlow9Template>();
            IPDataLog.Netflow9Templates paramTemplates = dataLog.getParameter(IPDataLog.NETFLOW9_TEMPLATES);
            if (paramTemplates != null && paramTemplates.templates != null) {
                newTemplates.putAll(paramTemplates.templates);
            }
            if ((templates = (ConcurrentMap)attributeMap.putIfAbsent("netflow9Templates", newTemplates)) == null) {
                templates = newTemplates;
            }
        }
        return templates;
    }

    public FlowArray<NetFlow9Record> readChunk() {
        if (!this.readNext()) {
            return null;
        }
        try {
            int offset = this.recordList.next(this.readBuffer, this.templates);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Readed chunk: [flowCount=" + this.recordList.size + "]"));
            }
            this.readBuffer.position(offset);
        }
        catch (Exception e) {
            log.error((Object)((IPDataLog)this.dataLog).getFile());
            log.error((Object)"Exception", (Throwable)e);
            this.readBuffer.position(this.readBuffer.limit());
        }
        return this.recordList;
    }

    public boolean processChunk(Netflow9Processor processor) {
        if (!this.readNext()) {
            return false;
        }
        try {
            int offset = NetFlow9Array.next(this.readBuffer, this.templates, processor);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed chunk: [offset = " + offset + "]"));
            }
            if (offset > this.readBuffer.limit()) {
                offset = this.readBuffer.limit();
            }
            this.readBuffer.position(offset);
        }
        catch (Exception e) {
            log.error((Object)((IPDataLog)this.dataLog).getFile());
            log.error((Object)"Exception", (Throwable)e);
            this.readBuffer.position(this.readBuffer.limit());
        }
        return true;
    }
}

